/*
 * Decompiled with CFR 0.152.
 */
package utils;

import engine.Cell;
import engine.RandomVariable;
import java.util.Hashtable;
import utils.AnalyticFunction1D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TgtFusionModel5Function1D
extends AnalyticFunction1D {
    private double p_tgt_mot(int x_i, int y_i, int s_i, int x_m, int y_m, int s_m) {
        double sigma = this.getFunctionParameters()[0][0];
        if (s_i == s_m && (double)((x_i - x_m) * (x_i - x_m) + (y_i - y_m) * (y_i - y_m)) <= 9.0 * sigma * sigma) {
            return StrictMath.exp(-0.5 * (double)((x_i - x_m) * (x_i - x_m) + (y_i - y_m) * (y_i - y_m)) / sigma / sigma);
        }
        return 1.0;
    }

    @Override
    public double computeValueFor(Hashtable<String, RandomVariable> vars, Object param) throws Exception {
        int x_mot = this.getPar6(vars).getListVar(0);
        int y_mot = this.getPar6(vars).getListVar(1);
        int s_mot = this.getPar6(vars).getListVar(2);
        if (Cell.gridCells[s_mot][x_mot][y_mot].isInsideTheGrid) {
            return 0.0;
        }
        int x_1 = this.getPar1(vars).getListVar(0);
        int y_1 = this.getPar1(vars).getListVar(1);
        int s_1 = this.getPar1(vars).getListVar(2);
        int x_2 = this.getPar2(vars).getListVar(0);
        int y_2 = this.getPar2(vars).getListVar(1);
        int s_2 = this.getPar2(vars).getListVar(2);
        int x_3 = this.getPar3(vars).getListVar(0);
        int y_3 = this.getPar3(vars).getListVar(1);
        int s_3 = this.getPar3(vars).getListVar(2);
        int x_4 = this.getPar4(vars).getListVar(0);
        int y_4 = this.getPar4(vars).getListVar(1);
        int s_4 = this.getPar4(vars).getListVar(2);
        int x_5 = this.getPar5(vars).getListVar(0);
        int y_5 = this.getPar5(vars).getListVar(1);
        int s_5 = this.getPar5(vars).getListVar(2);
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double num = 1.0;
        num *= this.p_tgt_mot(x_1, y_1, s_1, x_mot, y_mot, s_mot);
        num *= this.p_tgt_mot(x_2, y_2, s_2, x_mot, y_mot, s_mot);
        num *= this.p_tgt_mot(x_3, y_3, s_3, x_mot, y_mot, s_mot);
        num *= this.p_tgt_mot(x_4, y_4, s_4, x_mot, y_mot, s_mot);
        num *= this.p_tgt_mot(x_5, y_5, s_5, x_mot, y_mot, s_mot);
        double denom = 0.0;
        double tmp = 1.0;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        tmp = 1.0;
                        tmp *= this.p_tgt_mot(x_1, y_1, s_1, i, j, s);
                        tmp *= this.p_tgt_mot(x_2, y_2, s_2, i, j, s);
                        tmp *= this.p_tgt_mot(x_3, y_3, s_3, i, j, s);
                        tmp *= this.p_tgt_mot(x_4, y_4, s_4, i, j, s);
                        denom += (tmp *= this.p_tgt_mot(x_5, y_5, s_5, i, j, s));
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        return num / denom;
    }

    @Override
    public void reset(Hashtable<String, RandomVariable> vars, Object param) {
    }
}

