/*
 * Decompiled with CFR 0.152.
 */
package utils;

import engine.RandomVariable;
import java.util.Hashtable;
import utils.GridAnalyticFunction1D;
import utils.GridReferenceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetFusionFunction1D
extends GridAnalyticFunction1D {
    private static final long serialVersionUID = -6212032014884429800L;

    @Override
    public final double computeValueFor(Hashtable<String, RandomVariable> vars, GridReferenceConverter rConv) throws Exception {
        int occ = this.getPar1(vars).getListVar(0);
        double x = rConv.xBasic(this.getPar2(vars).getListVar(0));
        double y = rConv.yBasic(this.getPar2(vars).getListVar(1));
        int s = this.getPar2(vars).getListVar(2);
        double tx = rConv.xBasic(this.getPar3(vars).getListVar(0));
        double ty = rConv.yBasic(this.getPar3(vars).getListVar(1));
        int ts = this.getPar3(vars).getListVar(2);
        double[][] params = this.getFunctionParameters();
        double sigma = 1.0;
        double vmax = 0.95;
        if (params.length >= 1) {
            sigma = params[0][0];
        }
        if (params.length >= 2) {
            vmax = params[1][0];
        }
        if (s != ts) {
            return 1.0;
        }
        return 2.0 * (0.5 + ((double)(2 * occ) - 1.0) / (1.0 / (vmax - 0.5) + (StrictMath.pow((tx - x) / sigma, 2.0) + StrictMath.pow((ty - y) / sigma, 2.0))));
    }

    @Override
    public final void reset(Hashtable<String, RandomVariable> vars, Object param) {
    }
}

