/*
 * Decompiled with CFR 0.152.
 */
package utils;

import utils.AnalyticFunction2D;

public class Position {
    private static AnalyticFunction2D myRef1ToRef2Function;
    private static AnalyticFunction2D myRef2ToRef1Function;
    private double myX1;
    private double myY1;
    private double myX2;
    private double myY2;

    private static final AnalyticFunction2D getRef2ToRef1Function() {
        return myRef2ToRef1Function;
    }

    private static final void setRef2ToRef1Function(AnalyticFunction2D ref2ToRef1Function) {
        myRef2ToRef1Function = ref2ToRef1Function;
    }

    private static final AnalyticFunction2D getRef1ToRef2Function() {
        return myRef1ToRef2Function;
    }

    private static final void setRef1ToRef2Function(AnalyticFunction2D ref1ToRef2Function) {
        myRef1ToRef2Function = ref1ToRef2Function;
    }

    public final double getX1() {
        return this.myX1;
    }

    public final double getY1() {
        return this.myY1;
    }

    public final double getX2() {
        return this.myX2;
    }

    public final double getY2() {
        return this.myY2;
    }

    public final void setX1(double X1) {
        this.myX1 = X1;
        this.updateCoordinatesFromRef1();
    }

    public final void setY1(double Y1) {
        this.myY1 = Y1;
        this.updateCoordinatesFromRef1();
    }

    public final void setX2(double X2) {
        this.myX2 = X2;
        this.updateCoordinatesFromRef2();
    }

    public final void setY2(double Y2) {
        this.myY2 = Y2;
        this.updateCoordinatesFromRef2();
    }

    private final void setX2WithoutChanges(double X2) {
        this.myX2 = X2;
    }

    private final void setY2WithoutChanges(double Y2) {
        this.myY2 = Y2;
    }

    private final void setX1WithoutChanges(double X1) {
        this.myX1 = X1;
    }

    private final void setY1WithoutChanges(double Y1) {
        this.myY1 = Y1;
    }

    public Position(Position pos) {
        this.setX1WithoutChanges(pos.getX1());
        this.setY1WithoutChanges(pos.getY1());
        this.updateCoordinatesFromRef1();
    }

    public Position(double x, double y, boolean coordRef1) {
        if (coordRef1) {
            this.setX1WithoutChanges(x);
            this.setY1WithoutChanges(y);
            this.updateCoordinatesFromRef1();
        } else {
            this.setX2WithoutChanges(x);
            this.setY2WithoutChanges(y);
            this.updateCoordinatesFromRef2();
        }
    }

    public static void init(String[] refFctNames, String[] fctParamaters) {
        AnalyticFunction2D fct1 = AnalyticFunction2D.createFunction(refFctNames[0], fctParamaters[0]);
        AnalyticFunction2D fct2 = AnalyticFunction2D.createFunction(refFctNames[1], fctParamaters[1]);
        Position.setRef1ToRef2Function(fct1);
        Position.setRef2ToRef1Function(fct2);
    }

    private final void updateCoordinatesFromRef1() {
        double[] HV = new double[2];
        double[] XY = new double[2];
        if (this.getX1() >= 0.0) {
            HV[0] = this.getX1();
            HV[1] = this.getY1();
            XY = Position.getRef1ToRef2Function().computeValueFor(HV);
        } else {
            HV[0] = -this.getX1();
            HV[1] = this.getY1();
            XY = Position.getRef1ToRef2Function().computeValueFor(HV);
            XY[0] = -XY[0];
        }
        this.setX2WithoutChanges(XY[0]);
        this.setY2WithoutChanges(XY[1]);
        if (this.getX2() >= 0.0) {
            XY[0] = this.getX2();
            XY[1] = this.getY2();
            HV = Position.getRef2ToRef1Function().computeValueFor(XY);
        } else {
            XY[0] = -this.getX2();
            XY[1] = this.getY2();
            HV = Position.getRef2ToRef1Function().computeValueFor(XY);
            HV[0] = -HV[0];
        }
        HV[0] = HV[0] * 180.0 / Math.PI;
        HV[1] = HV[1] * 180.0 / Math.PI;
        this.setX1WithoutChanges(HV[0]);
        this.setY1WithoutChanges(HV[1]);
    }

    private final void updateCoordinatesFromRef2() {
        double[] XY = new double[2];
        double[] HV = new double[2];
        if (this.getX2() >= 0.0) {
            XY[0] = this.getX2();
            XY[1] = this.getY2();
            HV = Position.getRef2ToRef1Function().computeValueFor(XY);
        } else {
            XY[0] = -this.getX2();
            XY[1] = this.getY2();
            HV = Position.getRef2ToRef1Function().computeValueFor(XY);
            HV[0] = -HV[0];
        }
        HV[0] = HV[0] * 180.0 / Math.PI;
        HV[1] = HV[1] * 180.0 / Math.PI;
        this.setX1WithoutChanges(HV[0]);
        this.setY1WithoutChanges(HV[1]);
        if (this.getX1() >= 0.0) {
            HV[0] = this.getX1();
            HV[1] = this.getY1();
            XY = Position.getRef1ToRef2Function().computeValueFor(HV);
        } else {
            HV[0] = -this.getX1();
            HV[1] = this.getY1();
            XY = Position.getRef1ToRef2Function().computeValueFor(HV);
            XY[0] = -XY[0];
        }
        this.setX2WithoutChanges(XY[0]);
        this.setY2WithoutChanges(XY[1]);
    }

    public final void applyRef1Translation(Position pos_t, boolean invers) {
        if (!invers) {
            this.setX1WithoutChanges(this.getX1() - pos_t.getX1());
            this.setY1WithoutChanges(this.getY1() - pos_t.getY1());
        } else {
            this.setX1WithoutChanges(this.getX1() + pos_t.getX1());
            this.setY1WithoutChanges(this.getY1() + pos_t.getY1());
        }
        this.updateCoordinatesFromRef1();
    }

    public final String toString() {
        String s = "<Position ";
        s = String.valueOf(s) + String.format(" Ref1: (%2.6f %2.6f)", this.getX1(), this.getY1());
        s = String.valueOf(s) + String.format(" Ref2: (%2.6f %2.6f)", this.getX2(), this.getY2());
        s = String.valueOf(s) + ">";
        return s;
    }
}

