/*
 * Decompiled with CFR 0.152.
 */
package test;

import engine.GPD_Table4D;
import engine.RandomVariable;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.GridReferenceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProbabilisticDistribution {
    private int gridw;
    private int gridh;
    private GPD_Table4D double_gpd;

    @Before
    public void setUp() throws Exception {
        double[] xrang = new double[]{0.0, 4.8, 1.0};
        double[] yrang = new double[]{-2.9, 2.9, 1.0};
        double cellw = 0.2;
        double cellh = 0.2;
        this.gridw = (int)StrictMath.rint((xrang[1] - xrang[0]) / cellw);
        this.gridh = (int)StrictMath.rint((yrang[1] - yrang[0]) / cellh);
        GridReferenceConverter r_ref_conv = new GridReferenceConverter(true);
        r_ref_conv.init(xrang[0], yrang[0], xrang[1], yrang[1], this.gridw, this.gridh);
        this.double_gpd = new GPD_Table4D(r_ref_conv);
    }

    @Test
    public void verifyInit() throws Exception {
        Hashtable<String, String> params = this.getBasicParams();
        Hashtable<String, RandomVariable> vars = this.getBasicVariables();
        params.put("knownNames", "Sacc^t");
        params.put("searchNames", "Sacc^{t+1}");
        this.double_gpd.init(params);
        Assert.assertEquals((String)"Bad name", (Object)"P(Sacc^{t+1}|Sacc^t)", (Object)this.double_gpd.getName());
        double[][] values = this.double_gpd.getProbaGrid(vars, "Sacc^{t+1}");
        Assert.assertEquals((String)"Bad nb of columns", (Object)this.gridw, (Object)values.length);
        Assert.assertEquals((String)"Bad nb of lines", (Object)this.gridh, (Object)values[0].length);
    }

    private Hashtable<String, String> getBasicParams() {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "0.1");
        return params;
    }

    private Hashtable<String, RandomVariable> getBasicVariables() {
        Hashtable<String, RandomVariable> vars = new Hashtable<String, RandomVariable>();
        int[] var1_init = new int[]{1, 2};
        int[] var2_init = new int[]{3, 4};
        int[][] domain = new int[][]{new int[this.gridw], new int[this.gridh]};
        int i = 0;
        while (i < domain[0].length) {
            domain[0][i] = i;
            ++i;
        }
        i = 0;
        while (i < domain[1].length) {
            domain[1][i] = i;
            ++i;
        }
        RandomVariable var1 = new RandomVariable(var1_init, "Sacc^t", domain);
        RandomVariable var2 = new RandomVariable(var2_init, "Sacc^{t+1}", domain);
        vars.put(var1.getName(), var1);
        vars.put(var2.getName(), var2);
        return vars;
    }
}

