/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.Position;

public class TestPosition {
    @Before
    public void setUp() throws Exception {
        String[] fctNames = new String[]{"CollicularLogFunction2D", "CollicularReverseLogFunction2D"};
        String[] fctParams = new String[]{"1.4,1.8,0.05235987755982988", "1.4,1.8,0.05235987755982988"};
        Position.init(fctNames, fctParams);
    }

    @Test
    public void verifyInit() {
        Position pos1 = new Position(-4.66, 2.79, false);
        System.out.println(pos1);
    }

    @Test
    public void verifyIdentityByComposition() {
        int nb_valeurs = 100;
        double err_max = 0.001;
        double[] x1range = new double[]{0.0, 80.0};
        double[] y1range = new double[]{-40.0, 40.0};
        double[] x2range = new double[]{0.0, 5.0};
        double[] y2range = new double[]{-4.0, 4.0};
        Random R = new Random(15091977L);
        String msg1 = "Fct de transfert non-bijective (fof^-1 != id)";
        int i = 0;
        while (i < nb_valeurs) {
            double x1 = (x1range[1] - x1range[0]) * R.nextDouble() + x1range[0];
            double y1 = (y1range[1] - y1range[0]) * R.nextDouble() + y1range[0];
            Position pos1 = new Position(x1, y1, true);
            Position pos2 = new Position(pos1.getX2(), pos1.getY2(), false);
            String s = "\nPosition1 : <- init (X1, Y1)";
            s = String.valueOf(s) + "\nPosition2 : <- init(Position1.X2, Position1.Y2)";
            s = String.valueOf(s) + "\nPosition1 : " + pos1 + "\nPosition2 :" + pos2;
            if (pos2.getX1() - pos1.getX1() > err_max || pos2.getY1() - pos1.getY1() > err_max) {
                Assert.assertNotNull((String)(String.valueOf(msg1) + s), null);
            }
            ++i;
        }
        String msg2 = "Fct de transfert non-bijective (f^-1of != id)";
        int i2 = 0;
        while (i2 < nb_valeurs) {
            double x2 = (x2range[1] - x2range[0]) * R.nextDouble() + x2range[0];
            double y2 = (y2range[1] - y2range[0]) * R.nextDouble() + y2range[0];
            Position pos1 = new Position(x2, y2, false);
            Position pos2 = new Position(pos1.getX1(), pos1.getY1(), true);
            String s = "\nPosition1 : <- init (X2, Y2, false)";
            s = String.valueOf(s) + "\nPosition2 : <- init(Position1.X1, Position1.Y1, true)";
            s = String.valueOf(s) + "\nPosition1 : " + pos1 + "\nPosition2 : " + pos2;
            if (pos2.getX2() - pos1.getX2() > err_max || pos2.getY2() - pos1.getY2() > err_max) {
                Assert.assertNotNull((String)(String.valueOf(msg2) + s), null);
            }
            ++i2;
        }
    }
}

