/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import utils.GridReferenceConverter;

public class TestGridReferenceConverter {
    private GridReferenceConverter gridRConv = new GridReferenceConverter(true);

    @Before
    public void setUp() throws Exception {
        double[] xrang = new double[]{0.0, 4.8, 1.0};
        double[] yrang = new double[]{-2.9, 2.9, 1.0};
        double cellw = 0.2;
        double cellh = 0.2;
        int gridw = (int)StrictMath.rint((xrang[1] - xrang[0]) / cellw);
        int gridh = (int)StrictMath.rint((yrang[1] - yrang[0]) / cellh);
        this.gridRConv.init(xrang[0], yrang[0], xrang[1], yrang[1], gridw, gridh);
    }

    @Test
    public void verifyIdentityByComposition() {
        int nb_valeurs = 100;
        double err_max = 0.1;
        double[] xrang = new double[]{0.0, 4.8, 1.0};
        double[] yrang = new double[]{-2.9, 2.9, 1.0};
        Random R = new Random(15091978L);
        String msg1 = "Fct de transfert non-bijective (fof^-1 != id)";
        int i = 0;
        while (i < nb_valeurs) {
            int posx1 = R.nextInt(this.gridRConv.getPixelWidth());
            int posy1 = R.nextInt(this.gridRConv.getPixelHeight());
            double x = this.gridRConv.xBasic(posx1);
            double y = this.gridRConv.yBasic(posy1);
            int posx2 = this.gridRConv.xPixel(x);
            int posy2 = this.gridRConv.yPixel(y);
            String s = "\nPosition1 = x1,y1";
            s = String.valueOf(s) + "\nPosition2 = xPixel(xBasic(posx1)), yPixel(yBasic(posy1))";
            s = String.valueOf(s) + "\nPosition1 : (" + posx1 + "," + posy1 + ")" + "\nPosition2 : (" + posx2 + "," + posy2 + ")";
            if (posx2 != posx1 || posy2 != posy1) {
                Assert.assertNotNull((String)(String.valueOf(msg1) + s), null);
            }
            ++i;
        }
        String msg2 = "Fct de transfert non-bijective (f^-1of != id)";
        int i2 = 0;
        while (i2 < nb_valeurs) {
            double x1 = (xrang[1] - xrang[0]) * R.nextDouble() + xrang[0];
            double y1 = (yrang[1] - yrang[0]) * R.nextDouble() + yrang[0];
            int posx = this.gridRConv.xPixel(x1);
            int posy = this.gridRConv.yPixel(y1);
            double x2 = this.gridRConv.xBasic(posx);
            double y2 = this.gridRConv.yBasic(posy);
            String s = "\nPosition1 = x1,y1";
            s = String.valueOf(s) + "\nPosition2 = xBasic(xPixel(posx1)), yBasic(yPixel(posy1))";
            s = String.valueOf(s) + "\nPosition1 : (" + x1 + "," + y1 + ")" + "\nPosition2 : (" + x2 + "," + y2 + ")";
            if (x2 - x1 > err_max || y2 - y1 > err_max) {
                Assert.assertNotNull((String)(String.valueOf(msg2) + s), null);
            }
            ++i2;
        }
    }
}

