/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Controller;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.MVC_SpotEvent;
import gui.Model;
import gui.Spot;
import gui.SpotType;
import gui.View;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import utils.Position;
import utils.ReferenceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapView
extends JPanel
implements View,
Controller,
ActionListener,
MouseListener,
MouseMotionListener,
ComponentListener,
MouseWheelListener,
KeyListener {
    private int myGridTimeStep;
    private Position myCenterPointView;
    private double myZoom = 20.0;
    private float myFontSize = 10.0f;
    private Vector<Spot> mySpots = new Vector();
    private boolean traceLegendFlag;
    private Spot myCurrentSelectedSpot;
    private ReferenceConverter myRefConverter;
    protected Vector<Model> myModels = new Vector();

    protected int getGridTimeStep() {
        return this.myGridTimeStep;
    }

    protected void setGridTimeStep(int gridTimeStep) {
        this.myGridTimeStep = gridTimeStep;
    }

    protected final Position getCenterPointView() {
        return this.myCenterPointView;
    }

    protected final void setCenterPointView(Position center) {
        this.myCenterPointView = center;
    }

    protected final double getZoom() {
        return this.myZoom;
    }

    protected final void setZoom(double zoom) {
        this.myZoom = zoom;
    }

    protected final float getFontSize() {
        return this.myFontSize;
    }

    protected final void setFontSize(float fontSize) {
        this.myFontSize = fontSize;
    }

    protected Vector<Spot> getSpots() {
        return this.mySpots;
    }

    protected boolean isTraceLegendFlag() {
        return this.traceLegendFlag;
    }

    protected void setTraceLegendFlag(boolean traceLegendFlag) {
        this.traceLegendFlag = traceLegendFlag;
    }

    private final Spot getCurrentSelectedSpot() {
        return this.myCurrentSelectedSpot;
    }

    protected final void setCurrentSelectedPos(Spot currentSelectedSpot) {
        this.myCurrentSelectedSpot = currentSelectedSpot;
    }

    protected final ReferenceConverter getRefConverter() {
        return this.myRefConverter;
    }

    protected final void setRefConverter(ReferenceConverter myRefConv) {
        this.myRefConverter = myRefConv;
    }

    @Override
    public Vector<Model> getAssociatedModels() {
        return this.myModels;
    }

    public MapView() {
        this.setOpaque(true);
        this.setTraceLegendFlag(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.setBackground(Color.black);
    }

    protected final void actualiseSize() {
        this.subActualiseSize();
        for (Spot crtS : this.getSpots()) {
            crtS.xSize = this.getRefConverter().xPixelDist(crtS.size);
            crtS.ySize = this.getRefConverter().yPixelDist(crtS.size);
        }
    }

    protected abstract void subActualiseSize();

    @Override
    public boolean performedM_VC_Event(MVC_Event aMVCEvt) {
        aMVCEvt.traceDebug(String.valueOf(this.getClass().getName()) + "::performedM_VC_Event");
        switch (aMVCEvt.getIdentity()) {
            case CENTER_RESET: {
                this.setCenterPointView(null);
                this.actualiseSize();
                this.repaint();
                return true;
            }
            case LOAD: {
                this.repaint();
                return true;
            }
            case MARK_ADD: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.getSpots().add(new Spot(sEvt.hashCode, sEvt.position, sEvt.label));
                this.repaint();
                return true;
            }
            case MARK_MOV: {
                this.moveSpot((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case MARK_REM: {
                this.removeSpot((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case SACC_ADD: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.getSpots().add(new Spot(sEvt.hashCode, sEvt.position, 0));
                this.repaint();
                return true;
            }
            case SACC_MOV: {
                this.moveSpot((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case SACC_REM: {
                this.removeSpot((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case SPOT_SEL: {
                int hash = ((MVC_SpotEvent)aMVCEvt).hashCode;
                for (Spot crtS : this.getSpots()) {
                    if (crtS.refHashcode == hash) {
                        if (crtS.selected) {
                            this.setCurrentSelectedPos(null);
                            crtS.selected = false;
                            continue;
                        }
                        this.setCurrentSelectedPos(crtS);
                        crtS.selected = true;
                        continue;
                    }
                    crtS.selected = false;
                }
                this.repaint();
                return true;
            }
            case OBSERVATION_ADD: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.getSpots().add(new Spot(sEvt.size, sEvt.hashCode, sEvt.position, false));
                this.actualiseSize();
                this.repaint();
                return true;
            }
            case OBSERVATION_MOV: {
                this.moveSpot((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case OBSERVATION_REM: {
                this.removeSpot((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case OBSERVATION_SIZE_UPD: {
                this.changeSpotSize((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case TARGET_ADD: {
                MVC_SpotEvent sEvt = (MVC_SpotEvent)aMVCEvt;
                this.getSpots().add(new Spot(sEvt.size, sEvt.hashCode, sEvt.position, true));
                this.actualiseSize();
                this.repaint();
                return true;
            }
            case TARGET_MOV: {
                this.moveSpot((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case TARGET_REM: {
                this.removeSpot((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case TARGET_SIZE_UPD: {
                this.changeSpotSize((MVC_SpotEvent)aMVCEvt);
                return true;
            }
            case TOOLTIP_INFOS: {
                this.setToolTipText(aMVCEvt.getInfo());
                return true;
            }
            case UPTIME: {
                this.setGridTimeStep(Integer.parseInt(aMVCEvt.getInfo()));
                return true;
            }
        }
        return false;
    }

    private final void removeSpot(MVC_SpotEvent spotEvent) {
        for (Spot crtS : this.getSpots()) {
            if (crtS.refHashcode != spotEvent.hashCode) continue;
            this.getSpots().remove(crtS);
            break;
        }
        this.repaint();
    }

    private final void moveSpot(MVC_SpotEvent spotEvent) {
        for (Spot crtS : this.getSpots()) {
            if (crtS.refHashcode != spotEvent.hashCode) continue;
            crtS.position = spotEvent.position;
            break;
        }
        this.repaint();
    }

    private final void changeSpotSize(MVC_SpotEvent spotEvent) {
        for (Spot crtS : this.getSpots()) {
            if (crtS.refHashcode != spotEvent.hashCode) continue;
            crtS.size = spotEvent.size;
            break;
        }
        this.actualiseSize();
        this.repaint();
    }

    protected void paintCenterPointView(Graphics2D g2) {
        if (this.getCenterPointView() != null) {
            g2.setColor(Color.lightGray);
            int[] pos = this.getPixelCoordFromPosition(this.getCenterPointView());
            g2.drawArc(pos[0] - 3, pos[1] - 3, 6, 6, 0, 360);
            g2.drawLine(pos[0] - 6, pos[1], pos[0] - 3, pos[1]);
            g2.drawLine(pos[0] + 6, pos[1], pos[0] + 3, pos[1]);
            g2.drawLine(pos[0], pos[1] - 6, pos[0], pos[1] - 6);
            g2.drawLine(pos[0], pos[1] + 6, pos[0], pos[1] + 6);
        }
    }

    protected void paintSpots(Graphics2D g2) {
        for (Spot crtS : this.getSpots()) {
            g2.setColor(crtS.choosePaintColor(this.isTraceLegendFlag()));
            int[] pos = this.getPixelCoordFromPosition(crtS.position);
            switch (crtS.type) {
                case OBSERVATION: {
                    this.paintObservation(crtS, pos, g2);
                    break;
                }
                case TARGET: {
                    this.paintObservation(crtS, pos, g2);
                    break;
                }
                case SACCADE: {
                    this.paintSaccade(crtS, pos, g2);
                    break;
                }
                case MARK: {
                    this.paintMark(crtS, pos, g2);
                }
            }
        }
    }

    protected void paintObservation(Spot crtS, int[] pos, Graphics2D g2) {
        g2.drawArc(pos[0] - 3, pos[1] - 3, 6, 6, 0, 360);
        g2.drawLine(pos[0] - 6, pos[1], pos[0] + 6, pos[1]);
        g2.drawLine(pos[0], pos[1] - 6, pos[0], pos[1] + 6);
    }

    protected final void paintSaccade(Spot crtS, int[] pos, Graphics2D g2) {
        if (crtS.selected) {
            g2.drawString("" + crtS.time, pos[0], pos[1] + 15);
        }
        g2.drawLine(pos[0] - 3, pos[1] - 3, pos[0] + 3, pos[1] - 3);
        g2.drawLine(pos[0] - 3, pos[1] + 3, pos[0] + 3, pos[1] + 3);
        g2.drawLine(pos[0] - 3, pos[1] - 3, pos[0] - 3, pos[1] + 3);
        g2.drawLine(pos[0] + 3, pos[1] - 3, pos[0] + 3, pos[1] + 3);
        g2.drawLine(pos[0] - 6, pos[1], pos[0] + 6, pos[1]);
        g2.drawLine(pos[0], pos[1] - 6, pos[0], pos[1] + 6);
    }

    protected final void paintMark(Spot crtS, int[] pos, Graphics2D g2) {
        g2.drawLine(pos[0], pos[1], pos[0], pos[1]);
        if (crtS.selected) {
            g2.drawArc(pos[0] - 3, pos[1] - 3, 6, 6, 0, 360);
            g2.drawString(crtS.label, pos[0], pos[1] + 15);
        }
    }

    private final Spot selectSpot(int x, int y) {
        for (Spot crtS : this.getSpots()) {
            int[] spot_pos = this.getPixelCoordFromPosition(crtS.position);
            double r_squared = StrictMath.pow((double)spot_pos[0] - (double)x, 2.0) + StrictMath.pow((double)spot_pos[1] - (double)y, 2.0);
            if (!(r_squared < 16.0)) continue;
            return crtS;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Position t_pos;
        int posy;
        int posx;
        JMenuItem source = (JMenuItem)e.getSource();
        String[] infos = source.getActionCommand().split(",");
        System.out.println(String.valueOf(this.getClass().getName()) + "::actionPerformed -infos:" + source.getActionCommand() + " this:" + this + " source:" + source);
        if (infos[0].equals("addo")) {
            posx = Integer.parseInt(infos[1]);
            posy = Integer.parseInt(infos[2]);
            t_pos = this.getPositionFromPixelCoord(posx, posy);
            this.notifySpotChange(t_pos, MVC_Event_Type.OBSERVATION_ADD);
        }
        if (infos[0].equals("addt")) {
            posx = Integer.parseInt(infos[1]);
            posy = Integer.parseInt(infos[2]);
            t_pos = this.getPositionFromPixelCoord(posx, posy);
            this.notifySpotChange(t_pos, MVC_Event_Type.TARGET_ADD);
        }
        if (infos[0].equals("adds")) {
            posx = Integer.parseInt(infos[1]);
            posy = Integer.parseInt(infos[2]);
            Position s_pos = this.getPositionFromPixelCoord(posx, posy);
            this.notifySpotChange(s_pos, MVC_Event_Type.SACC_ADD);
        }
        if (infos[0].equals("apps")) {
            posx = Integer.parseInt(infos[1]);
            posy = Integer.parseInt(infos[2]);
            this.notifySpotChange(this.selectSpot(posx, posy), MVC_Event_Type.SACC_APP);
        }
        if (infos[0].equals("remo")) {
            posx = Integer.parseInt(infos[1]);
            posy = Integer.parseInt(infos[2]);
            this.notifySpotChange(this.selectSpot(posx, posy), MVC_Event_Type.OBSERVATION_REM);
        }
        if (infos[0].equals("remt")) {
            posx = Integer.parseInt(infos[1]);
            posy = Integer.parseInt(infos[2]);
            this.notifySpotChange(this.selectSpot(posx, posy), MVC_Event_Type.TARGET_REM);
        }
        if (infos[0].equals("rems")) {
            posx = Integer.parseInt(infos[1]);
            posy = Integer.parseInt(infos[2]);
            this.notifySpotChange(this.selectSpot(posx, posy), MVC_Event_Type.SACC_REM);
        }
        if (infos[0].equals("upda")) {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.UPDATE, this, null));
            }
        }
        if (infos[0].equals("infe")) {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.INFERE, this, null));
            }
        }
        if (infos[0].equals("flsh")) {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.FLASH_TARGETS, this, null));
            }
        }
        if (infos[0].equals("dupp")) {
            this.duplicateMarks();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
        if (e.getButton() == 2) {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.CENTER_RESET, this, null));
            }
        } else {
            Spot selectSpot = this.selectSpot(e.getX(), e.getY());
            if (!e.isMetaDown()) {
                if (selectSpot != null) {
                    this.notifySpotChange(selectSpot, MVC_Event_Type.SPOT_SEL);
                } else {
                    Object[][] data = new Object[][]{{this.getPositionFromPixelCoord(e.getX(), e.getY())}};
                    for (Model crtMd : this.getAssociatedModels()) {
                        crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.CENTER_SEL, this, data));
                    }
                }
            } else if (selectSpot == null) {
                JMenuItem menuItem = null;
                JPopupMenu popup = new JPopupMenu();
                menuItem = new JMenuItem("Add new observation");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("addo," + e.getX() + "," + e.getY());
                popup.add(menuItem);
                menuItem = new JMenuItem("Add new target");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("addt," + e.getX() + "," + e.getY());
                popup.add(menuItem);
                menuItem = new JMenuItem("Add new saccade");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("adds," + e.getX() + "," + e.getY());
                popup.add(menuItem);
                menuItem = new JMenuItem("Dupplicate Marks");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("dupp,,");
                popup.add(menuItem);
                menuItem = new JMenuItem("Update");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("upda,");
                popup.add(menuItem);
                menuItem = new JMenuItem("Infere");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("infe,");
                popup.add(menuItem);
                menuItem = new JMenuItem("Flash target(s)");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("flsh,");
                popup.add(menuItem);
                menuItem = new JMenuItem("Cancel");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("cancel,");
                popup.add(menuItem);
                popup.show(this, e.getX(), e.getY());
            } else {
                JMenuItem menuItem = null;
                JPopupMenu popup = new JPopupMenu();
                switch (selectSpot.type) {
                    case OBSERVATION: {
                        menuItem = new JMenuItem("Remove the observation");
                        menuItem.setActionCommand("remo," + e.getX() + "," + e.getY());
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        break;
                    }
                    case TARGET: {
                        menuItem = new JMenuItem("Remove the target");
                        menuItem.setActionCommand("remt," + e.getX() + "," + e.getY());
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        break;
                    }
                    case SACCADE: {
                        menuItem = new JMenuItem("Apply the saccade");
                        menuItem.setActionCommand("apps," + e.getX() + "," + e.getY());
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        menuItem = new JMenuItem("Remove the saccade");
                        menuItem.setActionCommand("rems," + e.getX() + "," + e.getY());
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                    }
                }
                menuItem = new JMenuItem("Cancel");
                menuItem.addActionListener(this);
                menuItem.setActionCommand("cancel,");
                popup.add(menuItem);
                popup.show(this, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Spot crtS = null;
        crtS = !e.isMetaDown() ? this.selectSpot(e.getX(), e.getY()) : this.getCurrentSelectedSpot();
        if (crtS != null) {
            Position pos = this.getPositionFromPixelCoord(e.getX(), e.getY());
            switch (crtS.type) {
                case OBSERVATION: {
                    this.notifySpotChange(pos, crtS.refHashcode, MVC_Event_Type.OBSERVATION_MOV);
                    break;
                }
                case TARGET: {
                    this.notifySpotChange(pos, crtS.refHashcode, MVC_Event_Type.TARGET_MOV);
                    break;
                }
                case SACCADE: {
                    this.notifySpotChange(pos, crtS.refHashcode, MVC_Event_Type.SACC_MOV);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.actualiseSize();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 73: {
                for (Model crtMd : this.getAssociatedModels()) {
                    crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.INFERE, this, null));
                }
                break;
            }
            case 85: {
                for (Model crtMd : this.getAssociatedModels()) {
                    crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.UPDATE, this, null));
                }
                break;
            }
            case 80: {
                Spot crtS = this.getCurrentSelectedSpot();
                MVC_Event_Type etype = MVC_Event_Type.OBSERVATION_SIZE_INC;
                switch (crtS.type) {
                    case OBSERVATION: {
                        etype = MVC_Event_Type.OBSERVATION_SIZE_INC;
                        break;
                    }
                    case TARGET: {
                        etype = MVC_Event_Type.TARGET_SIZE_INC;
                    }
                }
                this.notifySpotChange(crtS, etype);
                break;
            }
            case 77: {
                Spot crtS = this.getCurrentSelectedSpot();
                MVC_Event_Type etype = MVC_Event_Type.OBSERVATION_SIZE_DEC;
                switch (crtS.type) {
                    case OBSERVATION: {
                        etype = MVC_Event_Type.OBSERVATION_SIZE_DEC;
                        break;
                    }
                    case TARGET: {
                        etype = MVC_Event_Type.TARGET_SIZE_DEC;
                    }
                }
                this.notifySpotChange(crtS, etype);
                break;
            }
            case 10: {
                System.out.println("Current spot list:");
                for (Spot crtS : this.getSpots()) {
                    System.out.println("" + crtS);
                }
                System.out.println("Current selected spot:");
                System.out.println("" + this.getCurrentSelectedSpot());
                break;
            }
            case 32: {
                for (Model crtMd : this.getAssociatedModels()) {
                    crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.STOP, this, null));
                }
                break;
            }
            case 48: 
            case 96: {
                System.out.println("Adding reference mark.");
                for (Model crtMd : this.getAssociatedModels()) {
                    crtMd.performedVC_M_Event(new MVC_SpotEvent(MVC_Event_Type.MARK_ADD, this, new Position(0.0, 0.0, false), 0.0, 0, "Absolute reference frame"));
                }
                break;
            }
            case 46: 
            case 110: {
                System.out.println("Recovering reference mark:");
                for (Spot crtS : this.getSpots()) {
                    if (crtS.label != "Absolute reference frame") continue;
                    System.out.println("" + crtS);
                }
                break;
            }
            default: {
                System.out.println("Unknown keyCode: " + e.getKeyCode());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected final Stroke getDashedStroked(float interval) {
        float[] dash1 = new float[]{interval};
        return new BasicStroke(1.0f, 0, 0, 5.0f, dash1, 0.0f);
    }

    private final void duplicateMarks() {
        Vector<Spot> spots_clone = new Vector<Spot>();
        int i = 0;
        while (i < this.getSpots().size()) {
            spots_clone.add(this.getSpots().get(i));
            ++i;
        }
        for (Spot crtS : spots_clone) {
            if (crtS.type != SpotType.MARK) continue;
            this.notifySpotChange(crtS, MVC_Event_Type.MARK_REM);
            this.notifySpotChange(crtS, MVC_Event_Type.MARK_ADD);
        }
    }

    private final void notifySpotChange(Spot crtS, MVC_Event_Type eType) {
        if (crtS != null) {
            MVC_SpotEvent sEvt = new MVC_SpotEvent(eType, this, crtS.position, crtS.size, crtS.refHashcode, crtS.label);
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(sEvt);
            }
        } else {
            System.out.println("notifySpotChange -warning: crtS is null");
        }
    }

    private final void notifySpotChange(Position pos, MVC_Event_Type eType) {
        MVC_SpotEvent sEvt = new MVC_SpotEvent(eType, this, pos, 0.0, 0, null);
        for (Model crtMd : this.getAssociatedModels()) {
            crtMd.performedVC_M_Event(sEvt);
        }
    }

    private final void notifySpotChange(Position pos, int hashcode, MVC_Event_Type eType) {
        MVC_SpotEvent sEvt = new MVC_SpotEvent(eType, this, pos, 0.0, hashcode, null);
        for (Model crtMd : this.getAssociatedModels()) {
            crtMd.performedVC_M_Event(sEvt);
        }
    }

    protected abstract Position getPositionFromPixelCoord(int var1, int var2);

    protected abstract int[] getPixelCoordFromPosition(Position var1);
}

