/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.MapView;
import gui.Model;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseWheelEvent;
import utils.AnalyticFunction2D;
import utils.ClassicReferenceConverter;
import utils.Position;

public class ColliculusMapView
extends MapView {
    private double[] myXRange;
    private double[] myYRange;
    private boolean isRightPart;
    private static final long serialVersionUID = -5922800706681777313L;
    private Color curvesColor;
    private AnalyticFunction2D collicularMappingEquiT;
    private AnalyticFunction2D collicularMappingEquiR;

    private final double[] getXRange() {
        return this.myXRange;
    }

    private final void setXRange(double[] xRange) {
        this.myXRange = xRange;
    }

    private final double[] getYRange() {
        return this.myYRange;
    }

    private final void setYRange(double[] yRange) {
        this.myYRange = yRange;
    }

    protected final boolean isRightPart() {
        return this.isRightPart;
    }

    private final void setRightPart(boolean isRightPart) {
        this.isRightPart = isRightPart;
    }

    protected Color getCurvesColor() {
        return this.curvesColor;
    }

    protected void setCurvesColor(Color curvesColor) {
        this.curvesColor = curvesColor;
    }

    private AnalyticFunction2D getCollicularMappingEquiR() {
        return this.collicularMappingEquiR;
    }

    private void setCollicularMappingEquiR(AnalyticFunction2D equiRFct) {
        this.collicularMappingEquiR = equiRFct;
    }

    private AnalyticFunction2D getCollicularMappingEquiT() {
        return this.collicularMappingEquiT;
    }

    private void setCollicularMappingEquiT(AnalyticFunction2D equiTFct) {
        this.collicularMappingEquiT = equiTFct;
    }

    public ColliculusMapView(boolean isRightPart) {
        double[] xrange;
        this.setRightPart(isRightPart);
        this.setCurvesColor(new Color(0, 0, 180));
        this.setRefConverter(new ClassicReferenceConverter());
        this.setMinimumSize(new Dimension(0, 0));
        this.setCollicularMappingEquiT(AnalyticFunction2D.createFunction("CollicularLogFunction2D", "1.4,1.8,0.05235987755982988"));
        this.setCollicularMappingEquiR(AnalyticFunction2D.createFunction("CollicularEquiRFunction2D", "1.4,1.8,0.05235987755982988,1.45"));
        if (this.isRightPart()) {
            xrange = new double[]{0.0, 5.0, 1.0};
            this.setXRange(xrange);
        } else {
            xrange = new double[]{-5.0, 0.0, 1.0};
            this.setXRange(xrange);
        }
        double[] yrange = new double[]{-4.0, 4.0, 1.0};
        this.setYRange(yrange);
    }

    protected final void subActualiseSize() {
        double[] l_xrang = new double[]{-5.5, 0.0};
        double[] r_xrang = new double[]{0.0, 5.5};
        double[] yrang = new double[]{-4.5, 4.5};
        if (this.getCenterPointView() == null) {
            if (this.isRightPart()) {
                this.setZoom(1.0);
                this.setCenterPointView(new Position(2.75, 0.0, false));
            } else {
                this.setZoom(1.0);
                this.setCenterPointView(new Position(-2.75, 0.0, false));
            }
        }
        double l_sizeX = l_xrang[1] - l_xrang[0];
        double r_sizeX = r_xrang[1] - r_xrang[0];
        double sizeY = yrang[1] - yrang[0];
        double bLWinX = 0.0;
        double tRWinX = 0.0;
        double cWinX = this.getCenterPointView().getX2();
        double cWinY = this.getCenterPointView().getY2();
        double bLWinY = cWinY - 0.5 * sizeY / this.getZoom();
        double tRWinY = cWinY + 0.5 * sizeY / this.getZoom();
        if (this.isRightPart()) {
            bLWinX = cWinX - 0.5 * r_sizeX / this.getZoom();
            tRWinX = cWinX + 0.5 * r_sizeX / this.getZoom();
        } else {
            bLWinX = cWinX - 0.5 * l_sizeX / this.getZoom();
            tRWinX = cWinX + 0.5 * l_sizeX / this.getZoom();
        }
        this.getRefConverter().init(bLWinX, bLWinY, tRWinX, tRWinY, this.getWidth(), this.getHeight());
    }

    public void paint(Graphics g) {
        double[] xrange = this.getXRange();
        double[] yrange = this.getYRange();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setPaint(Color.black);
        Font font = g2.getFont();
        g2.setFont(font.deriveFont(this.getFontSize()));
        int bot_left_x = this.getRefConverter().xPixel(xrange[0]);
        int bot_left_y = this.getRefConverter().yPixel(yrange[0]);
        int top_right_x = this.getRefConverter().xPixel(xrange[1]);
        int top_right_y = this.getRefConverter().yPixel(yrange[1]);
        g2.drawLine(bot_left_x, bot_left_y, top_right_x, bot_left_y);
        g2.drawLine(bot_left_x, bot_left_y, bot_left_x, top_right_y);
        g2.drawLine(bot_left_x, top_right_y, top_right_x, top_right_y);
        g2.drawLine(top_right_x, bot_left_y, top_right_x, top_right_y);
        if (this.isTraceLegendFlag()) {
            double x = xrange[0];
            while (x <= xrange[1]) {
                int posx = this.getRefConverter().xPixel(x);
                if (x != xrange[0] && x != xrange[1]) {
                    g2.drawLine(posx, bot_left_y - 5, posx, bot_left_y);
                    g2.drawLine(posx, top_right_y + 5, posx, top_right_y);
                }
                g2.drawString("" + x, posx - 10, bot_left_y + 15);
                x += xrange[2];
            }
            double y = yrange[0];
            while (y <= yrange[1]) {
                int posy = this.getRefConverter().yPixel(y);
                if (y != yrange[0] && y != yrange[1]) {
                    g2.drawLine(bot_left_x, posy, bot_left_x + 5, posy);
                    g2.drawLine(top_right_x, posy, top_right_x - 5, posy);
                }
                g2.drawString("" + y, bot_left_x - 30, posy + 5);
                y += yrange[2];
            }
        }
        this.traceLogCurves(g2);
        this.paintSpots(g2);
        this.paintCenterPointView(g2);
    }

    protected final void traceLogCurves(Graphics2D g2) {
        g2.setColor(this.getCurvesColor());
        Stroke basicSt = g2.getStroke();
        this.traceCurve(g2, 0.037, true, "2", false);
        this.traceCurve(g2, 0.09, true, "5", false);
        this.traceCurve(g2, 0.17, true, "10", false);
        this.traceCurve(g2, 0.35, true, "20", false);
        this.traceCurve(g2, 0.7, true, "40", false);
        this.traceCurve(g2, 1.4, true, "80", false);
        g2.setStroke(this.getDashedStroked(5.0f));
        this.traceCurve(g2, 1.5707963267948966, false, "90", true);
        this.traceCurve(g2, -1.5707963267948966, false, "-90", true);
        this.traceCurve(g2, 0.7853981633974483, false, "45", true);
        this.traceCurve(g2, -0.7853981633974483, false, "-45", true);
        this.traceCurve(g2, 0.0, false, "0", true);
        g2.setStroke(basicSt);
    }

    private final void traceCurve(Graphics2D g2, double cte, boolean isRCte, String legend, boolean legendAtEnd) {
        int cpt = 0;
        double[] crt_pos = new double[2];
        double[] entries = new double[2];
        double[] trange = new double[]{0.0, 1.45, 0.01};
        int nb_points = (int)StrictMath.rint((trange[1] - trange[0]) / trange[2]);
        int[] x_points = new int[nb_points];
        int[] y_points = new int[nb_points];
        double t = trange[0];
        while (t <= trange[1]) {
            if (isRCte) {
                entries[0] = cte;
                entries[1] = t;
                crt_pos = this.getCollicularMappingEquiR().computeValueFor(entries);
            } else {
                entries[0] = t / StrictMath.sqrt(1.0 + StrictMath.tan(cte) * StrictMath.tan(cte));
                entries[1] = entries[0] * StrictMath.tan(cte);
                entries[0] = entries[0] * 57.29577951308232;
                entries[1] = entries[1] * 57.29577951308232;
                crt_pos = this.getCollicularMappingEquiT().computeValueFor(entries);
            }
            x_points[cpt] = this.isRightPart() ? this.getRefConverter().xPixel(crt_pos[0]) : this.getRefConverter().xPixel(-crt_pos[0]);
            y_points[cpt] = this.getRefConverter().yPixel(crt_pos[1]);
            ++cpt;
            t += trange[2];
        }
        g2.drawPolyline(x_points, y_points, nb_points);
        if (this.isTraceLegendFlag() && legend != null) {
            if (this.isRightPart()) {
                if (legendAtEnd) {
                    g2.drawString(legend, x_points[nb_points - 1] + 5, y_points[nb_points - 1] + 5);
                } else {
                    g2.drawString(legend, x_points[0] - 10, y_points[0] + 10);
                }
            } else if (legendAtEnd) {
                g2.drawString(legend, x_points[nb_points - 1] - 10, y_points[nb_points - 1] + 5);
            } else {
                g2.drawString(legend, x_points[0] + 10, y_points[0] + 10);
            }
        }
    }

    public boolean performedM_VC_Event(MVC_Event aMVCEvt) {
        if (super.performedM_VC_Event(aMVCEvt)) {
            return true;
        }
        switch (aMVCEvt.getIdentity()) {
            case CENTER_SEL: {
                Position centerPos = (Position)aMVCEvt.getData()[0][0];
                if (this.isRightPart() && centerPos.getX1() >= 0.0) {
                    this.setCenterPointView(centerPos);
                }
                if (!this.isRightPart() && centerPos.getX1() < 0.0) {
                    this.setCenterPointView(centerPos);
                }
                this.repaint();
                return true;
            }
            case ZOOM_PLUS: {
                double zoom = (Double)aMVCEvt.getData()[0][0];
                int hash = (Integer)aMVCEvt.getData()[1][0];
                if (hash == this.hashCode()) {
                    this.setZoom(StrictMath.min(this.getZoom() * (1.0 + 0.05 * zoom), 20.0));
                    this.actualiseSize();
                    this.repaint();
                }
                return true;
            }
            case ZOOM_MOINS: {
                double zoom = (Double)aMVCEvt.getData()[0][0];
                int hash = (Integer)aMVCEvt.getData()[1][0];
                if (hash == this.hashCode()) {
                    this.setZoom(StrictMath.max(this.getZoom() * (1.0 - 0.05 * zoom), 0.05));
                    this.actualiseSize();
                    this.repaint();
                }
                return true;
            }
        }
        return false;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        Object[][] data = new Object[][]{{(double)e.getClickCount()}, {this.hashCode()}};
        if (e.getWheelRotation() > 0) {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.ZOOM_PLUS, this, data));
            }
        } else {
            for (Model crtMd : this.getAssociatedModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.ZOOM_MOINS, this, data));
            }
        }
    }

    protected final Position getPositionFromPixelCoord(int posx, int posy) {
        double x = this.getRefConverter().xBasic(posx);
        double y = this.getRefConverter().yBasic(posy);
        return new Position(x, y, false);
    }

    protected final int[] getPixelCoordFromPosition(Position pos) {
        int posx = this.getRefConverter().xPixel(pos.getX2());
        int posy = this.getRefConverter().yPixel(pos.getY2());
        int[] retour = new int[]{posx, posy};
        return retour;
    }

    public final String toString() {
        return "ColliculusMapView isRight?" + this.isRightPart() + " hash:" + this.hashCode();
    }
}

