/*
 * Decompiled with CFR 0.152.
 */
package gui;

import engine.BossEngine;
import engine.LeftRight_GridProbabilisticDistribution;
import engine.LeftRight_Variable;
import engine.V251_BossEngine;
import gui.BossGUIModel;
import gui.BossToolBar;
import gui.ColliculusMapView;
import gui.Controller;
import gui.EngineInfosView;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.MapView;
import gui.Model;
import gui.ProbabilityGridColliculusView;
import gui.VariableGridColliculusView;
import gui.View;
import gui.VisualFieldMapView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import utils.ExampleFileFilter;
import utils.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BossApplication
implements ActionListener,
View {
    public static BossEngine bossEngine;
    private static final String APPLI_NAME = "BOSS";
    private static final String APPLI_PRES = "System for Bayesian Occular Saccades Selections";
    private static final String APPLI_ADRESS = "LPPA\n11 place M. Berthelot\n75231 Paris Cedex 05, France";
    private float myFontSize = 10.0f;
    private static JTabbedPane myProbasTabbedPane;
    private static JTabbedPane myVarsTabbedPane;
    protected JFrame myMainFrame;
    protected Vector<Controller> myControllers = new Vector();
    protected Vector<Model> myModels = new Vector();
    protected Vector<View> myViews = new Vector();

    private final float getFontSize() {
        return this.myFontSize;
    }

    private final void setFontSize(float fontSize) {
        this.myFontSize = fontSize;
    }

    private static final void setProbasTabbedPane(JTabbedPane myT) {
        myProbasTabbedPane = myT;
    }

    private static final void setVarsTabbedPane(JTabbedPane myT) {
        myVarsTabbedPane = myT;
    }

    public static final JTabbedPane getProbasTabbedPane() {
        return myProbasTabbedPane;
    }

    public static final JTabbedPane getVarsTabbedPane() {
        return myVarsTabbedPane;
    }

    private final void setMainFrame(JFrame myMF) {
        this.myMainFrame = myMF;
    }

    public final JFrame getMainFrame() {
        return this.myMainFrame;
    }

    public final Vector<Controller> getControllers() {
        return this.myControllers;
    }

    public final Controller getController(int rank) {
        return this.myControllers.get(rank);
    }

    public final Vector<Model> getModels() {
        return this.myModels;
    }

    public final Model getModel(int rank) {
        return this.myModels.get(rank);
    }

    public final Vector<View> getViews() {
        return this.myViews;
    }

    public final View getView(int rank) {
        return this.myViews.get(rank);
    }

    public BossApplication(boolean toBack) {
        String[] fctNames = new String[]{"CollicularLogFunction2D", "CollicularReverseLogFunction2D"};
        String[] fctParams = new String[]{"1.4,1.8,0.05235987755982988", "1.4,1.8,0.05235987755982988"};
        Position.init(fctNames, fctParams);
        this.setMainFrame(new JFrame(){
            private static final long serialVersionUID = -5986107804731660587L;

            protected void processWindowEvent(WindowEvent e) {
                BossApplication.this.closeMainFrame(e);
            }
        });
        if (toBack) {
            this.getMainFrame().toBack();
        }
        this.getMainFrame().setSize(new Dimension(1, 1));
        this.addMVCComponents();
        this.linksMVCComponents();
        this.initMainFrame();
        this.getMainFrame().setVisible(true);
    }

    protected void addMVCComponents() {
        VisualFieldMapView mv0 = new VisualFieldMapView();
        ColliculusMapView mv1 = new ColliculusMapView(false);
        ColliculusMapView mv2 = new ColliculusMapView(true);
        EngineInfosView eiv = new EngineInfosView();
        BossEngine be = V251_BossEngine.getInstance();
        BossGUIModel bgm = new BossGUIModel();
        BossToolBar btb = new BossToolBar();
        this.getViews().add(mv0);
        this.getViews().add(mv1);
        this.getViews().add(mv2);
        this.getViews().add(eiv);
        this.getViews().add(btb);
        this.getViews().add(this);
        this.getControllers().add(mv0);
        this.getControllers().add(mv1);
        this.getControllers().add(mv2);
        this.getControllers().add(btb);
        this.getModels().add(be);
        this.getModels().add(bgm);
        bossEngine = be;
    }

    protected void linksMVCComponents() {
        this.getController(0).getAssociatedModels().add(this.getModel(0));
        this.getController(1).getAssociatedModels().add(this.getModel(0));
        this.getController(2).getAssociatedModels().add(this.getModel(0));
        this.getController(3).getAssociatedModels().add(this.getModel(0));
        this.getController(0).getAssociatedModels().add(this.getModel(1));
        this.getController(1).getAssociatedModels().add(this.getModel(1));
        this.getController(2).getAssociatedModels().add(this.getModel(1));
        this.getController(3).getAssociatedModels().add(this.getModel(1));
        this.getModel(0).getAssociatedViews().add(this.getView(0));
        this.getModel(0).getAssociatedViews().add(this.getView(1));
        this.getModel(0).getAssociatedViews().add(this.getView(2));
        this.getModel(0).getAssociatedViews().add(this.getView(3));
        this.getModel(0).getAssociatedViews().add(this.getView(4));
        this.getModel(0).getAssociatedViews().add(this.getView(5));
        this.getModel(1).getAssociatedViews().add(this.getView(0));
        this.getModel(1).getAssociatedViews().add(this.getView(1));
        this.getModel(1).getAssociatedViews().add(this.getView(2));
        this.getModel(1).getAssociatedViews().add(this.getView(3));
        this.getModel(1).getAssociatedViews().add(this.getView(4));
    }

    protected void initMainFrame() {
        this.initMainFrameMenuBar();
        JSplitPane jSPane_TopBottom = null;
        JSplitPane jSPane_TP_LeftRight_CO = null;
        JTabbedPane jTPane_Vars = new JTabbedPane();
        JTabbedPane jTPane_Probs = new JTabbedPane();
        JTabbedPane jTPane_Fields = new JTabbedPane();
        JTabbedPane jTPane_Global = new JTabbedPane();
        JTabbedPane jTPane_ProbsVars = new JTabbedPane();
        this.getMainFrame().getContentPane().setLayout(new BorderLayout());
        this.getMainFrame().getContentPane().add((Component)jTPane_Global, "Center");
        this.getMainFrame().getContentPane().add((Component)((Object)this.getController(3)), "North");
        Font font = jTPane_Fields.getFont();
        jTPane_Vars.setFont(font.deriveFont(this.getFontSize()));
        jTPane_Probs.setFont(font.deriveFont(this.getFontSize()));
        jTPane_Fields.setFont(font.deriveFont(this.getFontSize()));
        jTPane_Global.setFont(font.deriveFont(this.getFontSize()));
        jTPane_ProbsVars.setFont(font.deriveFont(this.getFontSize()));
        jSPane_TP_LeftRight_CO = new JSplitPane(1, (Component)((Object)this.getView(1)), (Component)((Object)this.getView(2)));
        jSPane_TP_LeftRight_CO.setDividerLocation(0.5);
        jSPane_TP_LeftRight_CO.setResizeWeight(0.5);
        jTPane_Probs.add((Component)jSPane_TP_LeftRight_CO, "Colliculus");
        jTPane_ProbsVars.add((Component)jTPane_Probs, "Grid Probas");
        jTPane_ProbsVars.add((Component)jTPane_Vars, "Variables");
        JScrollPane JSPane = new JScrollPane((Component)((Object)this.getView(3)));
        jTPane_ProbsVars.add((Component)JSPane, "Probas Desc");
        jSPane_TopBottom = new JSplitPane(0, jTPane_ProbsVars, (Component)((Object)this.getView(0)));
        jSPane_TopBottom.setDividerLocation(0.5);
        jSPane_TopBottom.setResizeWeight(0.5);
        jTPane_Global.add((Component)jSPane_TopBottom, "Global");
        BossApplication.setVarsTabbedPane(jTPane_Vars);
        BossApplication.setProbasTabbedPane(jTPane_Probs);
    }

    public static void refresh(int num) {
    }

    private static Dimension evalDim() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension retour = new Dimension(screenSize.height - 210, screenSize.height - 50);
        return retour;
    }

    private void closeMainFrame(WindowEvent e) {
        if (e.getID() == 201) {
            int val = 1;
            switch (val) {
                case 0: {
                    int i = 0;
                    while (i < this.getModels().size()) {
                        this.getModel(i).performedVC_M_Event(new MVC_Event(MVC_Event_Type.SAVE, this, "", null));
                        ++i;
                    }
                    System.exit(0);
                    break;
                }
                case 1: {
                    System.exit(0);
                }
            }
        }
    }

    public static void main(String[] args) {
        Vector<String> pos_args = new Vector<String>();
        String parameterFile = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-p") || "--parameterFile".startsWith(args[i])) {
                if (++i >= args.length) {
                    System.out.println("Error: \"" + args[i - 1] + "\" flag requires argument.");
                    System.exit(-1);
                }
                parameterFile = args[i];
            } else {
                pos_args.add(args[i]);
            }
            ++i;
        }
        Object[][] data = new Object[][]{{0.2, 0.2, pos_args.size() > 0, parameterFile}};
        BossApplication appli = new BossApplication(true);
        appli.getModel(0).performedVC_M_Event(new MVC_Event(MVC_Event_Type.INIT_APPLI, appli, null, data));
        appli.getMainFrame().setTitle("BOSS v" + BossEngine.appliVersion);
        appli.getMainFrame().setSize(BossApplication.evalDim());
        switch (pos_args.size()) {
            case 2: {
                String trj_file = (String)pos_args.get(0);
                String etrj_file = (String)pos_args.get(1);
                appli.getModel(0).performedVC_M_Event(new MVC_Event(MVC_Event_Type.LOAD, appli, null, new Object[][]{{trj_file}}));
                appli.getModel(0).performedVC_M_Event(new MVC_Event(MVC_Event_Type.LOAD_EM, appli, null, new Object[][]{{etrj_file}}));
                appli.getModel(0).performedVC_M_Event(new MVC_Event(MVC_Event_Type.FREE_EYES, appli, null, null));
                appli.getModel(0).performedVC_M_Event(new MVC_Event(MVC_Event_Type.DATA_EM, appli, null, null));
                appli.getView(4).performedM_VC_Event(new MVC_Event(MVC_Event_Type.START, appli, null, null));
                break;
            }
            case 1: {
                String trj_file = (String)pos_args.get(0);
                appli.getModel(0).performedVC_M_Event(new MVC_Event(MVC_Event_Type.LOAD, appli, null, new Object[][]{{trj_file}}));
                appli.getModel(0).performedVC_M_Event(new MVC_Event(MVC_Event_Type.FREE_EYES, appli, null, null));
                appli.getModel(0).performedVC_M_Event(new MVC_Event(MVC_Event_Type.MODEL_EM, appli, null, null));
                appli.getView(4).performedM_VC_Event(new MVC_Event(MVC_Event_Type.START, appli, null, null));
                break;
            }
            case 0: {
                break;
            }
            default: {
                System.out.println("Error: couldn't parse command line.");
                System.exit(-1);
            }
        }
    }

    protected void initMainFrameMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.getMainFrame().setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Load", 76);
        menuItem.getAccessibleContext().setAccessibleDescription("Load an observation trajectories file");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("file#load");
        menu.add(menuItem);
        menuItem = new JMenuItem("Load Eye Movements", 69);
        menuItem.getAccessibleContext().setAccessibleDescription("Load an eye movement trajectory file");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("file#loadEM");
        menu.add(menuItem);
        menu = new JMenu("Model");
        menu.setMnemonic(77);
        menuBar.add(menu);
        menuItem = new JMenuItem("Reset", 82);
        menuItem.getAccessibleContext().setAccessibleDescription("Reset to an empty visual field");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("model#reset");
        menu.add(menuItem);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        menuItem = new JMenuItem("About", 65);
        menuItem.getAccessibleContext().setAccessibleDescription("Short description of the software and how to contact the author");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("help#about");
        menu.add(menuItem);
    }

    private final String chooseAFile(String path, String type, String ext, String fileDesc) {
        URL url = this.getClass().getResource(path);
        JFileChooser chooser = null;
        if (url == null) {
            chooser = new JFileChooser();
        } else {
            String[] urls = url.toString().split(":");
            chooser = new JFileChooser(urls[1]);
        }
        chooser.setDialogTitle("Load " + type);
        chooser.setApproveButtonText("Load");
        chooser.setApproveButtonToolTipText("Click to load the file");
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension(ext);
        filter.setDescription(fileDesc);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 1) {
            return null;
        }
        if (returnVal == 0) {
            String file_path = chooser.getSelectedFile().getPath();
            return file_path;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String file_path;
        StringTokenizer st = new StringTokenizer(e.getActionCommand(), "#");
        String type_menu = st.nextToken();
        String title_menu = st.nextToken();
        if (title_menu.equals("about")) {
            String msg = "";
            msg = String.valueOf(msg) + "BOSS Application\n";
            msg = String.valueOf(msg) + "(System for Bayesian Occular Saccades Selections)\n\n";
            msg = String.valueOf(msg) + "Version " + BossEngine.appliVersion + "\n\n";
            msg = String.valueOf(msg) + "Copyright (c) " + BossEngine.appliDate;
            msg = String.valueOf(msg) + " (CNRS, authors " + BossEngine.appliAuthors + ") \n\n";
            msg = String.valueOf(msg) + "This software has been developped at the LPPA\n11 place M. Berthelot\n75231 Paris Cedex 05, France";
            msg = String.valueOf(msg) + "\n\nFor congratulations or unprobable bugs reports,";
            msg = String.valueOf(msg) + "\nplease contact : " + BossEngine.appliEmails + "\n";
            JOptionPane.showMessageDialog(null, msg);
        }
        if (title_menu.equals("load") && (file_path = this.chooseAFile("/trajectories", "observation trajectories file", "trj", "Observation trajectories files")) != null) {
            for (Model crtMd : this.getModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.LOAD, this, new Object[][]{{file_path}}));
            }
        }
        if (title_menu.equals("loadEM") && (file_path = this.chooseAFile("/trajectories", "eye movement trajectory file", "etrj", "Eye Movements trajectory files")) != null) {
            for (Model crtMd : this.getModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.LOAD_EM, this, new Object[][]{{file_path}}));
            }
        }
        if (title_menu.equals("reset")) {
            for (Model crtMd : this.getModels()) {
                crtMd.performedVC_M_Event(new MVC_Event(MVC_Event_Type.RESET, this, null));
            }
        }
    }

    @Override
    public boolean performedM_VC_Event(MVC_Event aMVCEvt) {
        aMVCEvt.traceDebug(String.valueOf(this.getClass().getName()) + "::performedM_VC_Event");
        switch (aMVCEvt.getIdentity()) {
            case INIT_APPLI: {
                Object[][] data = aMVCEvt.getData();
                Vector gpd_list = (Vector)data[0][0];
                for (LeftRight_GridProbabilisticDistribution gpd : gpd_list) {
                    ProbabilityGridColliculusView mvg = new ProbabilityGridColliculusView(gpd.getLeftPart().getName(), false);
                    ProbabilityGridColliculusView mvd = new ProbabilityGridColliculusView(gpd.getRightPart().getName(), true);
                    this.linksNewMapView(mvg);
                    this.linksNewMapView(mvd);
                    JSplitPane jSPane = new JSplitPane(1, mvg, mvd);
                    jSPane.setDividerLocation(0.5);
                    jSPane.setResizeWeight(0.5);
                    BossApplication.getProbasTabbedPane().add((Component)jSPane, gpd.getName());
                }
                Hashtable vars = (Hashtable)data[1][0];
                TreeMap<String, LeftRight_Variable> s_vars = new TreeMap<String, LeftRight_Variable>();
                Enumeration e = vars.keys();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    s_vars.put(name, (LeftRight_Variable)vars.get(name));
                }
                Vector<String> names1 = new Vector<String>();
                Vector<String> names2 = new Vector<String>();
                Iterator it = s_vars.keySet().iterator();
                while (it.hasNext()) {
                    names1.add((String)it.next());
                }
                int i = names1.size() - 1;
                while (i >= 0) {
                    names2.add((String)names1.get(i));
                    --i;
                }
                i = 0;
                while (i < names2.size()) {
                    String name = (String)names2.get(i);
                    LeftRight_Variable var = (LeftRight_Variable)vars.get(name);
                    VariableGridColliculusView mvg = new VariableGridColliculusView(var.getLeftPart().getName(), false);
                    VariableGridColliculusView mvd = new VariableGridColliculusView(var.getRightPart().getName(), true);
                    this.linksNewMapView(mvg);
                    this.linksNewMapView(mvd);
                    JSplitPane jSPane = new JSplitPane(1, mvg, mvd);
                    jSPane.setDividerLocation(0.5);
                    jSPane.setResizeWeight(0.5);
                    BossApplication.getVarsTabbedPane().insertTab(name, null, jSPane, null, i);
                    ++i;
                }
                return true;
            }
            case MSG_ERR: {
                String[] msg = aMVCEvt.getInfo().split("\\$");
                System.out.println("msg:" + msg[0] + "," + msg[1]);
                JOptionPane.showMessageDialog(null, msg[1], msg[0], 0);
                return true;
            }
            case MSG_INFOS: {
                String[] msg = aMVCEvt.getInfo().split("#");
                JOptionPane.showMessageDialog(null, msg[1], msg[0], 1);
                return true;
            }
        }
        return false;
    }

    private final void linksNewMapView(MapView mv) {
        this.getViews().add(mv);
        this.getControllers().add(mv);
        mv.getAssociatedModels().add(this.getModel(0));
        mv.getAssociatedModels().add(this.getModel(1));
        this.getModel(0).getAssociatedViews().add(mv);
        this.getModel(1).getAssociatedViews().add(mv);
    }
}

