/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Antecedent;
import engine.BossEngine;
import engine.Cell;
import engine.FunctionProbabilisticDistribution;
import engine.GridPosDebugPolicy;
import engine.GridProbabilisticDistribution;
import engine.LeftRight_GridProbabilisticDistribution;
import engine.LeftRight_Variable;
import engine.Observation;
import engine.ProbabilisticDistribution;
import engine.RandomVariable;
import engine.ShowableException;
import engine.Target;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.View;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Hashtable;
import utils.GridReferenceConverter;
import utils.Position;
import utils.Utilities;

public class V25_BossEngine
extends BossEngine {
    private static BossEngine uniqInstance = null;
    private Cell lastSaccadeCell;

    private V25_BossEngine() {
    }

    public static BossEngine getInstance() {
        if (uniqInstance == null) {
            uniqInstance = new V25_BossEngine();
            BossEngine.appliVersion = "2.5";
            uniqInstance.setDebugPolicy(new GridPosDebugPolicy());
        }
        return uniqInstance;
    }

    protected void getCellInfos(Position requestPos, String elementName) {
        Cell r_c = Cell.getCell(requestPos);
        String msg = "";
        if (r_c == null) {
            msg = "No cell !";
        } else {
            msg = "Cell (" + r_c.x + "," + r_c.y + ":" + r_c.side + ")";
            try {
                double val = 0.0;
                this.getVariable("(x, y)").setList(new int[]{r_c.x, r_c.y, r_c.side});
                this.getVariable("occ_{(x, y)}^t").setList(new int[]{1});
                val = r_c.isRight ? this.getGridProbaDists().get(1).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(1).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(occ^t~|~...) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            try {
                double val = 0.0;
                this.getVariable("Tgt_1^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                val = r_c.isRight ? this.getGridProbaDists().get(3).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(3).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(Tgt_1^t~|~...) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            try {
                double val = 0.0;
                this.getVariable("Mot-c^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                val = r_c.isRight ? this.getGridProbaDists().get(20).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(20).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(Mot-c^t~|~...) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
        }
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.TOOLTIP_INFOS, this, msg, null));
        }
    }

    protected void initProbaDistributions() {
        GridReferenceConverter lc = Cell.leftGridRefConverter;
        GridReferenceConverter rc = Cell.rightGridRefConverter;
        double val_norm = 0.01;
        Hashtable<String, String> params = null;
        LeftRight_GridProbabilisticDistribution gpd0 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
        params = new Hashtable<String, String>();
        params.put("searchNames", "Occ^{t-1}_{(x', y')}");
        params.put("knownNames", "Obs^{0:T-1}#Mvt^{0:T-1}");
        params.put("paramNames", "@occ_{(x', y')}^{t-1}:0#@(x', y'):0#@(x', y'):1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        gpd0.init(params);
        LeftRight_GridProbabilisticDistribution gpd1 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Occ^t_{(x, y)}");
        params.put("knownNames", "Obs^{0:T}#Mvt^{0:T}");
        params.put("paramNames", "@occ_{(x, y)}^t:0#@(x, y):0#@(x, y):1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        gpd1.init(params);
        LeftRight_GridProbabilisticDistribution gpd2 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_1^{t-1}");
        params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
        params.put("paramNames", "@Tgt_1^{t-1}:0#@Tgt_1^{t-1}:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd2.init(params);
        LeftRight_GridProbabilisticDistribution gpd3 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_1^t");
        params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
        params.put("paramNames", "@Tgt_1^t:0#@Tgt_1^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd3.init(params);
        LeftRight_GridProbabilisticDistribution gpd4 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Tgt_1^t");
        params.put("searchNames", "Occ_{(x, y)}^t");
        params.put("functionType", "TargetFusionFunction1D");
        params.put("functionParameters", "0.02|0.75");
        params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_1^t");
        gpd4.init(params);
        LeftRight_GridProbabilisticDistribution gpd5 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_2^{t-1}");
        params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
        params.put("paramNames", "@Tgt_2^{t-1}:0#@Tgt_2^{t-1}:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd5.init(params);
        LeftRight_GridProbabilisticDistribution gpd6 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_2^t");
        params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
        params.put("paramNames", "@Tgt_2^t:0#@Tgt_2^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd6.init(params);
        LeftRight_GridProbabilisticDistribution gpd7 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Tgt_2^t");
        params.put("searchNames", "Occ_{(x, y)}^t");
        params.put("functionType", "TargetFusionFunction1D");
        params.put("functionParameters", "0.02|0.75");
        params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_2^t");
        gpd7.init(params);
        LeftRight_GridProbabilisticDistribution gpd8 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_3^{t-1}");
        params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
        params.put("paramNames", "@Tgt_3^{t-1}:0#@Tgt_3^{t-1}:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd8.init(params);
        LeftRight_GridProbabilisticDistribution gpd9 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_3^t");
        params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
        params.put("paramNames", "@Tgt_3^t:0#@Tgt_3^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd9.init(params);
        LeftRight_GridProbabilisticDistribution gpd10 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Tgt_3^t");
        params.put("searchNames", "Occ_{(x, y)}^t");
        params.put("functionType", "TargetFusionFunction1D");
        params.put("functionParameters", "0.02|0.75");
        params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_3^t");
        gpd10.init(params);
        LeftRight_GridProbabilisticDistribution gpd11 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_4^{t-1}");
        params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
        params.put("paramNames", "@Tgt_4^{t-1}:0#@Tgt_4^{t-1}:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd11.init(params);
        LeftRight_GridProbabilisticDistribution gpd12 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_4^t");
        params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
        params.put("paramNames", "@Tgt_4^t:0#@Tgt_4^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd12.init(params);
        LeftRight_GridProbabilisticDistribution gpd13 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Tgt_4^t");
        params.put("searchNames", "Occ_{(x, y)}^t");
        params.put("functionType", "TargetFusionFunction1D");
        params.put("functionParameters", "0.02|0.75");
        params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_4^t");
        gpd13.init(params);
        LeftRight_GridProbabilisticDistribution gpd14 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_5^{t-1}");
        params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
        params.put("paramNames", "@Tgt_5^{t-1}:0#@Tgt_5^{t-1}:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd14.init(params);
        LeftRight_GridProbabilisticDistribution gpd15 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Tgt_5^t");
        params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
        params.put("paramNames", "@Tgt_5^t:0#@Tgt_5^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd15.init(params);
        LeftRight_GridProbabilisticDistribution gpd16 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Tgt_5^t");
        params.put("searchNames", "Occ_{(x, y)}^t");
        params.put("functionType", "TargetFusionFunction1D");
        params.put("functionParameters", "0.02|0.75");
        params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_5^t");
        gpd16.init(params);
        LeftRight_GridProbabilisticDistribution gpd17 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Mot-a^t");
        params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
        params.put("paramNames", "@Mot-a^t:0#@Mot-a^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd17.init(params);
        LeftRight_GridProbabilisticDistribution gpd18 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Mot-b^t");
        params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
        params.put("paramNames", "@Mot-b^t:0#@Mot-b^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd18.init(params);
        LeftRight_GridProbabilisticDistribution gpd19 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("knownNames", "Tgt_i^t");
        params.put("searchNames", "Mot-b^t");
        params.put("functionType", "GaussianGridFunction1D");
        params.put("functionParameters", "0.25|0.01");
        params.put("functionVariableNames", "@Tgt_i^t#@Mot-b^t");
        gpd19.init(params);
        LeftRight_GridProbabilisticDistribution gpd20 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Mot-c^t");
        params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
        params.put("paramNames", "@Mot-c^t:0#@Mot-c^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd20.init(params);
        LeftRight_GridProbabilisticDistribution gpd21 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "Mot-c^t");
        params.put("knownNames", "i^t");
        params.put("paramNames", "@Mot-b^t:0#@Mot-b^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpd21.init(params);
        LeftRight_GridProbabilisticDistribution gpd22 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
        params = new Hashtable();
        params.put("searchNames", "i_{(x, y)}^t");
        params.put("knownNames", "Mot-c^t");
        params.put("functionType", "BetaDistributionFunction1D");
        params.put("functionParameters", "2.0|1.0|1.0");
        params.put("functionVariableNames", "@(x, y)#@Mot-c^t#@i_{(x, y)}^t");
        gpd22.init(params);
        FunctionProbabilisticDistribution fpd0 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Occ_{(x, y)}^t");
        params.put("searchNames", "Obs_{(x, y)}^t");
        params.put("functionType", "Matrix2x2Function1D");
        params.put("functionParameters", "0.9|0.9");
        params.put("functionVariableNames", "obs_{(x, y)}^t#occ_{(x, y)}^t");
        fpd0.init(params);
        FunctionProbabilisticDistribution fpd1 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Occ_{Ant}^{t-1}#Mvt^t");
        params.put("searchNames", "Occ_{(x, y)}^t");
        params.put("functionType", "AffectLeakyAntProbaFunction1D");
        params.put("functionParameters", "0.95|0.9");
        params.put("functionVariableNames", "occ_{(x, y)}^t#(x, y)#occ_{ant}^{t-1}");
        fpd1.init(params);
        FunctionProbabilisticDistribution fpd2 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Obs^{0:t}");
        params.put("searchNames", "Mot-a^t");
        params.put("functionType", "GridHistogram1D");
        params.put("functionParameters", this.loadConstantModelParams("prior_vel.txt"));
        params.put("functionVariableNames", "Mot-a^t");
        fpd2.init(params);
        this.getGridProbaDists().add(gpd0);
        this.getGridProbaDists().add(gpd1);
        this.getGridProbaDists().add(gpd2);
        this.getGridProbaDists().add(gpd3);
        this.getGridProbaDists().add(gpd4);
        this.getGridProbaDists().add(gpd5);
        this.getGridProbaDists().add(gpd6);
        this.getGridProbaDists().add(gpd7);
        this.getGridProbaDists().add(gpd8);
        this.getGridProbaDists().add(gpd9);
        this.getGridProbaDists().add(gpd10);
        this.getGridProbaDists().add(gpd11);
        this.getGridProbaDists().add(gpd12);
        this.getGridProbaDists().add(gpd13);
        this.getGridProbaDists().add(gpd14);
        this.getGridProbaDists().add(gpd15);
        this.getGridProbaDists().add(gpd16);
        this.getGridProbaDists().add(gpd17);
        this.getGridProbaDists().add(gpd18);
        this.getGridProbaDists().add(gpd19);
        this.getGridProbaDists().add(gpd20);
        this.getGridProbaDists().add(gpd21);
        this.getGridProbaDists().add(gpd22);
        this.getOthersProbaDists().add(fpd0);
        this.getOthersProbaDists().add(fpd1);
        this.getOthersProbaDists().add(fpd2);
    }

    /*
     * Unable to fully structure code
     */
    private String loadConstantModelParams(String filename) {
        block8: {
            gridw = Cell.rightGridRefConverter.getPixelWidth();
            gridh = Cell.rightGridRefConverter.getPixelHeight();
            t = new double[gridw][gridh];
            try {
                reader = new BufferedReader(new FileReader(filename));
                j = 0;
                while (j < gridh) {
                    ligne = reader.readLine();
                    tokens = ligne.split("\t");
                    i = 0;
                    while (i < gridw) {
                        t[i][j] = Double.parseDouble(tokens[i]);
                        ++i;
                    }
                    ++j;
                }
                break block8;
            }
            catch (Exception e) {
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, "Error$Unable to load constant parameters.", null));
                continue;
            }
lbl23:
            // 1 sources

            e.printStackTrace();
        }
        s = "" + t[0][0];
        j = 1;
        while (j < gridh) {
            s = String.valueOf(s) + "," + t[0][j];
            ++j;
        }
        i = 1;
        while (i < gridw) {
            s = String.valueOf(s) + "|" + t[i][0];
            j = 1;
            while (j < gridh) {
                s = String.valueOf(s) + "," + t[i][j];
                ++j;
            }
            ++i;
        }
        return s;
    }

    private String getConstantModelParams() {
        int j;
        int gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.rightGridRefConverter.getPixelHeight();
        double[][] t = new double[gridw][gridh];
        double mh = gridh / 2;
        double mw = gridw - 1;
        int i = 0;
        while (i < gridw) {
            int j2 = 0;
            while (j2 < gridh) {
                t[i][j2] = 1.0 / (10.0 + ((double)i - mw) * ((double)i - mw) + ((double)j2 - mh) * ((double)j2 - mh));
                ++j2;
            }
            ++i;
        }
        double Z = 0.0;
        int i2 = 0;
        while (i2 < gridw) {
            j = 0;
            while (j < gridh) {
                Z += t[i2][j];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < gridw) {
            j = 0;
            while (j < gridh) {
                t[i2][j] = t[i2][j] / (2.0 * Z);
                ++j;
            }
            ++i2;
        }
        String s = "" + t[0][0];
        j = 1;
        while (j < gridh) {
            s = String.valueOf(s) + "," + t[0][j];
            ++j;
        }
        int i3 = 1;
        while (i3 < gridw) {
            s = String.valueOf(s) + "|" + t[i3][0];
            int j3 = 1;
            while (j3 < gridh) {
                s = String.valueOf(s) + "," + t[i3][j3];
                ++j3;
            }
            ++i3;
        }
        return s;
    }

    protected void initRandomVariables() {
        int gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.rightGridRefConverter.getPixelHeight();
        int[] l_zero_p = Cell.getZeroGridPos(false);
        int[] r_zero_p = Cell.getZeroGridPos(true);
        Object domain = RandomVariable.getDomainForGridPos(gridw, gridh);
        this.setVariable(new LeftRight_Variable(l_zero_p, r_zero_p, "Mvt^t", (int[][])domain));
        this.setVariable(new RandomVariable("(x, y)", (int[][])domain));
        this.setVariable(new RandomVariable("(x', y')", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_i^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_1^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_1^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_2^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_2^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_3^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_3^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_4^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_4^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_5^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_5^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Mot-a^t", (int[][])domain));
        this.setVariable(new RandomVariable("Mot-b^t", (int[][])domain));
        this.setVariable(new RandomVariable("Mot-c^t", (int[][])domain));
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        byte[] bdomain = byArray;
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Obs^t", bdomain));
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        domain = nArrayArray;
        this.setVariable(new RandomVariable("obs_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("occ_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("occ_{(x', y')}^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("occ_{ant}^{t-1}", (int[][])domain));
        bdomain = new byte[Antecedent.getMaxAntecedentsNb() + 1];
        int i = 0;
        while (i < bdomain.length) {
            bdomain[i] = i;
            i = (byte)(i + 1);
        }
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Ant", bdomain));
        this.setVariable(new LeftRight_Variable(gridw, gridh, "CAnt", bdomain));
        double[] rdomain = new double[]{0.0, 1.0};
        this.setVariable(new RandomVariable(0.0, "i_{(x, y)}^t", rdomain));
    }

    /*
     * Unable to fully structure code
     */
    protected void subInfer() {
        block5: {
            try {
                this.updateVariables();
                this.Q1a_computeInference();
                i = 1;
                while (i <= 5) {
                    this.Q1b_computeInference(i);
                    ++i;
                }
                this.Q2a_computeInference();
                this.Q2b_computeInference();
                this.Q2c_computeInference();
                this.notifyUpdate();
            }
            catch (ShowableException se) {
                msg = se.getMessage();
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, msg, null));
                continue;
lbl20:
                // 1 sources

                break block5;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "subInfer");
            }
        }
    }

    protected void updateVariables1() throws ShowableException {
        Cell sacc_cell = this.updateSaccade();
        Position saccade = sacc_cell.centerPos;
        double saccade_thres2 = 0.25;
        boolean suppression = false;
        if (this.lastSaccadeCell == null || !this.lastSaccadeCell.equals(sacc_cell)) {
            Position sacc_pos = sacc_cell.centerPos;
            Antecedent.setAllAntecedentsFromATranslation(sacc_pos);
            this.lastSaccadeCell = sacc_cell;
            System.out.println("V25_BossEngine::updateVariables -new saccade");
        }
        this.updateObservation(suppression);
        this.updateAntecedent(true, "CAnt");
        this.updateAntecedent(false, "Ant");
        this.notifyUpdate();
    }

    protected void updateVariables0() throws ShowableException {
        boolean suppression = false;
        this.updateObservation(suppression);
        this.updateAntecedent(true, "CAnt");
        this.updateAntecedent(false, "Ant");
        this.shiftObjTgt();
        this.notifyUpdate();
    }

    protected void updateVariables() throws ShowableException {
        Cell sacc_cell = this.updateSaccade();
        Position saccade = sacc_cell.centerPos;
        double saccade_thres2 = 0.25;
        boolean suppression = false;
        if (this.lastSaccadeCell == null || !this.lastSaccadeCell.equals(sacc_cell)) {
            Position sacc_pos = sacc_cell.centerPos;
            Antecedent.setAllAntecedentsFromATranslation(sacc_pos);
            this.lastSaccadeCell = sacc_cell;
            System.out.println("V25_BossEngine::updateVariables -new saccade");
        }
        this.updateObservation(suppression);
        this.updateAntecedent(true, "CAnt");
        this.updateAntecedent(false, "Ant");
        this.shiftObjTgt();
        this.notifyUpdate();
    }

    private void shiftObjTgt() {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        ProbabilisticDistribution[] occ_t = new ProbabilisticDistribution[]{this.getGridProbaDists().get(1).getLeftPart(), this.getGridProbaDists().get(1).getRightPart()};
        ProbabilisticDistribution[] occ_t_1 = new ProbabilisticDistribution[]{this.getGridProbaDists().get(0).getLeftPart(), this.getGridProbaDists().get(0).getRightPart()};
        ProbabilisticDistribution[][] tgt_t = new ProbabilisticDistribution[][]{{this.getGridProbaDists().get(3).getLeftPart(), this.getGridProbaDists().get(3).getRightPart()}, {this.getGridProbaDists().get(6).getLeftPart(), this.getGridProbaDists().get(6).getRightPart()}, {this.getGridProbaDists().get(9).getLeftPart(), this.getGridProbaDists().get(9).getRightPart()}, {this.getGridProbaDists().get(12).getLeftPart(), this.getGridProbaDists().get(12).getRightPart()}, {this.getGridProbaDists().get(15).getLeftPart(), this.getGridProbaDists().get(15).getRightPart()}};
        ProbabilisticDistribution[][] tgt_t_1 = new ProbabilisticDistribution[][]{{this.getGridProbaDists().get(2).getLeftPart(), this.getGridProbaDists().get(2).getRightPart()}, {this.getGridProbaDists().get(5).getLeftPart(), this.getGridProbaDists().get(5).getRightPart()}, {this.getGridProbaDists().get(8).getLeftPart(), this.getGridProbaDists().get(8).getRightPart()}, {this.getGridProbaDists().get(11).getLeftPart(), this.getGridProbaDists().get(11).getRightPart()}, {this.getGridProbaDists().get(14).getLeftPart(), this.getGridProbaDists().get(14).getRightPart()}};
        try {
            int s = 0;
            while (s < 2) {
                int i = 0;
                while (i < gridw) {
                    int j = 0;
                    while (j < gridh) {
                        double proba;
                        this.getVariables().get("(x, y)").setList(new int[]{i, j, s});
                        this.getVariables().get("(x', y')").setList(new int[]{i, j, s});
                        int k = 1;
                        while (k <= 5) {
                            this.getVariables().get("Tgt_" + k + "^t").setList(new int[]{i, j, s});
                            this.getVariables().get("Tgt_" + k + "^{t-1}").setList(new int[]{i, j, s});
                            proba = tgt_t[k - 1][s].getValue(this.getVariables());
                            tgt_t_1[k - 1][s].setNewValue(this.getVariables(), proba);
                            ++k;
                        }
                        int v = 0;
                        while (v < 2) {
                            this.getVariables().get("occ_{(x, y)}^t").setList(new int[]{v});
                            this.getVariables().get("occ_{(x', y')}^{t-1}").setList(new int[]{v++});
                            proba = occ_t[s].getValue(this.getVariables());
                            occ_t_1[s].setNewValue(this.getVariables(), proba);
                        }
                        ++j;
                    }
                    ++i;
                }
                occ_t_1[s].updateValues();
                int k = 0;
                while (k < 5) {
                    tgt_t_1[k][s].updateValues();
                    ++k;
                }
                ++s;
            }
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "shiftObjTgt");
        }
    }

    private final void Q2c_computeInference() throws Exception {
        int j;
        int i;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double[][][] prob_dist = new double[2][gridw][gridh];
        ProbabilisticDistribution[] p_occ = new ProbabilisticDistribution[]{this.getGridProbaDists().get(1).getLeftPart(), this.getGridProbaDists().get(1).getRightPart()};
        ProbabilisticDistribution[] p_mot_c = new ProbabilisticDistribution[]{this.getGridProbaDists().get(20).getLeftPart(), this.getGridProbaDists().get(20).getRightPart()};
        ProbabilisticDistribution[] p_mot_b = new ProbabilisticDistribution[]{this.getGridProbaDists().get(18).getLeftPart(), this.getGridProbaDists().get(18).getRightPart()};
        ProbabilisticDistribution[] p_mot_i = new ProbabilisticDistribution[]{this.getGridProbaDists().get(21).getLeftPart(), this.getGridProbaDists().get(21).getRightPart()};
        ProbabilisticDistribution[] p_i_mot = new ProbabilisticDistribution[]{this.getGridProbaDists().get(22).getLeftPart(), this.getGridProbaDists().get(22).getRightPart()};
        double tmp_proba = 0.0;
        double tmp_sum = 0.0;
        this.getVariable("occ_{(x, y)}^t").setList(new int[]{1});
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("Mot-b^t").setList(new int[]{i, j, s});
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        this.getVariable("i_{(x, y)}^t").setRealVal(p_occ[s].getValue(this.getVariables()));
                        tmp_proba = p_i_mot[s].getValue(this.getVariables());
                    } else {
                        tmp_proba = 0.0;
                    }
                    p_mot_i[s].setNewValue(this.getVariables(), tmp_proba);
                    double d = tmp_proba *= p_mot_b[s].getValue(this.getVariables());
                    prob_dist[s][i][j] = d;
                    tmp_sum += d;
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                    p_mot_c[s].setNewValue(this.getVariables(), prob_dist[s][i][j] / tmp_sum);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        p_mot_c[0].updateValues();
        p_mot_c[1].updateValues();
        p_mot_i[0].updateValues();
        p_mot_i[1].updateValues();
        this.notifyUpdate();
    }

    private final void Q2b_computeInference() throws Exception {
        int j_m;
        int i_m;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double[][][][] prob_dists = new double[6][2][gridw][gridh];
        ProbabilisticDistribution[] p_mot_a = new ProbabilisticDistribution[]{this.getGridProbaDists().get(17).getLeftPart(), this.getGridProbaDists().get(17).getRightPart()};
        ProbabilisticDistribution[] p_mot = new ProbabilisticDistribution[]{this.getGridProbaDists().get(18).getLeftPart(), this.getGridProbaDists().get(18).getRightPart()};
        ProbabilisticDistribution[] p_tgt_mot = new ProbabilisticDistribution[]{this.getGridProbaDists().get(19).getLeftPart(), this.getGridProbaDists().get(19).getRightPart()};
        ProbabilisticDistribution[][] p_tgt = new ProbabilisticDistribution[][]{{this.getGridProbaDists().get(3).getLeftPart(), this.getGridProbaDists().get(3).getRightPart()}, {this.getGridProbaDists().get(6).getLeftPart(), this.getGridProbaDists().get(6).getRightPart()}, {this.getGridProbaDists().get(9).getLeftPart(), this.getGridProbaDists().get(9).getRightPart()}, {this.getGridProbaDists().get(12).getLeftPart(), this.getGridProbaDists().get(12).getRightPart()}, {this.getGridProbaDists().get(15).getLeftPart(), this.getGridProbaDists().get(15).getRightPart()}};
        double tmp_proba = 1.0;
        double tmp_sum = 0.0;
        double[] sums = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        int nb_zeros = 0;
        int s_m = 0;
        while (s_m < 2) {
            int i_m2 = 0;
            while (i_m2 < gridw) {
                int j_m2 = 0;
                while (j_m2 < gridh) {
                    int n = 0;
                    while (n < 5) {
                        prob_dists[n][s_m][i_m2][j_m2] = 0.0;
                        sums[n] = 0.0;
                        ++n;
                    }
                    if (Cell.gridCells[s_m][i_m2][j_m2].isInsideTheGrid) {
                        this.getVariable("Mot-a^t").setList(new int[]{i_m2, j_m2, s_m});
                        this.getVariable("Mot-b^t").setList(new int[]{i_m2, j_m2, s_m});
                        int s = 0;
                        while (s < 2) {
                            int i = 0;
                            while (i < gridw) {
                                int j = 0;
                                while (j < gridh) {
                                    if (Cell.gridCells[s_m][i_m2][j_m2].isInsideTheGrid) {
                                        this.getVariable("Tgt_i^t").setList(new int[]{i, j, s});
                                        int n2 = 0;
                                        while (n2 < 5) {
                                            this.getVariable("Tgt_" + (n2 + 1) + "^t").setList(new int[]{i, j, s});
                                            int n3 = n2;
                                            double[] dArray = prob_dists[n2][s_m][i_m2];
                                            int n4 = j_m2;
                                            double d = dArray[n4] + p_tgt[n2][s].getValue(this.getVariables()) * p_tgt_mot[s_m].getValue(this.getVariables());
                                            dArray[n4] = d;
                                            sums[n3] = sums[n3] + d;
                                            ++n2;
                                        }
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            ++s;
                        }
                        tmp_proba = 1.0;
                        n = 0;
                        while (n < 5) {
                            if (sums[n] > 0.0) {
                                tmp_proba *= prob_dists[n][s_m][i_m2][j_m2];
                                ++nb_zeros;
                            }
                            ++n;
                        }
                    } else {
                        tmp_proba = 0.0;
                    }
                    double d = tmp_proba * p_mot_a[s_m].getValue(this.getVariables());
                    prob_dists[5][s_m][i_m2][j_m2] = d;
                    tmp_sum += d;
                    ++j_m2;
                }
                ++i_m2;
            }
            ++s_m;
        }
        double[] subSums_ctl = new double[]{0.0, 0.0, 0.0, 0.0};
        double tmp_sum_ctl = 0.0;
        int s_m2 = 0;
        while (s_m2 < 2) {
            i_m = 0;
            while (i_m < gridw / 2) {
                j_m = 0;
                while (j_m < gridh) {
                    tmp_sum_ctl += prob_dists[5][s_m2][i_m][j_m];
                    int n = s_m2;
                    subSums_ctl[n] = subSums_ctl[n] + prob_dists[5][s_m2][i_m][j_m];
                    ++j_m;
                }
                ++i_m;
            }
            i_m = gridw / 2;
            while (i_m < gridw) {
                j_m = 0;
                while (j_m < gridh) {
                    tmp_sum_ctl += prob_dists[5][s_m2][i_m][j_m];
                    int n = 2 + s_m2;
                    subSums_ctl[n] = subSums_ctl[n] + prob_dists[5][s_m2][i_m][j_m];
                    ++j_m;
                }
                ++i_m;
            }
            ++s_m2;
        }
        System.out.println("tmp_sum:" + tmp_sum);
        System.out.println("Control: " + subSums_ctl[0] + "+" + subSums_ctl[1] + "+" + subSums_ctl[2] + "+" + subSums_ctl[3] + " = " + tmp_sum_ctl);
        if (tmp_sum > 0.0) {
            s_m2 = 0;
            while (s_m2 < 2) {
                i_m = 0;
                while (i_m < gridw) {
                    j_m = 0;
                    while (j_m < gridh) {
                        this.getVariable("Mot-b^t").setList(new int[]{i_m, j_m, s_m2});
                        p_mot[s_m2].setNewValue(this.getVariables(), prob_dists[5][s_m2][i_m][j_m] / tmp_sum);
                        ++j_m;
                    }
                    ++i_m;
                }
                ++s_m2;
            }
        }
        p_mot[0].updateValues();
        p_mot[1].updateValues();
        this.notifyUpdate();
    }

    private final void Q2a_computeInference() throws Exception {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double p = 0.0;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        try {
                            this.getVariable("Mot-a^t").setList(new int[]{i, j, s});
                        }
                        catch (Exception e) {
                            Utilities.exceptionCaughtMessage(e, this, "Q2a_computeInference");
                        }
                        p = this.getOthersProbaDists().get(2).getValue(this.getVariables());
                    } else {
                        p = 0.0;
                    }
                    this.getVariable("Mot-a^t").setList(new int[]{i, j, s});
                    if (s == 0) {
                        this.getGridProbaDists().get(17).getLeftPart().setNewValue(this.getVariables(), p);
                    } else {
                        this.getGridProbaDists().get(17).getRightPart().setNewValue(this.getVariables(), p);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(17).getLeftPart().updateValues();
        this.getGridProbaDists().get(17).getRightPart().updateValues();
        this.notifyUpdate();
    }

    private final void Q1b_computeInference(int tgt_num) throws Exception {
        int j;
        int i;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double proba_total = 0.0;
        double proba = 0.0;
        double t_proba = 0.0;
        ProbabilisticDistribution[] tgt_t = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3 * tgt_num).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num).getRightPart()};
        ProbabilisticDistribution[] tgt_t_1 = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3 * tgt_num - 1).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num - 1).getRightPart()};
        ProbabilisticDistribution[] occ_t = new ProbabilisticDistribution[]{this.getGridProbaDists().get(1).getLeftPart(), this.getGridProbaDists().get(1).getRightPart()};
        ProbabilisticDistribution[] p_occ_tgt = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3 * tgt_num + 1).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num + 1).getRightPart()};
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    proba = 0.0;
                    this.getVariables().get("Tgt_" + tgt_num + "^t").setList(new int[]{i, j, s});
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        Cell[] ants = Antecedent.getCells(i, j, s);
                        int[] nums = Antecedent.gridAntsNumerosity[s][i][j];
                        int ii = 0;
                        while (ii < ants.length) {
                            this.getVariables().get("Tgt_" + tgt_num + "^{t-1}").setList(new int[]{ants[ii].x, ants[ii].y, ants[ii].side});
                            proba += tgt_t_1[ants[ii].side].getValue(this.getVariables()) * (double)nums[ii];
                            ++ii;
                        }
                        int t = 0;
                        while (t < 2) {
                            int k = 0;
                            while (k < gridw) {
                                int l = 0;
                                while (l < gridh) {
                                    this.getVariables().get("(x, y)").setList(new int[]{k, l, t});
                                    t_proba = 0.0;
                                    int v = 0;
                                    while (v <= 1) {
                                        this.getVariables().get("occ_{(x, y)}^t").setList(new int[]{v++});
                                        t_proba += occ_t[t].getValue(this.getVariables()) * p_occ_tgt[s].getValue(this.getVariables());
                                    }
                                    proba *= t_proba;
                                    ++l;
                                }
                                ++k;
                            }
                            ++t;
                        }
                    }
                    proba_total += proba;
                    tgt_t[s].setNewValue(this.getVariables(), proba);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        tgt_t[0].updateValues();
        tgt_t[1].updateValues();
        if (proba_total == 0.0) {
            proba_total = 1.0;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariables().get("Tgt_" + tgt_num + "^t").setList(new int[]{i, j++, s});
                    tgt_t[s].setNewValue(this.getVariables(), tgt_t[s].getValue(this.getVariables()) / proba_total);
                }
                ++i;
            }
            ++s;
        }
        tgt_t[0].updateValues();
        tgt_t[1].updateValues();
    }

    private final void Q1a_computeInference() throws Exception {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        int[][] var_domain = this.getVariable("occ_{(x, y)}^t").getListDomain();
        double proba_total = 0.0;
        int s = 0;
        while (s < 2) {
            byte[][] obs_val = s == 0 ? this.getVariable("L-Obs^t").getTable() : this.getVariable("R-Obs^t").getTable();
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    int k;
                    double[] proba_prod;
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        proba_total = 0.0;
                        double[] proba_vois = new double[var_domain[0].length];
                        double[] proba_capt = new double[var_domain[0].length];
                        proba_prod = new double[var_domain[0].length];
                        this.getVariable("obs_{(x, y)}^t").setListVar(0, obs_val[i][j]);
                        k = 0;
                        while (k < var_domain[0].length) {
                            this.getVariable("occ_{(x, y)}^t").setListVar(0, var_domain[0][k]);
                            this.getVariable("(x, y)").setList(new int[]{i, j, s});
                            proba_vois[k] = this.Q1_getSum(i, j, s, "occ", 0, 1);
                            if (new Double(proba_vois[k]).isNaN() || proba_vois[k] == 0.0) {
                                System.out.println("vois NaN/0 in (" + i + ", " + j + "):" + s);
                            }
                            proba_capt[k] = this.getOthersProbaDists().get(0).getValue(this.getVariables());
                            if (new Double(proba_capt[k]).isNaN() || proba_capt[k] == 0.0) {
                                System.out.println("capt NaN/0 in (" + i + ", " + j + "):" + s);
                            }
                            proba_prod[k] = proba_capt[k] * proba_vois[k];
                            proba_total += proba_prod[k];
                            ++k;
                        }
                    } else {
                        proba_prod = new double[]{1.0, 0.0};
                        proba_total = 1.0;
                    }
                    k = 0;
                    while (k < var_domain[0].length) {
                        int var_val = var_domain[0][k];
                        this.getVariable("occ_{(x, y)}^t").setList(new int[]{var_val});
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        if (proba_total == 0.0) {
                            System.out.println("tot NaN in (" + i + ", " + j + "):" + s);
                        }
                        if (s == 0) {
                            this.getGridProbaDists().get(1).getLeftPart().setNewValue(this.getVariables(), proba_prod[k] / proba_total);
                        } else {
                            this.getGridProbaDists().get(1).getRightPart().setNewValue(this.getVariables(), proba_prod[k] / proba_total);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(1).getLeftPart().updateValues();
        this.getGridProbaDists().get(1).getRightPart().updateValues();
    }

    private final double Q1_getSum(int x, int y, int side, String varname, int dist_t_1, int dist_dyn) throws Exception {
        Cell[] ant_cells = Antecedent.getCells(x, y, side);
        int[] val_ants = new int[ant_cells.length];
        int max_powa = (int)StrictMath.rint(StrictMath.pow(2.0, ant_cells.length));
        int[] two_p = new int[ant_cells.length];
        int k = 0;
        while (k < two_p.length) {
            two_p[k] = (int)StrictMath.rint(StrictMath.pow(2.0, k));
            ++k;
        }
        double proba_sum = 0.0;
        if (val_ants.length != 0) {
            int[][] domain = new int[val_ants.length][2];
            int i = 0;
            while (i < domain.length) {
                int[] nArray = new int[2];
                nArray[1] = 1;
                domain[i] = nArray;
                ++i;
            }
            this.setVariable(new RandomVariable(String.valueOf(varname) + "_{ant}^{t-1}", domain));
            int[] cpts = new int[ant_cells.length];
            int[] values = new int[ant_cells.length];
            double proba1 = 0.0;
            double proba2 = 0.0;
            int k2 = 0;
            while (k2 < max_powa) {
                int i2 = 0;
                while (i2 < ant_cells.length) {
                    val_ants[i2] = values[i2];
                    int n = i2;
                    cpts[n] = cpts[n] + 1;
                    if (cpts[i2] % two_p[i2] == 0) {
                        values[i2] = (values[i2] + 1) % 2;
                    }
                    ++i2;
                }
                this.getVariable(String.valueOf(varname) + "_{ant}^{t-1}").setList(val_ants);
                proba1 = this.getOthersProbaDists().get(dist_dyn).getValue(this.getVariables());
                proba2 = this.Q1_getSum_getOldQ1(ant_cells, val_ants, varname, dist_t_1);
                proba_sum += proba1 * proba2;
                ++k2;
            }
        } else {
            proba_sum = 0.99999;
            if (this.getVariables().get("occ_{(x, y)}^t").getListVar(0) == 1) {
                proba_sum = 1.0 - proba_sum;
            }
        }
        return proba_sum;
    }

    private final double Q1_getSum_getOldQ1(Cell[] antCells, int[] antVals, String varname, int dist) throws Exception {
        double retour = 1.0;
        double proba = 0.0;
        int[] ant_cell_pos = null;
        GridProbabilisticDistribution gpd = null;
        int i = 0;
        while (i < antCells.length) {
            ant_cell_pos = new int[]{antCells[i].x, antCells[i].y};
            this.getVariable("(x', y')").setList(ant_cell_pos);
            this.getVariable(String.valueOf(varname) + "_{(x', y')}^{t-1}").setList(new int[]{antVals[i]});
            gpd = antCells[i].isRight ? this.getGridProbaDists().get(dist).getRightPart() : this.getGridProbaDists().get(dist).getLeftPart();
            proba = gpd.getValue(this.getVariables());
            retour *= proba;
            ++i;
        }
        return retour;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Cell updateSaccade() throws ShowableException {
        if (this.getSaccades().size() < 1) {
            String msg = String.valueOf(this.getClass().getName()) + "::updateSaccade" + " -error";
            System.out.println(String.valueOf(msg) + " not enough saccades");
            msg = "Problem in the data update$Update of the saccades data is not possible :\nnot enough saccades !";
            throw new ShowableException(msg);
        }
        String var_name1 = "";
        String var_name2 = "";
        Cell sacc_cell = Cell.getCell(this.getSaccades().get((int)0).position);
        if (sacc_cell == null) {
            System.out.println(String.valueOf(this.getClass().getName()) + "::updateSaccade" + " infos saccade pos outside the grid (" + sacc_cell.x + "," + sacc_cell.y + "), Sacc^t not updated");
            return null;
        }
        if (sacc_cell.isRight) {
            var_name1 = "R-Mvt^t";
            var_name2 = "L-Mvt^t";
        } else {
            var_name1 = "L-Mvt^t";
            var_name2 = "R-Mvt^t";
        }
        try {
            this.getVariable(var_name1).setListVar(0, sacc_cell.x);
            this.getVariable(var_name1).setListVar(1, sacc_cell.y);
            this.getVariable(var_name2).setToDefaultValues();
            return sacc_cell;
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "updateSaccade");
            return null;
        }
    }

    private final void updateObservation(boolean suppression) throws ShowableException {
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_obs = new byte[l_gridw][gridh];
        byte[][] r_obs = new byte[r_gridw][gridh];
        if (!suppression) {
            for (Observation observation : this.getObservations()) {
                this.fillObservation(observation, l_obs, r_obs);
            }
            for (Target target : this.getTargets()) {
                this.fillObservation(target, l_obs, r_obs);
            }
        }
        try {
            this.getVariable("R-Obs^t").setTable(r_obs);
            this.getVariable("L-Obs^t").setTable(l_obs);
        }
        catch (Exception exception) {
            Utilities.exceptionCaughtMessage(exception, this, "updateObservation");
        }
    }

    private final void updateAntecedent(boolean colored, String varName) throws ShowableException {
        int val;
        int[] nums;
        Cell[] crt_ants;
        Cell crt_cell;
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_ant = new byte[l_gridw][gridh];
        byte[][] r_ant = new byte[r_gridw][gridh];
        if (this.getObservations() != null && this.getObservations().size() > 0) {
            for (Observation observation : this.getObservations()) {
                crt_cell = Cell.getCell(observation.position);
                if (crt_cell == null) continue;
                crt_ants = Antecedent.getCells(crt_cell);
                nums = Antecedent.getNumerosity(crt_cell);
                int i = 0;
                while (i < crt_ants.length) {
                    val = 10;
                    if (colored) {
                        val = (byte)nums[i];
                    }
                    if (crt_ants[i].isRight) {
                        r_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    } else {
                        l_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    }
                    ++i;
                }
                try {
                    this.getVariable("R-" + varName).setTable(r_ant);
                    this.getVariable("L-" + varName).setTable(l_ant);
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "updateAnt");
                }
            }
        }
        if (this.getTargets() != null && this.getTargets().size() > 0) {
            for (Observation observation : this.getTargets()) {
                crt_cell = Cell.getCell(observation.position);
                if (crt_cell == null) continue;
                crt_ants = Antecedent.getCells(crt_cell);
                nums = Antecedent.getNumerosity(crt_cell);
                int i = 0;
                while (i < crt_ants.length) {
                    val = 10;
                    if (colored) {
                        val = (byte)nums[i];
                    }
                    if (crt_ants[i].isRight) {
                        r_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    } else {
                        l_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    }
                    ++i;
                }
                try {
                    this.getVariable("R-" + varName).setTable(r_ant);
                    this.getVariable("L-" + varName).setTable(l_ant);
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "updateAnt");
                }
            }
        }
    }

    private final void fillObservation(Observation crtT, byte[][] l_obs, byte[][] r_obs) {
        double sq_radius = StrictMath.pow(crtT.size / 2.0, 2.0);
        double h_c = crtT.position.getX1();
        double v_c = crtT.position.getY1();
        GridReferenceConverter l_grc = Cell.leftGridRefConverter;
        GridReferenceConverter r_grc = Cell.rightGridRefConverter;
        int gridw = l_grc.getPixelWidth();
        int gridh = l_grc.getPixelHeight();
        int i = 0;
        while (i < gridw) {
            int j = 0;
            while (j < gridh) {
                Position l_pos = new Position(l_grc.xBasic(i), l_grc.yBasic(j), false);
                Position r_pos = new Position(r_grc.xBasic(i), r_grc.yBasic(j), false);
                if (Cell.gridCells[0][i][j].isInsideTheGrid && sq_radius >= StrictMath.pow(l_pos.getX1() - h_c, 2.0) + StrictMath.pow(l_pos.getY1() - v_c, 2.0)) {
                    l_obs[i][j] = 1;
                }
                if (Cell.gridCells[1][i][j].isInsideTheGrid && sq_radius >= StrictMath.pow(r_pos.getX1() - h_c, 2.0) + StrictMath.pow(r_pos.getY1() - v_c, 2.0)) {
                    r_obs[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        Cell t_cell = Cell.getCell(crtT.position);
        if (t_cell.isRight) {
            r_obs[t_cell.x][t_cell.y] = 1;
        } else {
            l_obs[t_cell.x][t_cell.y] = 1;
        }
    }

    protected void flash() {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_tgt = new byte[gridw][gridh];
        byte[][] r_tgt = new byte[gridw][gridh];
        try {
            int j;
            int tgt_num = 1;
            for (Target t : this.getTargets()) {
                int i = 0;
                while (i < gridw) {
                    j = 0;
                    while (j < gridh) {
                        r_tgt[i][j] = 0;
                        l_tgt[i][j] = 0;
                        ++j;
                    }
                    ++i;
                }
                this.fillObservation(t, l_tgt, r_tgt);
                double Z = 0.0;
                int i2 = 0;
                while (i2 < gridw) {
                    int j2 = 0;
                    while (j2 < gridh) {
                        Z += (double)(l_tgt[i2][j2] + r_tgt[i2][j2]);
                        ++j2;
                    }
                    ++i2;
                }
                double K = 0.5;
                int i3 = 0;
                while (i3 < gridw) {
                    int j3 = 0;
                    while (j3 < gridh) {
                        int[] nArray = new int[3];
                        nArray[0] = i3;
                        nArray[1] = j3;
                        this.getVariable("Tgt_" + tgt_num + "^t").setList(nArray);
                        this.getGridProbaDists().get(3 * tgt_num).getLeftPart().setNewValue(this.getVariables(), (K / (double)(gridh * gridw) + (double)l_tgt[i3][j3]) / (Z + K));
                        this.getVariable("Tgt_" + tgt_num + "^t").setList(new int[]{i3, j3, 1});
                        this.getGridProbaDists().get(3 * tgt_num).getRightPart().setNewValue(this.getVariables(), (K / (double)(gridh * gridw) + (double)r_tgt[i3][j3]) / (Z + K));
                        ++j3;
                    }
                    ++i3;
                }
                this.getGridProbaDists().get(3 * tgt_num).getLeftPart().updateValues();
                this.getGridProbaDists().get(3 * tgt_num).getRightPart().updateValues();
                if (++tgt_num > 5) break;
            }
            if (tgt_num <= 5) {
                while (tgt_num <= 5) {
                    int i = 0;
                    while (i < gridw) {
                        int j4 = 0;
                        while (j4 < gridh) {
                            int[] nArray = new int[3];
                            nArray[0] = i;
                            nArray[1] = j4;
                            this.getVariable("Tgt_" + tgt_num + "^t").setList(nArray);
                            this.getGridProbaDists().get(3 * tgt_num).getLeftPart().setNewValue(this.getVariables(), 0.0);
                            this.getVariable("Tgt_" + tgt_num + "^t").setList(new int[]{i, j4++, 1});
                            this.getGridProbaDists().get(3 * tgt_num).getRightPart().setNewValue(this.getVariables(), 0.0);
                        }
                        ++i;
                    }
                    this.getGridProbaDists().get(3 * tgt_num).getLeftPart().updateValues();
                    this.getGridProbaDists().get(3 * tgt_num).getRightPart().updateValues();
                    ++tgt_num;
                }
            }
            this.updateObservation(false);
            byte[][] l_obj = this.getVariable("L-Obs^t").getTable();
            byte[][] r_obj = this.getVariable("R-Obs^t").getTable();
            int i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("occ_{(x, y)}^t").setListVar(0, 0);
                    int[] nArray = new int[3];
                    nArray[0] = i;
                    nArray[1] = j;
                    this.getVariable("(x, y)").setList(nArray);
                    this.getGridProbaDists().get(1).getLeftPart().setNewValue(this.getVariables(), 0.99999 - 0.99998 * (double)l_obj[i][j]);
                    this.getVariable("(x, y)").setList(new int[]{i, j, 1});
                    this.getGridProbaDists().get(1).getRightPart().setNewValue(this.getVariables(), 0.99999 - 0.99998 * (double)r_obj[i][j]);
                    this.getVariable("occ_{(x, y)}^t").setListVar(0, 1);
                    this.getGridProbaDists().get(1).getRightPart().setNewValue(this.getVariables(), 1.0E-5 + 0.99998 * (double)r_obj[i][j]);
                    int[] nArray2 = new int[3];
                    nArray2[0] = i;
                    nArray2[1] = j;
                    this.getVariable("(x, y)").setList(nArray2);
                    this.getGridProbaDists().get(1).getLeftPart().setNewValue(this.getVariables(), 1.0E-5 + 0.99998 * (double)l_obj[i][j]);
                    ++j;
                }
                ++i;
            }
            this.getGridProbaDists().get(1).getLeftPart().updateValues();
            this.getGridProbaDists().get(1).getRightPart().updateValues();
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "flash");
        }
        this.notifyUpdate();
    }

    protected Position decideSaccade() {
        throw new Error("Unresolved compilation problem: \n\tThe method decideSaccade() of type V25_BossEngine must override a superclass method\n");
    }

    protected Position decideSaccade(int n) {
        throw new Error("Unresolved compilation problem: \n\tThe type V25_BossEngine must implement the inherited abstract method BossEngine.decideSaccade(int)\n");
    }

    protected int[] solveTask() {
        throw new Error("Unresolved compilation problem: \n\tThe type V25_BossEngine must implement the inherited abstract method BossEngine.solveTask()\n");
    }
}

