/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Antecedent;
import engine.BossEngine;
import engine.Cell;
import engine.FunctionProbabilisticDistribution;
import engine.GridPosDebugPolicy;
import engine.GridProbabilisticDistribution;
import engine.LeftRight_GridProbabilisticDistribution;
import engine.LeftRight_Variable;
import engine.Observation;
import engine.ProbabilisticDistribution;
import engine.RandomVariable;
import engine.ShowableException;
import engine.Target;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.View;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import utils.GridReferenceConverter;
import utils.Position;
import utils.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V251_BossEngine
extends BossEngine {
    private static BossEngine uniqInstance = null;
    private Cell lastSaccadeCell;

    private V251_BossEngine() {
    }

    public static BossEngine getInstance() {
        if (uniqInstance == null) {
            uniqInstance = new V251_BossEngine();
            BossEngine.appliVersion = "2.51";
            uniqInstance.setDebugPolicy(new GridPosDebugPolicy());
        }
        return uniqInstance;
    }

    @Override
    protected void getCellInfos(Position requestPos, String elementName) {
        Cell r_c = Cell.getCell(requestPos);
        String msg = "";
        if (r_c == null) {
            msg = "No cell !";
        } else {
            msg = "Cell (" + r_c.x + "," + r_c.y + ":" + r_c.side + ")";
            try {
                double val = 0.0;
                this.getVariable("(x, y)").setList(new int[]{r_c.x, r_c.y, r_c.side});
                this.getVariable("occ_{(x, y)}^t").setList(new int[]{1});
                val = r_c.isRight ? this.getGridProbaDists().get(1).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(1).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(occ^t~|~...) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            try {
                double val = 0.0;
                this.getVariable("Tgt_1^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                val = r_c.isRight ? this.getGridProbaDists().get(3).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(3).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(Tgt_1^t~|~...) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            try {
                double val = 0.0;
                this.getVariable("Mot-c^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                val = r_c.isRight ? this.getGridProbaDists().get(20).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(20).getLeftPart().getValue(this.getVariables());
                msg = String.valueOf(msg) + " || P(Mot-c^t~|~...) = " + val;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
        }
        for (View crtV : this.getAssociatedViews()) {
            crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.TOOLTIP_INFOS, this, msg, null));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void initProbaDistributions() {
        block30: {
            lc = Cell.leftGridRefConverter;
            rc = Cell.rightGridRefConverter;
            val_norm = 0.01;
            params = null;
            distParams = new Hashtable<String, String>();
            vals = new String[3];
            try {
                vals[0] = this.getParameter("val_norm");
            }
            catch (NullPointerException e) {
                vals[0] = "0.01";
            }
            distParams.put("val_norm", vals[0]);
            try {
                vals[0] = this.getParameter("Q1b_sigma");
            }
            catch (NullPointerException e) {
                vals[0] = "0.02";
            }
            try {
                vals[1] = this.getParameter("Q1b_max");
            }
            catch (NullPointerException e) {
                vals[1] = "0.75";
            }
            distParams.put("Q1b_fusion", String.valueOf(vals[0]) + "|" + vals[1]);
            try {
                vals[0] = this.getParameter("Q2b_sigma");
            }
            catch (NullPointerException e) {
                vals[0] = "0.25";
            }
            try {
                vals[1] = this.getParameter("Q2b_offset");
            }
            catch (NullPointerException e) {
                vals[1] = "0.01";
            }
            distParams.put("Q2b_fusion", String.valueOf(vals[0]) + "|" + vals[1]);
            try {
                vals[0] = this.getParameter("Q2c_p0");
            }
            catch (NullPointerException e) {
                vals[0] = "2.0";
            }
            try {
                vals[1] = this.getParameter("Q2c_p1");
            }
            catch (NullPointerException e) {
                vals[1] = "1.0";
            }
            try {
                vals[2] = this.getParameter("Q2c_p2");
            }
            catch (NullPointerException e) {
                vals[2] = "1.0";
            }
            distParams.put("Q2c_fusion", String.valueOf(vals[0]) + "|" + vals[1] + "|" + vals[2]);
            try {
                vals[0] = this.getParameter("Q1a_obs_p00");
            }
            catch (NullPointerException e) {
                vals[0] = "0.9";
            }
            try {
                vals[1] = this.getParameter("Q1a_obs_p11");
            }
            catch (NullPointerException e) {
                vals[1] = "0.9";
            }
            distParams.put("Q1a_obs", String.valueOf(vals[0]) + "|" + vals[1]);
            try {
                vals[0] = this.getParameter("Q1a_dyn_p00");
            }
            catch (NullPointerException e) {
                vals[0] = "0.95";
            }
            try {
                vals[1] = this.getParameter("Q1a_dyn_p11");
            }
            catch (NullPointerException e) {
                vals[1] = "0.9";
            }
            distParams.put("Q1a_dyn", String.valueOf(vals[0]) + "|" + vals[1]);
            try {
                vals[0] = this.getParameter("prior_vel");
            }
            catch (NullPointerException e) {
                vals[0] = "prior_vel.txt";
            }
            distParams.put("prior_vel", vals[0]);
            gpd0 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
            params = new Hashtable<String, String>();
            params.put("searchNames", "Occ^{t-1}_{(x', y')}");
            params.put("knownNames", "Obs^{0:T-1}#Mvt^{0:T-1}");
            params.put("paramNames", "@occ_{(x', y')}^{t-1}:0#@(x', y'):0#@(x', y'):1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            gpd0.init(params);
            gpd1 = new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Occ^t_{(x, y)}");
            params.put("knownNames", "Obs^{0:T}#Mvt^{0:T}");
            params.put("paramNames", "@occ_{(x, y)}^t:0#@(x, y):0#@(x, y):1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            gpd1.init(params);
            gpd2 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_1^{t-1}");
            params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
            params.put("paramNames", "@Tgt_1^{t-1}:0#@Tgt_1^{t-1}:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd2.init(params);
            gpd3 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_1^t");
            params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
            params.put("paramNames", "@Tgt_1^t:0#@Tgt_1^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd3.init(params);
            gpd4 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
            params = new Hashtable<K, V>();
            params.put("knownNames", "Tgt_1^t");
            params.put("searchNames", "Occ_{(x, y)}^t");
            params.put("functionType", "TargetFusionFunction1D");
            params.put("functionParameters", (String)distParams.get("Q1b_fusion"));
            params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_1^t");
            gpd4.init(params);
            gpd5 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_2^{t-1}");
            params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
            params.put("paramNames", "@Tgt_2^{t-1}:0#@Tgt_2^{t-1}:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd5.init(params);
            gpd6 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_2^t");
            params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
            params.put("paramNames", "@Tgt_2^t:0#@Tgt_2^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd6.init(params);
            gpd7 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
            params = new Hashtable<K, V>();
            params.put("knownNames", "Tgt_2^t");
            params.put("searchNames", "Occ_{(x, y)}^t");
            params.put("functionType", "TargetFusionFunction1D");
            params.put("functionParameters", (String)distParams.get("Q1b_fusion"));
            params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_2^t");
            gpd7.init(params);
            gpd8 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_3^{t-1}");
            params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
            params.put("paramNames", "@Tgt_3^{t-1}:0#@Tgt_3^{t-1}:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd8.init(params);
            gpd9 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_3^t");
            params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
            params.put("paramNames", "@Tgt_3^t:0#@Tgt_3^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd9.init(params);
            gpd10 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
            params = new Hashtable<K, V>();
            params.put("knownNames", "Tgt_3^t");
            params.put("searchNames", "Occ_{(x, y)}^t");
            params.put("functionType", "TargetFusionFunction1D");
            params.put("functionParameters", (String)distParams.get("Q1b_fusion"));
            params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_3^t");
            gpd10.init(params);
            gpd11 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_4^{t-1}");
            params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
            params.put("paramNames", "@Tgt_4^{t-1}:0#@Tgt_4^{t-1}:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd11.init(params);
            gpd12 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_4^t");
            params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
            params.put("paramNames", "@Tgt_4^t:0#@Tgt_4^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd12.init(params);
            gpd13 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
            params = new Hashtable<K, V>();
            params.put("knownNames", "Tgt_4^t");
            params.put("searchNames", "Occ_{(x, y)}^t");
            params.put("functionType", "TargetFusionFunction1D");
            params.put("functionParameters", (String)distParams.get("Q1b_fusion"));
            params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_4^t");
            gpd13.init(params);
            gpd14 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_5^{t-1}");
            params.put("knownNames", "Obs^{0:t-1}#Mvt^{0:t-1}");
            params.put("paramNames", "@Tgt_5^{t-1}:0#@Tgt_5^{t-1}:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd14.init(params);
            gpd15 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Tgt_5^t");
            params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
            params.put("paramNames", "@Tgt_5^t:0#@Tgt_5^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd15.init(params);
            gpd16 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
            params = new Hashtable<K, V>();
            params.put("knownNames", "Tgt_5^t");
            params.put("searchNames", "Occ_{(x, y)}^t");
            params.put("functionType", "TargetFusionFunction1D");
            params.put("functionParameters", (String)distParams.get("Q1b_fusion"));
            params.put("functionVariableNames", "@occ_{(x, y)}^t#@(x, y)#@Tgt_5^t");
            gpd16.init(params);
            gpd17 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Mot-a^t");
            params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
            params.put("paramNames", "@Mot-a^t:0#@Mot-a^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd17.init(params);
            gpd18 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Mot-b^t");
            params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
            params.put("paramNames", "@Mot-b^t:0#@Mot-b^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd18.init(params);
            gpd19 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
            params = new Hashtable<K, V>();
            params.put("knownNames", "Tgt_i^t");
            params.put("searchNames", "Mot-b^t");
            params.put("functionType", "GaussianGridFunction1D");
            params.put("functionParameters", (String)distParams.get("Q2b_fusion"));
            params.put("functionVariableNames", "@Tgt_i^t#@Mot-b^t");
            gpd19.init(params);
            gpd20 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Mot-c^t");
            params.put("knownNames", "Obs^{0:t}#Mvt^{0:t}");
            params.put("paramNames", "@Mot-c^t:0#@Mot-c^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd20.init(params);
            gpd21 = new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "Mot-c^t");
            params.put("knownNames", "i^t");
            params.put("paramNames", "@Mot-c^t:0#@Mot-c^t:1");
            params.put("initType", "priorInit");
            params.put("priorType", "uniform");
            params.put("priorUniformVal", (String)distParams.get("val_norm"));
            params.put("probaGlobal", "true");
            gpd21.init(params);
            gpd22 = new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc);
            params = new Hashtable<K, V>();
            params.put("searchNames", "i_{(x, y)}^t");
            params.put("knownNames", "Mot-c^t");
            params.put("functionType", "BetaDistributionFunction1D");
            params.put("functionParameters", (String)distParams.get("Q2c_fusion"));
            params.put("functionVariableNames", "@(x, y)#@Mot-c^t#@i_{(x, y)}^t");
            gpd22.init(params);
            fpd0 = new FunctionProbabilisticDistribution();
            params = new Hashtable<K, V>();
            params.put("knownNames", "Occ_{(x, y)}^t");
            params.put("searchNames", "Obs_{(x, y)}^t");
            params.put("functionType", "Matrix2x2Function1D");
            params.put("functionParameters", (String)distParams.get("Q1a_obs"));
            params.put("functionVariableNames", "obs_{(x, y)}^t#occ_{(x, y)}^t");
            fpd0.init(params);
            fpd1 = new FunctionProbabilisticDistribution();
            params = new Hashtable<K, V>();
            params.put("knownNames", "Occ_{Ant}^{t-1}#Mvt^t");
            params.put("searchNames", "Occ_{(x, y)}^t");
            params.put("functionType", "AffectLeakyAntProbaFunction1D");
            params.put("functionParameters", (String)distParams.get("Q1a_dyn"));
            params.put("functionVariableNames", "occ_{(x, y)}^t#(x, y)#occ_{ant}^{t-1}");
            fpd1.init(params);
            fpd2 = new FunctionProbabilisticDistribution();
            params = new Hashtable<K, V>();
            params.put("knownNames", "Obs^{0:t}");
            params.put("searchNames", "Mot-a^t");
            params.put("functionType", "GridHistogram1D");
            params.put("functionParameters", this.loadConstantModelParams((String)distParams.get("prior_vel")));
            params.put("functionVariableNames", "Mot-a^t");
            fpd2.init(params);
            this.getGridProbaDists().add(gpd0);
            this.getGridProbaDists().add(gpd1);
            this.getGridProbaDists().add(gpd2);
            this.getGridProbaDists().add(gpd3);
            this.getGridProbaDists().add(gpd4);
            this.getGridProbaDists().add(gpd5);
            this.getGridProbaDists().add(gpd6);
            this.getGridProbaDists().add(gpd7);
            this.getGridProbaDists().add(gpd8);
            this.getGridProbaDists().add(gpd9);
            this.getGridProbaDists().add(gpd10);
            this.getGridProbaDists().add(gpd11);
            this.getGridProbaDists().add(gpd12);
            this.getGridProbaDists().add(gpd13);
            this.getGridProbaDists().add(gpd14);
            this.getGridProbaDists().add(gpd15);
            this.getGridProbaDists().add(gpd16);
            this.getGridProbaDists().add(gpd17);
            this.getGridProbaDists().add(gpd18);
            this.getGridProbaDists().add(gpd19);
            this.getGridProbaDists().add(gpd20);
            this.getGridProbaDists().add(gpd21);
            this.getGridProbaDists().add(gpd22);
            this.getOthersProbaDists().add(fpd0);
            this.getOthersProbaDists().add(fpd1);
            this.getOthersProbaDists().add(fpd2);
            try {
                this.Q2a_computeInference();
            }
            catch (ShowableException se) {
                msg = se.getMessage();
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, msg, null));
                continue;
lbl545:
                // 1 sources

                break block30;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "initProbaDist");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String loadConstantModelParams(String filename) {
        block8: {
            gridw = Cell.rightGridRefConverter.getPixelWidth();
            gridh = Cell.rightGridRefConverter.getPixelHeight();
            t = new double[gridw][gridh];
            try {
                reader = new BufferedReader(new FileReader(filename));
                j = 0;
                while (j < gridh) {
                    ligne = reader.readLine();
                    tokens = ligne.split("\t");
                    i = 0;
                    while (i < gridw) {
                        t[i][j] = Double.parseDouble(tokens[i]);
                        ++i;
                    }
                    ++j;
                }
                break block8;
            }
            catch (Exception e) {
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, "Error$Unable to load constant parameters.", null));
                continue;
            }
lbl23:
            // 1 sources

            e.printStackTrace();
        }
        s = "" + t[0][0];
        j = 1;
        while (j < gridh) {
            s = String.valueOf(s) + "," + t[0][j];
            ++j;
        }
        i = 1;
        while (i < gridw) {
            s = String.valueOf(s) + "|" + t[i][0];
            j = 1;
            while (j < gridh) {
                s = String.valueOf(s) + "," + t[i][j];
                ++j;
            }
            ++i;
        }
        return s;
    }

    private String getConstantModelParams() {
        int j;
        int gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.rightGridRefConverter.getPixelHeight();
        double[][] t = new double[gridw][gridh];
        double mh = gridh / 2;
        double mw = gridw - 1;
        int i = 0;
        while (i < gridw) {
            int j2 = 0;
            while (j2 < gridh) {
                t[i][j2] = 1.0 / (10.0 + ((double)i - mw) * ((double)i - mw) + ((double)j2 - mh) * ((double)j2 - mh));
                ++j2;
            }
            ++i;
        }
        double Z = 0.0;
        int i2 = 0;
        while (i2 < gridw) {
            j = 0;
            while (j < gridh) {
                Z += t[i2][j];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < gridw) {
            j = 0;
            while (j < gridh) {
                t[i2][j] = t[i2][j] / (2.0 * Z);
                ++j;
            }
            ++i2;
        }
        String s = "" + t[0][0];
        j = 1;
        while (j < gridh) {
            s = String.valueOf(s) + "," + t[0][j];
            ++j;
        }
        int i3 = 1;
        while (i3 < gridw) {
            s = String.valueOf(s) + "|" + t[i3][0];
            int j3 = 1;
            while (j3 < gridh) {
                s = String.valueOf(s) + "," + t[i3][j3];
                ++j3;
            }
            ++i3;
        }
        return s;
    }

    @Override
    protected void initRandomVariables() {
        int gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.rightGridRefConverter.getPixelHeight();
        int[] l_zero_p = Cell.getZeroGridPos(false);
        int[] r_zero_p = Cell.getZeroGridPos(true);
        Object domain = RandomVariable.getDomainForGridPos(gridw, gridh);
        this.setVariable(new LeftRight_Variable(l_zero_p, r_zero_p, "Mvt^t", (int[][])domain));
        this.setVariable(new RandomVariable("(x, y)", (int[][])domain));
        this.setVariable(new RandomVariable("(x', y')", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_i^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_1^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_1^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_2^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_2^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_3^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_3^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_4^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_4^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_5^t", (int[][])domain));
        this.setVariable(new RandomVariable("Tgt_5^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("Mot-a^t", (int[][])domain));
        this.setVariable(new RandomVariable("Mot-b^t", (int[][])domain));
        this.setVariable(new RandomVariable("Mot-c^t", (int[][])domain));
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        byte[] bdomain = byArray;
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Obs^t", bdomain));
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        domain = nArrayArray;
        this.setVariable(new RandomVariable("obs_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("occ_{(x, y)}^t", (int[][])domain));
        this.setVariable(new RandomVariable("occ_{(x', y')}^{t-1}", (int[][])domain));
        this.setVariable(new RandomVariable("occ_{ant}^{t-1}", (int[][])domain));
        bdomain = new byte[Antecedent.getMaxAntecedentsNb() + 1];
        int i = 0;
        while (i < bdomain.length) {
            bdomain[i] = i;
            i = (byte)(i + 1);
        }
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Ant", bdomain));
        this.setVariable(new LeftRight_Variable(gridw, gridh, "CAnt", bdomain));
        double[] rdomain = new double[]{0.0, 1.0};
        this.setVariable(new RandomVariable(0.0, "i_{(x, y)}^t", rdomain));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void subInfer() {
        block5: {
            try {
                this.updateVariables();
                this.Q1a_computeInference();
                this.Q1b_computeInference();
                this.Q2b_computeInference();
                this.Q2c_computeInference();
                this.notifyUpdate();
            }
            catch (ShowableException se) {
                msg = se.getMessage();
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, msg, null));
                continue;
lbl15:
                // 1 sources

                break block5;
            }
            catch (InterruptedException e) {
                Utilities.exceptionCaughtMessage(e, this, "Interrupt somewhere in subInfer");
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "subInfer");
            }
        }
    }

    @Override
    protected void evaluateModels() {
        if (this.isFreeEyes() && !this.isModelEM()) {
            Cell sacc = Cell.getCell(this.getSaccades().get((int)0).position);
            double[] probas = new double[]{0.0, 0.0, 0.0};
            int i = sacc.x;
            int j = sacc.y;
            byte s = sacc.side;
            try {
                this.getVariable("Mot-a^t").setList(new int[]{i, j, s});
                this.getVariable("Mot-b^t").setList(new int[]{i, j, s});
                this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                if (s == 0) {
                    probas[0] = this.getGridProbaDists().get(17).getLeftPart().getValue(this.getVariables());
                    probas[1] = this.getGridProbaDists().get(18).getLeftPart().getValue(this.getVariables());
                    probas[2] = this.getGridProbaDists().get(20).getLeftPart().getValue(this.getVariables());
                } else {
                    probas[0] = this.getGridProbaDists().get(17).getRightPart().getValue(this.getVariables());
                    probas[1] = this.getGridProbaDists().get(18).getRightPart().getValue(this.getVariables());
                    probas[2] = this.getGridProbaDists().get(20).getRightPart().getValue(this.getVariables());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String res = probas[2] >= probas[1] ? (probas[2] >= probas[0] ? " \t=> Mot_c." : " \t=> Mot_a.") : (probas[1] >= probas[0] ? " \t=> Mot_b." : " \t=> Mot_a.");
            System.out.println("Probas: \tmot_a=" + probas[0] + " \tmot_b=" + probas[1] + " \tmot_c=" + probas[2] + res);
        }
    }

    protected void updateVariables1() throws ShowableException {
        Cell sacc_cell = this.updateSaccade();
        Position saccade = sacc_cell.centerPos;
        double saccade_thres2 = 0.25;
        boolean suppression = false;
        if (this.lastSaccadeCell == null || !this.lastSaccadeCell.equals(sacc_cell)) {
            Position sacc_pos = sacc_cell.centerPos;
            Antecedent.setAllAntecedentsFromATranslation(sacc_pos);
            this.lastSaccadeCell = sacc_cell;
            System.out.println("V25_BossEngine::updateVariables -new saccade");
        }
        this.updateObservation(suppression);
        this.updateAntecedent(true, "CAnt");
        this.updateAntecedent(false, "Ant");
        this.notifyUpdate();
    }

    protected void updateVariables0() throws ShowableException {
        boolean suppression = false;
        this.updateObservation(suppression);
        this.updateAntecedent(true, "CAnt");
        this.updateAntecedent(false, "Ant");
        this.shiftObjTgt();
        this.notifyUpdate();
    }

    @Override
    protected void updateVariables() throws ShowableException {
        Cell sacc_cell = this.updateSaccade();
        Position saccade = sacc_cell.centerPos;
        double saccade_thres2 = 0.25;
        boolean suppression = false;
        if (this.lastSaccadeCell == null || !this.lastSaccadeCell.equals(sacc_cell)) {
            Position sacc_pos = sacc_cell.centerPos;
            Antecedent.setAllAntecedentsFromATranslation(sacc_pos);
            this.lastSaccadeCell = sacc_cell;
        }
        this.updateObservation(suppression);
        this.updateAntecedent(true, "CAnt");
        this.updateAntecedent(false, "Ant");
        this.shiftObjTgt();
        this.notifyUpdate();
    }

    private void shiftObjTgt() {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        ProbabilisticDistribution[] occ_t = new ProbabilisticDistribution[]{this.getGridProbaDists().get(1).getLeftPart(), this.getGridProbaDists().get(1).getRightPart()};
        ProbabilisticDistribution[] occ_t_1 = new ProbabilisticDistribution[]{this.getGridProbaDists().get(0).getLeftPart(), this.getGridProbaDists().get(0).getRightPart()};
        ProbabilisticDistribution[][] tgt_t = new ProbabilisticDistribution[][]{{this.getGridProbaDists().get(3).getLeftPart(), this.getGridProbaDists().get(3).getRightPart()}, {this.getGridProbaDists().get(6).getLeftPart(), this.getGridProbaDists().get(6).getRightPart()}, {this.getGridProbaDists().get(9).getLeftPart(), this.getGridProbaDists().get(9).getRightPart()}, {this.getGridProbaDists().get(12).getLeftPart(), this.getGridProbaDists().get(12).getRightPart()}, {this.getGridProbaDists().get(15).getLeftPart(), this.getGridProbaDists().get(15).getRightPart()}};
        ProbabilisticDistribution[][] tgt_t_1 = new ProbabilisticDistribution[][]{{this.getGridProbaDists().get(2).getLeftPart(), this.getGridProbaDists().get(2).getRightPart()}, {this.getGridProbaDists().get(5).getLeftPart(), this.getGridProbaDists().get(5).getRightPart()}, {this.getGridProbaDists().get(8).getLeftPart(), this.getGridProbaDists().get(8).getRightPart()}, {this.getGridProbaDists().get(11).getLeftPart(), this.getGridProbaDists().get(11).getRightPart()}, {this.getGridProbaDists().get(14).getLeftPart(), this.getGridProbaDists().get(14).getRightPart()}};
        try {
            int s = 0;
            while (s < 2) {
                int i = 0;
                while (i < gridw) {
                    int j = 0;
                    while (j < gridh) {
                        double proba;
                        this.getVariables().get("(x, y)").setList(new int[]{i, j, s});
                        this.getVariables().get("(x', y')").setList(new int[]{i, j, s});
                        int k = 1;
                        while (k <= 5) {
                            this.getVariables().get("Tgt_" + k + "^t").setList(new int[]{i, j, s});
                            this.getVariables().get("Tgt_" + k + "^{t-1}").setList(new int[]{i, j, s});
                            proba = tgt_t[k - 1][s].getValue(this.getVariables());
                            tgt_t_1[k - 1][s].setNewValue(this.getVariables(), proba);
                            ++k;
                        }
                        int v = 0;
                        while (v < 2) {
                            this.getVariables().get("occ_{(x, y)}^t").setList(new int[]{v});
                            this.getVariables().get("occ_{(x', y')}^{t-1}").setList(new int[]{v++});
                            proba = occ_t[s].getValue(this.getVariables());
                            occ_t_1[s].setNewValue(this.getVariables(), proba);
                        }
                        ++j;
                    }
                    ++i;
                }
                occ_t_1[s].updateValues();
                int k = 0;
                while (k < 5) {
                    tgt_t_1[k][s].updateValues();
                    ++k;
                }
                ++s;
            }
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "shiftObjTgt");
        }
    }

    private final void Q2c_computeInference() throws Exception {
        int j;
        int i;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double[][][] prob_dist = new double[2][gridw][gridh];
        ProbabilisticDistribution[] p_occ = new ProbabilisticDistribution[]{this.getGridProbaDists().get(1).getLeftPart(), this.getGridProbaDists().get(1).getRightPart()};
        ProbabilisticDistribution[] p_mot_c = new ProbabilisticDistribution[]{this.getGridProbaDists().get(20).getLeftPart(), this.getGridProbaDists().get(20).getRightPart()};
        ProbabilisticDistribution[] p_mot_b = new ProbabilisticDistribution[]{this.getGridProbaDists().get(18).getLeftPart(), this.getGridProbaDists().get(18).getRightPart()};
        ProbabilisticDistribution[] p_mot_i = new ProbabilisticDistribution[]{this.getGridProbaDists().get(21).getLeftPart(), this.getGridProbaDists().get(21).getRightPart()};
        ProbabilisticDistribution[] p_i_mot = new ProbabilisticDistribution[]{this.getGridProbaDists().get(22).getLeftPart(), this.getGridProbaDists().get(22).getRightPart()};
        double tmp_proba = 0.0;
        double tmp_sum = 0.0;
        this.getVariable("occ_{(x, y)}^t").setList(new int[]{1});
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("Mot-b^t").setList(new int[]{i, j, s});
                    this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getVariable("(x, y)").setList(new int[]{i, j, s});
                        this.getVariable("i_{(x, y)}^t").setRealVal(p_occ[s].getValue(this.getVariables()));
                        tmp_proba = p_i_mot[s].getValue(this.getVariables());
                    } else {
                        tmp_proba = 0.0;
                    }
                    p_mot_i[s].setNewValue(this.getVariables(), tmp_proba);
                    double d = tmp_proba *= p_mot_b[s].getValue(this.getVariables());
                    prob_dist[s][i][j] = d;
                    tmp_sum += d;
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("Mot-c^t").setList(new int[]{i, j, s});
                    p_mot_c[s].setNewValue(this.getVariables(), prob_dist[s][i][j] / tmp_sum);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        p_mot_c[0].updateValues();
        p_mot_c[1].updateValues();
        p_mot_i[0].updateValues();
        p_mot_i[1].updateValues();
        this.notifyUpdate();
    }

    private final void Q2b_computeInference() throws Exception {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double[][][][] prob_dists = new double[6][2][gridw][gridh];
        ProbabilisticDistribution[] p_mot = new ProbabilisticDistribution[]{this.getGridProbaDists().get(18).getLeftPart(), this.getGridProbaDists().get(18).getRightPart()};
        ProbabilisticDistribution[] myDists_left = new ProbabilisticDistribution[]{this.getGridProbaDists().get(17).getLeftPart(), this.getGridProbaDists().get(19).getLeftPart()};
        ProbabilisticDistribution[] myDists_right = new ProbabilisticDistribution[]{this.getGridProbaDists().get(17).getRightPart(), this.getGridProbaDists().get(19).getRightPart()};
        ProbabilisticDistribution[][] p_tgt = new ProbabilisticDistribution[][]{{this.getGridProbaDists().get(3).getLeftPart(), this.getGridProbaDists().get(3).getRightPart()}, {this.getGridProbaDists().get(6).getLeftPart(), this.getGridProbaDists().get(6).getRightPart()}, {this.getGridProbaDists().get(9).getLeftPart(), this.getGridProbaDists().get(9).getRightPart()}, {this.getGridProbaDists().get(12).getLeftPart(), this.getGridProbaDists().get(12).getRightPart()}, {this.getGridProbaDists().get(15).getLeftPart(), this.getGridProbaDists().get(15).getRightPart()}};
        ProbabilisticDistribution[] p_tgt_left = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3).getLeftPart(), this.getGridProbaDists().get(6).getLeftPart(), this.getGridProbaDists().get(9).getLeftPart(), this.getGridProbaDists().get(12).getLeftPart(), this.getGridProbaDists().get(15).getLeftPart()};
        ProbabilisticDistribution[] p_tgt_right = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3).getRightPart(), this.getGridProbaDists().get(6).getRightPart(), this.getGridProbaDists().get(9).getRightPart(), this.getGridProbaDists().get(12).getRightPart(), this.getGridProbaDists().get(15).getRightPart()};
        double[][] subSums = new double[][]{{0.0}, {0.0}, {0.0}, {0.0}};
        Thread[] mesFils = new Thread[4];
        mesFils[0] = new Thread(new Q2b_subCI(0, true, myDists_left, p_tgt, subSums[0], prob_dists, this.newVariableContext()));
        mesFils[0].start();
        mesFils[1] = new Thread(new Q2b_subCI(1, true, myDists_right, p_tgt, subSums[1], prob_dists, this.newVariableContext()));
        mesFils[1].start();
        mesFils[2] = new Thread(new Q2b_subCI(0, false, myDists_left, p_tgt, subSums[2], prob_dists, this.newVariableContext()));
        mesFils[2].start();
        mesFils[3] = new Thread(new Q2b_subCI(1, false, myDists_right, p_tgt, subSums[3], prob_dists, this.newVariableContext()));
        mesFils[3].start();
        mesFils[0].join();
        mesFils[1].join();
        mesFils[2].join();
        mesFils[3].join();
        double tmp_sum = subSums[0][0] + subSums[1][0] + subSums[2][0] + subSums[3][0];
        if (tmp_sum > 0.0) {
            int s_m = 0;
            while (s_m < 2) {
                int i_m = 0;
                while (i_m < gridw) {
                    int j_m = 0;
                    while (j_m < gridh) {
                        this.getVariable("Mot-b^t").setList(new int[]{i_m, j_m, s_m});
                        p_mot[s_m].setNewValue(this.getVariables(), prob_dists[5][s_m][i_m][j_m] / tmp_sum);
                        ++j_m;
                    }
                    ++i_m;
                }
                ++s_m;
            }
        }
        p_mot[0].updateValues();
        p_mot[1].updateValues();
        this.notifyUpdate();
    }

    private final void Q2a_computeInference() throws Exception {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double p = 0.0;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        try {
                            this.getVariable("Mot-a^t").setList(new int[]{i, j, s});
                        }
                        catch (Exception e) {
                            Utilities.exceptionCaughtMessage(e, this, "Q2a_computeInference");
                        }
                        p = this.getOthersProbaDists().get(2).getValue(this.getVariables());
                    } else {
                        p = 0.0;
                    }
                    this.getVariable("Mot-a^t").setList(new int[]{i, j, s});
                    if (s == 0) {
                        this.getGridProbaDists().get(17).getLeftPart().setNewValue(this.getVariables(), p);
                    } else {
                        this.getGridProbaDists().get(17).getRightPart().setNewValue(this.getVariables(), p);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(17).getLeftPart().updateValues();
        this.getGridProbaDists().get(17).getRightPart().updateValues();
        this.notifyUpdate();
    }

    private final void Q1b_computeInference() throws InterruptedException {
        Thread[] mesFils = new Thread[5];
        int tgt_num = 1;
        while (tgt_num <= 5) {
            ProbabilisticDistribution[][] myDists = new ProbabilisticDistribution[][]{{this.getGridProbaDists().get(3 * tgt_num).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num).getRightPart()}, {this.getGridProbaDists().get(3 * tgt_num - 1).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num - 1).getRightPart()}, {this.getGridProbaDists().get(1).getLeftPart(), this.getGridProbaDists().get(1).getRightPart()}, {this.getGridProbaDists().get(3 * tgt_num + 1).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num + 1).getRightPart()}};
            mesFils[tgt_num - 1] = new Thread(new Q1b_subCI(tgt_num, myDists, this.newVariableContext()));
            mesFils[tgt_num - 1].start();
            ++tgt_num;
        }
        tgt_num = 1;
        while (tgt_num <= 5) {
            mesFils[tgt_num - 1].join();
            ++tgt_num;
        }
    }

    private final void Q1b_computeInference(int tgt_num) throws Exception {
        int j;
        int i;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double proba_total = 0.0;
        double proba = 0.0;
        double t_proba = 0.0;
        ProbabilisticDistribution[] tgt_t = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3 * tgt_num).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num).getRightPart()};
        ProbabilisticDistribution[] tgt_t_1 = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3 * tgt_num - 1).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num - 1).getRightPart()};
        ProbabilisticDistribution[] occ_t = new ProbabilisticDistribution[]{this.getGridProbaDists().get(1).getLeftPart(), this.getGridProbaDists().get(1).getRightPart()};
        ProbabilisticDistribution[] p_occ_tgt = new ProbabilisticDistribution[]{this.getGridProbaDists().get(3 * tgt_num + 1).getLeftPart(), this.getGridProbaDists().get(3 * tgt_num + 1).getRightPart()};
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    proba = 0.0;
                    this.getVariables().get("Tgt_" + tgt_num + "^t").setList(new int[]{i, j, s});
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        Cell[] ants = Antecedent.getCells(i, j, s);
                        int[] nums = Antecedent.gridAntsNumerosity[s][i][j];
                        int ii = 0;
                        while (ii < ants.length) {
                            this.getVariables().get("Tgt_" + tgt_num + "^{t-1}").setList(new int[]{ants[ii].x, ants[ii].y, ants[ii].side});
                            proba += tgt_t_1[ants[ii].side].getValue(this.getVariables()) * (double)nums[ii];
                            ++ii;
                        }
                        int t = 0;
                        while (t < 2) {
                            int k = 0;
                            while (k < gridw) {
                                int l = 0;
                                while (l < gridh) {
                                    this.getVariables().get("(x, y)").setList(new int[]{k, l, t});
                                    t_proba = 0.0;
                                    int v = 0;
                                    while (v <= 1) {
                                        this.getVariables().get("occ_{(x, y)}^t").setList(new int[]{v++});
                                        t_proba += occ_t[t].getValue(this.getVariables()) * p_occ_tgt[s].getValue(this.getVariables());
                                    }
                                    proba *= t_proba;
                                    ++l;
                                }
                                ++k;
                            }
                            ++t;
                        }
                    }
                    proba_total += proba;
                    tgt_t[s].setNewValue(this.getVariables(), proba);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        tgt_t[0].updateValues();
        tgt_t[1].updateValues();
        if (proba_total == 0.0) {
            proba_total = 1.0;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariables().get("Tgt_" + tgt_num + "^t").setList(new int[]{i, j++, s});
                    tgt_t[s].setNewValue(this.getVariables(), tgt_t[s].getValue(this.getVariables()) / proba_total);
                }
                ++i;
            }
            ++s;
        }
        tgt_t[0].updateValues();
        tgt_t[1].updateValues();
    }

    protected Hashtable<String, RandomVariable> newVariableContext() {
        Hashtable<String, RandomVariable> newVC = new Hashtable<String, RandomVariable>();
        for (RandomVariable rv : this.getVariables().values()) {
            newVC.put(rv.getName(), new RandomVariable(rv));
        }
        return newVC;
    }

    private final void Q1a_computeInference() throws InterruptedException {
        Thread[] mesFils = new Thread[2];
        GridProbabilisticDistribution myRes = this.getGridProbaDists().get(1).getLeftPart();
        mesFils[0] = new Thread(new Q1a_subCI(0, myRes, this.getGridProbaDists().get(0), this.getOthersProbaDists().get(0), this.getOthersProbaDists().get(1), this.newVariableContext()));
        mesFils[0].start();
        myRes = this.getGridProbaDists().get(1).getRightPart();
        mesFils[1] = new Thread(new Q1a_subCI(1, myRes, this.getGridProbaDists().get(0), this.getOthersProbaDists().get(0), this.getOthersProbaDists().get(1), this.newVariableContext()));
        mesFils[1].start();
        mesFils[0].join();
        mesFils[1].join();
    }

    protected static final double Q1_getSum(int x, int y, int side, String varname, Hashtable<String, RandomVariable> myContextVariables, LeftRight_GridProbabilisticDistribution dist_t_1, ProbabilisticDistribution dist_dyn) throws Exception {
        Cell[] ant_cells = Antecedent.getCells(x, y, side);
        int[] val_ants = new int[ant_cells.length];
        int max_powa = (int)StrictMath.rint(StrictMath.pow(2.0, ant_cells.length));
        int[] two_p = new int[ant_cells.length];
        int k = 0;
        while (k < two_p.length) {
            two_p[k] = (int)StrictMath.rint(StrictMath.pow(2.0, k));
            ++k;
        }
        double proba_sum = 0.0;
        if (val_ants.length != 0) {
            int[][] domain = new int[val_ants.length][2];
            int i = 0;
            while (i < domain.length) {
                int[] nArray = new int[2];
                nArray[1] = 1;
                domain[i] = nArray;
                ++i;
            }
            myContextVariables.put(String.valueOf(varname) + "_{ant}^{t-1}", new RandomVariable(String.valueOf(varname) + "_{ant}^{t-1}", domain));
            int[] cpts = new int[ant_cells.length];
            int[] values = new int[ant_cells.length];
            double proba1 = 0.0;
            double proba2 = 0.0;
            int k2 = 0;
            while (k2 < max_powa) {
                int i2 = 0;
                while (i2 < ant_cells.length) {
                    val_ants[i2] = values[i2];
                    int n = i2;
                    cpts[n] = cpts[n] + 1;
                    if (cpts[i2] % two_p[i2] == 0) {
                        values[i2] = (values[i2] + 1) % 2;
                    }
                    ++i2;
                }
                myContextVariables.get(String.valueOf(varname) + "_{ant}^{t-1}").setList(val_ants);
                proba1 = dist_dyn.getValue(myContextVariables);
                proba2 = V251_BossEngine.Q1_getSum_getOldQ1(ant_cells, val_ants, varname, myContextVariables, dist_t_1);
                proba_sum += proba1 * proba2;
                ++k2;
            }
        } else {
            proba_sum = 0.99999;
            if (myContextVariables.get("occ_{(x, y)}^t").getListVar(0) == 1) {
                proba_sum = 1.0 - proba_sum;
            }
        }
        return proba_sum;
    }

    private static final double Q1_getSum_getOldQ1(Cell[] antCells, int[] antVals, String varname, Hashtable<String, RandomVariable> myContextVariables, LeftRight_GridProbabilisticDistribution dist) throws Exception {
        double retour = 1.0;
        double proba = 0.0;
        int[] ant_cell_pos = null;
        GridProbabilisticDistribution gpd = null;
        int i = 0;
        while (i < antCells.length) {
            ant_cell_pos = new int[]{antCells[i].x, antCells[i].y};
            myContextVariables.get("(x', y')").setList(ant_cell_pos);
            myContextVariables.get(String.valueOf(varname) + "_{(x', y')}^{t-1}").setList(new int[]{antVals[i]});
            gpd = antCells[i].isRight ? dist.getRightPart() : dist.getLeftPart();
            proba = gpd.getValue(myContextVariables);
            retour *= proba;
            ++i;
        }
        return retour;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Cell updateSaccade() throws ShowableException {
        if (this.getSaccades().size() < 1) {
            String msg = String.valueOf(this.getClass().getName()) + "::updateSaccade" + " -error";
            System.out.println(String.valueOf(msg) + " not enough saccades");
            msg = "Problem in the data update$Update of the saccades data is not possible :\nnot enough saccades !";
            throw new ShowableException(msg);
        }
        String var_name1 = "";
        String var_name2 = "";
        Cell sacc_cell = Cell.getCell(this.getSaccades().get((int)0).position);
        if (sacc_cell == null) {
            System.out.println(String.valueOf(this.getClass().getName()) + "::updateSaccade" + " infos saccade pos outside the grid (" + sacc_cell.x + "," + sacc_cell.y + "), Sacc^t not updated");
            return null;
        }
        if (sacc_cell.isRight) {
            var_name1 = "R-Mvt^t";
            var_name2 = "L-Mvt^t";
        } else {
            var_name1 = "L-Mvt^t";
            var_name2 = "R-Mvt^t";
        }
        try {
            this.getVariable(var_name1).setListVar(0, sacc_cell.x);
            this.getVariable(var_name1).setListVar(1, sacc_cell.y);
            this.getVariable(var_name2).setToDefaultValues();
            return sacc_cell;
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "updateSaccade");
            return null;
        }
    }

    private final void updateObservation(boolean suppression) throws ShowableException {
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_obs = new byte[l_gridw][gridh];
        byte[][] r_obs = new byte[r_gridw][gridh];
        if (!suppression) {
            for (Observation observation : this.getObservations()) {
                this.fillObservation(observation, l_obs, r_obs);
            }
            for (Target target : this.getTargets()) {
                this.fillObservation(target, l_obs, r_obs);
            }
        }
        try {
            this.getVariable("R-Obs^t").setTable(r_obs);
            this.getVariable("L-Obs^t").setTable(l_obs);
        }
        catch (Exception exception) {
            Utilities.exceptionCaughtMessage(exception, this, "updateObservation");
        }
    }

    private final void updateAntecedent(boolean colored, String varName) throws ShowableException {
        int val;
        int[] nums;
        Cell[] crt_ants;
        Cell crt_cell;
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_ant = new byte[l_gridw][gridh];
        byte[][] r_ant = new byte[r_gridw][gridh];
        if (this.getObservations() != null && this.getObservations().size() > 0) {
            for (Observation observation : this.getObservations()) {
                crt_cell = Cell.getCell(observation.position);
                if (crt_cell == null) continue;
                crt_ants = Antecedent.getCells(crt_cell);
                nums = Antecedent.getNumerosity(crt_cell);
                int i = 0;
                while (i < crt_ants.length) {
                    val = 10;
                    if (colored) {
                        val = (byte)nums[i];
                    }
                    if (crt_ants[i].isRight) {
                        r_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    } else {
                        l_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    }
                    ++i;
                }
                try {
                    this.getVariable("R-" + varName).setTable(r_ant);
                    this.getVariable("L-" + varName).setTable(l_ant);
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "updateAnt");
                }
            }
        }
        if (this.getTargets() != null && this.getTargets().size() > 0) {
            for (Observation observation : this.getTargets()) {
                crt_cell = Cell.getCell(observation.position);
                if (crt_cell == null) continue;
                crt_ants = Antecedent.getCells(crt_cell);
                nums = Antecedent.getNumerosity(crt_cell);
                int i = 0;
                while (i < crt_ants.length) {
                    val = 10;
                    if (colored) {
                        val = (byte)nums[i];
                    }
                    if (crt_ants[i].isRight) {
                        r_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    } else {
                        l_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    }
                    ++i;
                }
                try {
                    this.getVariable("R-" + varName).setTable(r_ant);
                    this.getVariable("L-" + varName).setTable(l_ant);
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "updateAnt");
                }
            }
        }
    }

    private final void fillObservation(Observation crtT, byte[][] l_obs, byte[][] r_obs) {
        double sq_radius = StrictMath.pow(crtT.size / 2.0, 2.0);
        double h_c = crtT.position.getX1();
        double v_c = crtT.position.getY1();
        GridReferenceConverter l_grc = Cell.leftGridRefConverter;
        GridReferenceConverter r_grc = Cell.rightGridRefConverter;
        int gridw = l_grc.getPixelWidth();
        int gridh = l_grc.getPixelHeight();
        int i = 0;
        while (i < gridw) {
            int j = 0;
            while (j < gridh) {
                Position l_pos = new Position(l_grc.xBasic(i), l_grc.yBasic(j), false);
                Position r_pos = new Position(r_grc.xBasic(i), r_grc.yBasic(j), false);
                if (Cell.gridCells[0][i][j].isInsideTheGrid && sq_radius >= StrictMath.pow(l_pos.getX1() - h_c, 2.0) + StrictMath.pow(l_pos.getY1() - v_c, 2.0)) {
                    l_obs[i][j] = 1;
                }
                if (Cell.gridCells[1][i][j].isInsideTheGrid && sq_radius >= StrictMath.pow(r_pos.getX1() - h_c, 2.0) + StrictMath.pow(r_pos.getY1() - v_c, 2.0)) {
                    r_obs[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        Cell t_cell = Cell.getCell(crtT.position);
        if (t_cell.isRight) {
            r_obs[t_cell.x][t_cell.y] = 1;
        } else {
            l_obs[t_cell.x][t_cell.y] = 1;
        }
    }

    @Override
    protected void flash() {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_tgt = new byte[gridw][gridh];
        byte[][] r_tgt = new byte[gridw][gridh];
        try {
            int j;
            int tgt_num = 1;
            for (Target t : this.getTargets()) {
                int i = 0;
                while (i < gridw) {
                    j = 0;
                    while (j < gridh) {
                        r_tgt[i][j] = 0;
                        l_tgt[i][j] = 0;
                        ++j;
                    }
                    ++i;
                }
                this.fillObservation(t, l_tgt, r_tgt);
                double Z = 0.0;
                int i2 = 0;
                while (i2 < gridw) {
                    int j2 = 0;
                    while (j2 < gridh) {
                        Z += (double)(l_tgt[i2][j2] + r_tgt[i2][j2]);
                        ++j2;
                    }
                    ++i2;
                }
                double K = 0.5;
                int i3 = 0;
                while (i3 < gridw) {
                    int j3 = 0;
                    while (j3 < gridh) {
                        int[] nArray = new int[3];
                        nArray[0] = i3;
                        nArray[1] = j3;
                        this.getVariable("Tgt_" + tgt_num + "^t").setList(nArray);
                        this.getGridProbaDists().get(3 * tgt_num).getLeftPart().setNewValue(this.getVariables(), (K / (double)(gridh * gridw) + (double)l_tgt[i3][j3]) / (Z + K));
                        this.getVariable("Tgt_" + tgt_num + "^t").setList(new int[]{i3, j3, 1});
                        this.getGridProbaDists().get(3 * tgt_num).getRightPart().setNewValue(this.getVariables(), (K / (double)(gridh * gridw) + (double)r_tgt[i3][j3]) / (Z + K));
                        ++j3;
                    }
                    ++i3;
                }
                this.getGridProbaDists().get(3 * tgt_num).getLeftPart().updateValues();
                this.getGridProbaDists().get(3 * tgt_num).getRightPart().updateValues();
                if (++tgt_num > 5) break;
            }
            if (tgt_num <= 5) {
                while (tgt_num <= 5) {
                    int i = 0;
                    while (i < gridw) {
                        int j4 = 0;
                        while (j4 < gridh) {
                            int[] nArray = new int[3];
                            nArray[0] = i;
                            nArray[1] = j4;
                            this.getVariable("Tgt_" + tgt_num + "^t").setList(nArray);
                            this.getGridProbaDists().get(3 * tgt_num).getLeftPart().setNewValue(this.getVariables(), 0.0);
                            this.getVariable("Tgt_" + tgt_num + "^t").setList(new int[]{i, j4++, 1});
                            this.getGridProbaDists().get(3 * tgt_num).getRightPart().setNewValue(this.getVariables(), 0.0);
                        }
                        ++i;
                    }
                    this.getGridProbaDists().get(3 * tgt_num).getLeftPart().updateValues();
                    this.getGridProbaDists().get(3 * tgt_num).getRightPart().updateValues();
                    ++tgt_num;
                }
            }
            this.updateObservation(false);
            byte[][] l_obj = this.getVariable("L-Obs^t").getTable();
            byte[][] r_obj = this.getVariable("R-Obs^t").getTable();
            int i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("occ_{(x, y)}^t").setListVar(0, 0);
                    int[] nArray = new int[3];
                    nArray[0] = i;
                    nArray[1] = j;
                    this.getVariable("(x, y)").setList(nArray);
                    this.getGridProbaDists().get(1).getLeftPart().setNewValue(this.getVariables(), 0.99999 - 0.99998 * (double)l_obj[i][j]);
                    this.getVariable("(x, y)").setList(new int[]{i, j, 1});
                    this.getGridProbaDists().get(1).getRightPart().setNewValue(this.getVariables(), 0.99999 - 0.99998 * (double)r_obj[i][j]);
                    this.getVariable("occ_{(x, y)}^t").setListVar(0, 1);
                    this.getGridProbaDists().get(1).getRightPart().setNewValue(this.getVariables(), 1.0E-5 + 0.99998 * (double)r_obj[i][j]);
                    int[] nArray2 = new int[3];
                    nArray2[0] = i;
                    nArray2[1] = j;
                    this.getVariable("(x, y)").setList(nArray2);
                    this.getGridProbaDists().get(1).getLeftPart().setNewValue(this.getVariables(), 1.0E-5 + 0.99998 * (double)l_obj[i][j]);
                    ++j;
                }
                ++i;
            }
            this.getGridProbaDists().get(1).getLeftPart().updateValues();
            this.getGridProbaDists().get(1).getRightPart().updateValues();
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "flash");
        }
        this.notifyUpdate();
    }

    @Override
    protected Position decideSaccade(int model) {
        int dist_index;
        switch (model) {
            case 0: {
                dist_index = 17;
                break;
            }
            case 1: {
                dist_index = 18;
                break;
            }
            default: {
                dist_index = 20;
            }
        }
        int[] coords = this.getGridProbaDists().get(dist_index).draw();
        return Cell.gridCells[coords[2]][coords[0]][coords[1]].centerPos;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected int[] solveTask() {
        ntargets = this.getTargets().size();
        obj_probas = new double[this.getObservations().size() + this.getTargets().size()];
        indices = new int[ntargets];
        index = 0;
        old_sacc_pos = this.lastSaccadeCell.centerPos;
        cur_sacc_pos = this.getSaccades().get((int)0).position;
        objects = new Vector<Position>(this.getTargets().size() + this.getObservations().size());
        k = 0;
        while (k < this.getTargets().size()) {
            pos = new Position(this.getTargets().get((int)k).position);
            objects.add(pos);
            ++k;
        }
        k = 0;
        while (k < this.getObservations().size()) {
            pos = new Position(this.getObservations().get((int)k).position);
            objects.add(pos);
            ++k;
        }
        for (Position npos : objects) {
            tmpcell = Cell.getCell(npos);
            i = tmpcell.x;
            j = tmpcell.y;
            s = tmpcell.side;
            nproba = 0.0;
            tgt_num = 1;
            while (tgt_num <= 5) {
                block13: {
                    this.getVariables().get("Tgt_" + tgt_num + "^t").setList(new int[]{i, j, s});
                    try {
                        nproba = s == 1 ? (nproba += this.getGridProbaDists().get(3 * tgt_num).getRightPart().getValue(this.getVariables())) : (nproba += this.getGridProbaDists().get(3 * tgt_num).getLeftPart().getValue(this.getVariables()));
                    }
                    catch (ShowableException se) {
                        msg = se.getMessage();
                        ** for (crtV : this.getAssociatedViews())
                    }
lbl-1000:
                    // 1 sources

                    {
                        crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, msg, null));
                        continue;
lbl40:
                        // 1 sources

                        break block13;
                    }
                    catch (Exception e) {
                        Utilities.exceptionCaughtMessage(e, this, "solveTask");
                    }
                }
                ++tgt_num;
            }
            obj_probas[index] = nproba;
            ++index;
        }
        n = 0;
        while (n < ntargets) {
            max = 0.0;
            k = 0;
            while (k < obj_probas.length) {
                if (obj_probas[k] >= max) {
                    max = obj_probas[k];
                    index = k;
                }
                ++k;
            }
            indices[n] = index;
            obj_probas[index] = 0.0;
            ++n;
        }
        count = 0;
        n = 0;
        while (n < ntargets) {
            if (indices[n] < ntargets) {
                ++count;
            }
            ++n;
        }
        System.out.println("Task results: " + count + "/" + ntargets);
        return indices;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Q2b_subCI
    implements Runnable {
        ProbabilisticDistribution[] myDists;
        ProbabilisticDistribution[][] p_tgt;
        int s_m;
        boolean isLower;
        Hashtable<String, RandomVariable> myVariables;
        double[] subSum;
        double[][][][] prob_dists;

        protected RandomVariable getVariable(String name) throws Exception {
            RandomVariable rv = this.myVariables.get(name);
            if (rv == null) {
                String msg = String.valueOf(this.getClass().getName()) + "::getVariable -error: [" + name + "] variable does not exist !\n";
                Enumeration<String> e = this.myVariables.keys();
                while (e.hasMoreElements()) {
                    msg = String.valueOf(msg) + e.nextElement() + "\n";
                }
                throw new Exception(msg);
            }
            return rv;
        }

        protected Hashtable<String, RandomVariable> getVariables() {
            return this.myVariables;
        }

        public Q2b_subCI(int s, boolean isLower, ProbabilisticDistribution[] myDists, ProbabilisticDistribution[][] p_tgt, double[] subSum, double[][][][] prob_dists, Hashtable<String, RandomVariable> myContextVariables) {
            this.s_m = s;
            this.isLower = isLower;
            this.myDists = myDists;
            this.p_tgt = p_tgt;
            this.myVariables = myContextVariables;
            this.subSum = subSum;
            this.prob_dists = prob_dists;
        }

        @Override
        public void run() {
            int i_max;
            int i_min;
            int gridw = Cell.leftGridRefConverter.getPixelWidth();
            int gridh = Cell.leftGridRefConverter.getPixelHeight();
            if (this.isLower) {
                i_min = 0;
                i_max = gridw / 2;
            } else {
                i_min = gridw / 2;
                i_max = gridw;
            }
            double tmp_proba = 1.0;
            double tmp_sum = 0.0;
            double[] sums = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            try {
                int i_m = i_min;
                while (i_m < i_max) {
                    int j_m = 0;
                    while (j_m < gridh) {
                        int n = 0;
                        while (n < 5) {
                            sums[n] = 0.0;
                            this.prob_dists[n][this.s_m][i_m][j_m] = 0.0;
                            ++n;
                        }
                        if (Cell.gridCells[this.s_m][i_m][j_m].isInsideTheGrid) {
                            this.getVariable("Mot-a^t").setList(new int[]{i_m, j_m, this.s_m});
                            this.getVariable("Mot-b^t").setList(new int[]{i_m, j_m, this.s_m});
                            int s = 0;
                            while (s < 2) {
                                int i = 0;
                                while (i < gridw) {
                                    int j = 0;
                                    while (j < gridh) {
                                        if (Cell.gridCells[this.s_m][i_m][j_m].isInsideTheGrid) {
                                            this.getVariable("Tgt_i^t").setList(new int[]{i, j, s});
                                            int n2 = 0;
                                            while (n2 < 5) {
                                                this.getVariable("Tgt_" + (n2 + 1) + "^t").setList(new int[]{i, j, s});
                                                int n3 = n2;
                                                double[] dArray = this.prob_dists[n2][this.s_m][i_m];
                                                int n4 = j_m;
                                                double d = dArray[n4] + this.p_tgt[n2][s].getValue(this.getVariables()) * this.myDists[1].getValue(this.getVariables());
                                                dArray[n4] = d;
                                                sums[n3] = sums[n3] + d;
                                                ++n2;
                                            }
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                                ++s;
                            }
                            tmp_proba = 1.0;
                            n = 0;
                            while (n < 5) {
                                if (sums[n] > 0.0) {
                                    tmp_proba *= this.prob_dists[n][this.s_m][i_m][j_m];
                                }
                                ++n;
                            }
                        } else {
                            tmp_proba = 0.0;
                        }
                        double d = tmp_proba * this.myDists[0].getValue(this.getVariables());
                        this.prob_dists[5][this.s_m][i_m][j_m] = d;
                        tmp_sum += d;
                        ++j_m;
                    }
                    ++i_m;
                }
                this.subSum[0] = tmp_sum;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Q1b_subCI
    implements Runnable {
        int tgt_num;
        ProbabilisticDistribution[] tgt_t;
        ProbabilisticDistribution[] tgt_t_1;
        ProbabilisticDistribution[] occ_t;
        ProbabilisticDistribution[] p_occ_tgt;
        Hashtable<String, RandomVariable> myVariables;

        protected RandomVariable getVariable(String name) throws Exception {
            RandomVariable rv = this.myVariables.get(name);
            if (rv == null) {
                String msg = String.valueOf(this.getClass().getName()) + "::getVariable -error: [" + name + "] variable does not exist !\n";
                Enumeration<String> e = this.myVariables.keys();
                while (e.hasMoreElements()) {
                    msg = String.valueOf(msg) + e.nextElement() + "\n";
                }
                throw new Exception(msg);
            }
            return rv;
        }

        protected Hashtable<String, RandomVariable> getVariables() {
            return this.myVariables;
        }

        public Q1b_subCI(int tgt_num, ProbabilisticDistribution[][] myDists, Hashtable<String, RandomVariable> myContextVariables) {
            this.tgt_num = tgt_num;
            this.myVariables = myContextVariables;
            this.tgt_t = myDists[0];
            this.tgt_t_1 = myDists[1];
            this.occ_t = myDists[2];
            this.p_occ_tgt = myDists[3];
        }

        @Override
        public void run() {
            try {
                int j;
                int i;
                int gridw = Cell.leftGridRefConverter.getPixelWidth();
                int gridh = Cell.leftGridRefConverter.getPixelHeight();
                double proba_total = 0.0;
                double proba = 0.0;
                double t_proba = 0.0;
                int s = 0;
                while (s < 2) {
                    i = 0;
                    while (i < gridw) {
                        j = 0;
                        while (j < gridh) {
                            proba = 0.0;
                            this.getVariables().get("Tgt_" + this.tgt_num + "^t").setList(new int[]{i, j, s});
                            if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                                Cell[] ants = Antecedent.getCells(i, j, s);
                                int[] nums = Antecedent.gridAntsNumerosity[s][i][j];
                                int ii = 0;
                                while (ii < ants.length) {
                                    this.getVariables().get("Tgt_" + this.tgt_num + "^{t-1}").setList(new int[]{ants[ii].x, ants[ii].y, ants[ii].side});
                                    proba += this.tgt_t_1[ants[ii].side].getValue(this.getVariables()) * (double)nums[ii];
                                    ++ii;
                                }
                                int t = 0;
                                while (t < 2) {
                                    int k = 0;
                                    while (k < gridw) {
                                        int l = 0;
                                        while (l < gridh) {
                                            this.getVariables().get("(x, y)").setList(new int[]{k, l, t});
                                            t_proba = 0.0;
                                            int v = 0;
                                            while (v <= 1) {
                                                this.getVariables().get("occ_{(x, y)}^t").setList(new int[]{v++});
                                                t_proba += this.occ_t[t].getValue(this.getVariables()) * this.p_occ_tgt[s].getValue(this.getVariables());
                                            }
                                            proba *= t_proba;
                                            ++l;
                                        }
                                        ++k;
                                    }
                                    ++t;
                                }
                            }
                            proba_total += proba;
                            this.tgt_t[s].setNewValue(this.getVariables(), proba);
                            ++j;
                        }
                        ++i;
                    }
                    ++s;
                }
                this.tgt_t[0].updateValues();
                this.tgt_t[1].updateValues();
                if (proba_total == 0.0) {
                    proba_total = 1.0;
                }
                s = 0;
                while (s < 2) {
                    i = 0;
                    while (i < gridw) {
                        j = 0;
                        while (j < gridh) {
                            this.getVariables().get("Tgt_" + this.tgt_num + "^t").setList(new int[]{i, j++, s});
                            this.tgt_t[s].setNewValue(this.getVariables(), this.tgt_t[s].getValue(this.getVariables()) / proba_total);
                        }
                        ++i;
                    }
                    ++s;
                }
                this.tgt_t[0].updateValues();
                this.tgt_t[1].updateValues();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Q1a_subCI
    implements Runnable {
        Hashtable<String, RandomVariable> myVariables;
        GridProbabilisticDistribution myResQ1;
        LeftRight_GridProbabilisticDistribution dist_t_1;
        ProbabilisticDistribution dist_obs;
        ProbabilisticDistribution dist_dyn;
        int s;

        public Q1a_subCI(int s, GridProbabilisticDistribution resQ1, LeftRight_GridProbabilisticDistribution dist_t_1, ProbabilisticDistribution dist_obs, ProbabilisticDistribution dist_dyn, Hashtable<String, RandomVariable> myContextVariables) {
            this.myVariables = myContextVariables;
            this.myResQ1 = resQ1;
            this.dist_t_1 = dist_t_1;
            this.dist_obs = dist_obs;
            this.dist_dyn = dist_dyn;
            this.s = s;
        }

        protected RandomVariable getVariable(String name) throws Exception {
            RandomVariable rv = this.myVariables.get(name);
            if (rv == null) {
                String msg = String.valueOf(this.getClass().getName()) + "::getVariable -error: [" + name + "] variable does not exist !\n";
                Enumeration<String> e = this.myVariables.keys();
                while (e.hasMoreElements()) {
                    msg = String.valueOf(msg) + e.nextElement() + "\n";
                }
                throw new Exception(msg);
            }
            return rv;
        }

        protected Hashtable<String, RandomVariable> getVariables() {
            return this.myVariables;
        }

        @Override
        public void run() {
            int gridw = Cell.leftGridRefConverter.getPixelWidth();
            int gridh = Cell.leftGridRefConverter.getPixelHeight();
            double proba_total = 0.0;
            try {
                int[][] var_domain = this.getVariable("occ_{(x, y)}^t").getListDomain();
                byte[][] obs_val = this.s == 0 ? this.getVariable("L-Obs^t").getTable() : this.getVariable("R-Obs^t").getTable();
                int i = 0;
                while (i < gridw) {
                    int j = 0;
                    while (j < gridh) {
                        int k;
                        double[] proba_prod;
                        if (Cell.gridCells[this.s][i][j].isInsideTheGrid) {
                            proba_total = 0.0;
                            double[] proba_vois = new double[var_domain[0].length];
                            double[] proba_capt = new double[var_domain[0].length];
                            proba_prod = new double[var_domain[0].length];
                            this.getVariable("obs_{(x, y)}^t").setListVar(0, obs_val[i][j]);
                            k = 0;
                            while (k < var_domain[0].length) {
                                this.getVariable("occ_{(x, y)}^t").setListVar(0, var_domain[0][k]);
                                this.getVariable("(x, y)").setList(new int[]{i, j, this.s});
                                proba_vois[k] = V251_BossEngine.Q1_getSum(i, j, this.s, "occ", this.getVariables(), this.dist_t_1, this.dist_dyn);
                                if (new Double(proba_vois[k]).isNaN() || proba_vois[k] == 0.0) {
                                    System.out.println("vois NaN/0 in (" + i + ", " + j + "):" + this.s);
                                }
                                proba_capt[k] = this.dist_obs.getValue(this.getVariables());
                                if (new Double(proba_capt[k]).isNaN() || proba_capt[k] == 0.0) {
                                    System.out.println("capt NaN/0 in (" + i + ", " + j + "):" + this.s);
                                }
                                proba_prod[k] = proba_capt[k] * proba_vois[k];
                                proba_total += proba_prod[k];
                                ++k;
                            }
                        } else {
                            proba_prod = new double[]{1.0, 0.0};
                            proba_total = 1.0;
                        }
                        k = 0;
                        while (k < var_domain[0].length) {
                            int var_val = var_domain[0][k];
                            this.getVariable("occ_{(x, y)}^t").setList(new int[]{var_val});
                            this.getVariable("(x, y)").setList(new int[]{i, j, this.s});
                            if (proba_total == 0.0) {
                                System.out.println("tot NaN in (" + i + ", " + j + "):" + this.s);
                            }
                            this.myResQ1.setNewValue(this.getVariables(), proba_prod[k] / proba_total);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.myResQ1.updateValues();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

