/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Antecedent;
import engine.BossEngine;
import engine.Cell;
import engine.FunctionProbabilisticDistribution;
import engine.GridPosDebugPolicy;
import engine.GridProbabilisticDistribution;
import engine.LeftRight_GridProbabilisticDistribution;
import engine.LeftRight_Variable;
import engine.Observation;
import engine.RandomVariable;
import engine.ShowableException;
import gui.MVC_Event;
import gui.MVC_Event_Type;
import gui.View;
import java.util.Hashtable;
import utils.BetaDistributionFunction1D;
import utils.GridReferenceConverter;
import utils.Position;
import utils.Utilities;

public class V16_BossEngine
extends BossEngine {
    private static BossEngine uniqInstance = null;
    private Cell lastSaccadeCell;
    private double[][][] logPrior_Q2;
    private boolean prior_ok;

    private V16_BossEngine() {
    }

    public static BossEngine getInstance() {
        if (uniqInstance == null) {
            uniqInstance = new V16_BossEngine();
            BossEngine.appliVersion = "1.6";
            uniqInstance.setDebugPolicy(new GridPosDebugPolicy());
        }
        return uniqInstance;
    }

    protected void updateVariables() throws ShowableException {
        Cell sacc_cell = this.updateSaccade();
        if (this.lastSaccadeCell == null || !this.lastSaccadeCell.equals(sacc_cell)) {
            Position sacc_pos = sacc_cell.centerPos;
            Antecedent.setAllAntecedentsFromATranslation(sacc_pos);
            this.lastSaccadeCell = sacc_cell;
            System.out.println("V16_BossEngine::updateVariables -new saccade");
        }
        this.updateObservation();
        this.updateCell();
        this.updateAntecedent(true, "CAnt");
        this.updateAntecedent(false, "Ant");
        this.updateDens();
        this.updateLogQ2();
        this.notifyUpdate();
    }

    private final void updateLogQ2() throws ShowableException {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_LogQ2 = new byte[gridw][gridh];
        byte[][] r_LogQ2 = new byte[gridw][gridh];
        byte[][] l_dLogQ2 = new byte[gridw][gridh];
        byte[][] r_dLogQ2 = new byte[gridw][gridh];
        double[][] l_proba = this.getGridProbaDists().get(3).getLeftPart().getGridValues();
        double[][] r_proba = this.getGridProbaDists().get(3).getRightPart().getGridValues();
        this.getGridProbaDists().get(3).getRightPart().updateValues();
        this.getGridProbaDists().get(3).getLeftPart().updateValues();
        try {
            int j;
            int i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[0][i][j].isInsideTheGrid) {
                        l_LogQ2[i][j] = (byte)StrictMath.max(0L, StrictMath.min(127L, -StrictMath.round(StrictMath.log(l_proba[i][j]))));
                    }
                    if (Cell.gridCells[1][i][j].isInsideTheGrid) {
                        r_LogQ2[i][j] = (byte)StrictMath.max(0L, StrictMath.min(127L, -StrictMath.round(StrictMath.log(r_proba[i][j]))));
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[0][i][j].isInsideTheGrid) {
                        l_dLogQ2[i][j] = (byte)StrictMath.max(-50L, StrictMath.min(50L, -StrictMath.round(25.0 * StrictMath.log(l_proba[i][j] / r_proba[gridw - i - 1][j]))));
                        r_dLogQ2[gridw - i - 1][j] = -l_dLogQ2[i][j];
                    } else {
                        l_dLogQ2[i][j] = -50;
                        r_dLogQ2[gridw - i - 1][j] = -50;
                    }
                    ++j;
                }
                ++i;
            }
            this.getVariable("L-LogQ2").setTable(l_LogQ2);
            this.getVariable("R-LogQ2").setTable(r_LogQ2);
            this.getVariable("L-DeltaLogQ2").setTable(l_dLogQ2);
            this.getVariable("R-DeltaLogQ2").setTable(r_dLogQ2);
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "updateLogQ2");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Cell updateSaccade() throws ShowableException {
        if (this.getSaccades().size() < 1) {
            String msg = String.valueOf(this.getClass().getName()) + "::updateSaccade" + " -error";
            System.out.println(String.valueOf(msg) + " not enough saccades");
            msg = "Problem in the data update$Update of the saccades data is not possible :\nnot enough saccades !";
            throw new ShowableException(msg);
        }
        String var_name1 = "";
        String var_name2 = "";
        Cell sacc_cell = Cell.getCell(this.getSaccades().get((int)0).position);
        if (sacc_cell == null) {
            System.out.println(String.valueOf(this.getClass().getName()) + "::updateSaccade" + " infos saccade pos outside the grid (" + sacc_cell.x + "," + sacc_cell.y + "), Sacc^t not updated");
            return null;
        }
        if (sacc_cell.isRight) {
            var_name1 = "R-Sacc^t";
            var_name2 = "L-Sacc^t";
        } else {
            var_name1 = "L-Sacc^t";
            var_name2 = "R-Sacc^t";
        }
        try {
            this.getVariable(var_name1).setListVar(0, sacc_cell.x);
            this.getVariable(var_name1).setListVar(1, sacc_cell.y);
            this.getVariable(var_name2).setToDefaultValues();
            return sacc_cell;
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "updateSaccade");
            return null;
        }
    }

    private final void updateObservation() throws ShowableException {
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_obs = new byte[l_gridw][gridh];
        byte[][] r_obs = new byte[r_gridw][gridh];
        for (Observation t : this.getObservations()) {
            this.fillObservation_3(t, l_obs, r_obs);
        }
        try {
            this.getVariable("R-Obs^t").setTable(r_obs);
            this.getVariable("L-Obs^t").setTable(l_obs);
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "updateOccupancy");
        }
    }

    private final void fillObservation_3(Observation crtT, byte[][] l_obs, byte[][] r_obs) {
        double sq_radius = StrictMath.pow(crtT.size / 2.0, 2.0);
        double h_c = crtT.position.getX1();
        double v_c = crtT.position.getY1();
        GridReferenceConverter l_grc = Cell.leftGridRefConverter;
        GridReferenceConverter r_grc = Cell.rightGridRefConverter;
        int gridw = l_grc.getPixelWidth();
        int gridh = l_grc.getPixelHeight();
        int i = 0;
        while (i < gridw) {
            int j = 0;
            while (j < gridh) {
                Position l_pos = new Position(l_grc.xBasic(i), l_grc.yBasic(j), false);
                Position r_pos = new Position(r_grc.xBasic(i), r_grc.yBasic(j), false);
                if (Cell.gridCells[0][i][j].isInsideTheGrid && sq_radius >= StrictMath.pow(l_pos.getX1() - h_c, 2.0) + StrictMath.pow(l_pos.getY1() - v_c, 2.0)) {
                    l_obs[i][j] = 1;
                }
                if (Cell.gridCells[1][i][j].isInsideTheGrid && sq_radius >= StrictMath.pow(r_pos.getX1() - h_c, 2.0) + StrictMath.pow(r_pos.getY1() - v_c, 2.0)) {
                    r_obs[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        Cell t_cell = Cell.getCell(crtT.position);
        if (t_cell.isRight) {
            r_obs[t_cell.x][t_cell.y] = 1;
        } else {
            l_obs[t_cell.x][t_cell.y] = 1;
        }
    }

    private final void fillObservation_1(Observation crtT, byte[][] l_obs, byte[][] r_obs) {
        double x = 0.0;
        double y = 0.0;
        double radius = crtT.size / 2.0;
        double sq_radius = StrictMath.pow(radius, 2.0);
        double x_center = crtT.position.getX1();
        double y_center = crtT.position.getY1();
        double x_min = x_center - radius;
        double y_min = y_center - radius;
        double dist = StrictMath.pow(x_center, 2.0) + StrictMath.pow(y_center, 2.0);
        double sqrt_nb = StrictMath.sqrt(-14.0 * StrictMath.log(dist + 1.0E-4) + 127.0);
        int nb_pts = (int)StrictMath.rint(StrictMath.min(StrictMath.max(1.0, sqrt_nb), 15.0));
        double inter = crtT.size / (double)nb_pts;
        Cell crt_cell = null;
        int i = 0;
        while (i < nb_pts) {
            int j = 0;
            while (j < nb_pts) {
                x = x_min + (double)i * inter;
                y = y_min + (double)j * inter;
                if (StrictMath.pow(x - x_center, 2.0) + StrictMath.pow(y - y_center, 2.0) <= sq_radius) {
                    crt_cell = Cell.getCell(new Position(x, y, true));
                    if (crt_cell != null) {
                        if (crt_cell.isRight) {
                            r_obs[crt_cell.x][crt_cell.y] = 1;
                        } else {
                            l_obs[crt_cell.x][crt_cell.y] = 1;
                        }
                    } else {
                        System.out.println(String.valueOf(this.getClass().getName()) + "::updateObservation infos: observation pos outside" + "he grid not updated");
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private final void fillObservation_2(Observation crtT, byte[][] l_obs, byte[][] r_obs) {
        double angle_radius_ratio = StrictMath.sqrt(0.8333333333333334);
        double angle_radius_unratio = StrictMath.sqrt(0.16666666666666663);
        double x = 0.0;
        double y = 0.0;
        double radius = crtT.size / 2.0;
        double x_center = crtT.position.getX1();
        double y_center = crtT.position.getY1();
        double dist = StrictMath.pow(x_center, 2.0) + StrictMath.pow(y_center, 2.0);
        double sqrt_pts = StrictMath.sqrt(-14.0 * StrictMath.log(dist + 1.0E-4) + 127.0);
        int nb_pts_angle = (int)StrictMath.rint(StrictMath.min(StrictMath.max(1.0, angle_radius_ratio * sqrt_pts), 15.0));
        int nb_pts_radius = (int)StrictMath.rint(StrictMath.min(StrictMath.max(1.0, angle_radius_unratio * sqrt_pts), 15.0));
        System.out.println("-dist:" + dist + " -nb_pts_a:" + nb_pts_angle + " -nb_pts_r:" + nb_pts_radius);
        double angle_inter = Math.PI * 2 / (double)nb_pts_angle;
        double radius_inter = radius / (double)nb_pts_radius;
        double crt_radius = 0.0;
        double crt_angle = 0.0;
        Cell crt_cell = null;
        int ia = 0;
        while (ia < nb_pts_angle) {
            crt_angle = (double)ia * angle_inter;
            int ir = 0;
            while (ir < nb_pts_radius) {
                crt_radius = (double)(ir + 1) * radius_inter;
                x = x_center + crt_radius * StrictMath.cos(crt_angle);
                crt_cell = Cell.getCell(new Position(x, y = y_center + crt_radius * StrictMath.sin(crt_angle), true));
                if (crt_cell != null) {
                    if (crt_cell.isRight) {
                        r_obs[crt_cell.x][crt_cell.y] = 1;
                    } else {
                        l_obs[crt_cell.x][crt_cell.y] = 1;
                    }
                } else {
                    System.out.println(String.valueOf(this.getClass().getName()) + "::updateObservation infos: observation pos outside" + "he grid not updated");
                }
                ++ir;
            }
            ++ia;
        }
    }

    private final void updateDens() throws ShowableException {
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_obs = new byte[gridw][gridh];
        byte[][] r_obs = new byte[gridw][gridh];
        Cell crt_cell = null;
        for (Observation t : this.getObservations()) {
            int val;
            double dist;
            double y;
            double x;
            int j;
            int i;
            crt_cell = Cell.getCell(t.position);
            if (crt_cell == null) continue;
            double cellx = crt_cell.x;
            double celly = crt_cell.y;
            if (crt_cell.isRight) {
                i = 0;
                while (i < gridw) {
                    j = 0;
                    while (j < gridh) {
                        x = i;
                        y = j;
                        dist = StrictMath.sqrt(StrictMath.pow(cellx - x, 2.0) + StrictMath.pow(celly - y, 2.0));
                        val = StrictMath.max(0, (int)StrictMath.rint(-2.0 * dist + 15.0));
                        r_obs[i][j] = (byte)StrictMath.min(20, r_obs[i][j] + val);
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    x = i;
                    y = j;
                    dist = StrictMath.sqrt(StrictMath.pow(cellx - x, 2.0) + StrictMath.pow(celly - y, 2.0));
                    val = StrictMath.max(0, (int)StrictMath.rint(-2.0 * dist + 15.0));
                    l_obs[i][j] = (byte)StrictMath.min(20, l_obs[i][j] + val);
                    ++j;
                }
                ++i;
            }
        }
        try {
            this.getVariable("R-Dens").setTable(r_obs);
            this.getVariable("L-Dens").setTable(l_obs);
        }
        catch (Exception e) {
            Utilities.exceptionCaughtMessage(e, this, "updateDens");
        }
    }

    private final void updateCell() throws ShowableException {
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_cell = new byte[l_gridw][gridh];
        byte[][] r_cell = new byte[r_gridw][gridh];
        if (this.getObservations() != null && this.getObservations().size() > 0) {
            Observation crt_observation = this.getObservations().get(0);
            Cell crt_cell = Cell.getCell(crt_observation.position);
            if (crt_cell != null) {
                Cell crt_vic = null;
                int i = 0;
                while (i < crt_cell.closeVicinity.length) {
                    crt_vic = crt_cell.closeVicinity[i];
                    if (crt_vic.isRight) {
                        r_cell[crt_vic.x][crt_vic.y] = 1;
                    } else {
                        l_cell[crt_vic.x][crt_vic.y] = 1;
                    }
                    ++i;
                }
                try {
                    this.getVariable("R-Cell").setTable(r_cell);
                    this.getVariable("L-Cell").setTable(l_cell);
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "updateCell");
                }
            }
        }
    }

    private final void updateAntecedent(boolean colored, String varName) throws ShowableException {
        int l_gridw = Cell.leftGridRefConverter.getPixelWidth();
        int r_gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        byte[][] l_ant = new byte[l_gridw][gridh];
        byte[][] r_ant = new byte[r_gridw][gridh];
        if (this.getObservations() != null && this.getObservations().size() > 0) {
            for (Observation crt_observation : this.getObservations()) {
                Cell crt_cell = Cell.getCell(crt_observation.position);
                if (crt_cell == null) continue;
                Cell[] crt_ants = Antecedent.getCells(crt_cell);
                int[] nums = Antecedent.getNumerosity(crt_cell);
                int i = 0;
                while (i < crt_ants.length) {
                    int val = 10;
                    if (colored) {
                        val = (byte)nums[i];
                    }
                    if (crt_ants[i].isRight) {
                        r_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    } else {
                        l_ant[crt_ants[i].x][crt_ants[i].y] = val;
                    }
                    ++i;
                }
                try {
                    this.getVariable("R-" + varName).setTable(r_ant);
                    this.getVariable("L-" + varName).setTable(l_ant);
                }
                catch (Exception e) {
                    Utilities.exceptionCaughtMessage(e, this, "updateAnt");
                }
            }
        }
    }

    private final void updateOccupancy() throws ShowableException {
    }

    /*
     * Unable to fully structure code
     */
    protected void subInfer() {
        block4: {
            try {
                this.updateVariables();
                this.Q1_computeInference();
                this.Q2_computeInference();
                this.notifyUpdate();
            }
            catch (ShowableException se) {
                msg = se.getMessage();
                ** for (crtV : this.getAssociatedViews())
            }
lbl-1000:
            // 1 sources

            {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.MSG_ERR, this, msg, null));
                continue;
lbl13:
                // 1 sources

                break block4;
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "subInfer");
            }
        }
    }

    private final double Q2_getLogProdPrior(int x_m, int y_m, int side_m) throws Exception {
        double proba = 0.0;
        double logprod = 0.0;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double proba_occ = 0.0;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        proba_occ = 0.00648855;
                        this.getVariable("i^t_{x_0,y_0}").setRealVal(proba_occ);
                        this.getVariable("(x_0,y_0)").setList(new int[]{i, j, s});
                        proba = s == 0 ? this.getGridProbaDists().get(1).getLeftPart().getValue(this.getVariables()) : this.getGridProbaDists().get(1).getRightPart().getValue(this.getVariables());
                        logprod += StrictMath.log(proba);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        return logprod;
    }

    private void Q2_computePrior() throws Exception {
        int j;
        int i;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        this.logPrior_Q2 = new double[2][gridw][gridh];
        double lproba_max = StrictMath.log(0.0);
        double proba_sum = 0.0;
        double[][][] lproba_total = new double[2][gridw][gridh];
        double[][][] proba_total = new double[2][gridw][gridh];
        double lp_mot_prior = 0.0;
        double lp_mot_choix = 0.0;
        this.getDebugPolicy().traceDebugInInf(this, new Object[]{101, lp_mot_prior, lp_mot_choix, lproba_max});
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getDebugPolicy().traceDebugPreInf(this, new Object[]{i, j, s});
                        this.getVariable("mot^t").setList(new int[]{i, j, s});
                        lp_mot_prior = s == 0 ? StrictMath.log(this.getGridProbaDists().get(0).getLeftPart().getValue(this.getVariables())) : StrictMath.log(this.getGridProbaDists().get(0).getRightPart().getValue(this.getVariables()));
                        lproba_total[s][i][j] = lp_mot_choix = this.Q2_getLogProdPrior(i, j, s);
                        lproba_max = StrictMath.max(lproba_max, lproba_total[s][i][j]);
                        this.getDebugPolicy().traceDebugInInf(this, new Object[]{101, lp_mot_prior, lp_mot_choix, lproba_max});
                    } else {
                        lproba_total[s][i][j] = StrictMath.log(0.0);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    proba_total[s][i][j] = StrictMath.exp(lproba_total[s][i][j] - lproba_max);
                    proba_sum += proba_total[s][i][j];
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.logPrior_Q2[s][i][j] = proba_total[s][i][j] == 0.0 ? StrictMath.log(0.0) : -StrictMath.log(proba_total[s][i][j] / proba_sum);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.prior_ok = true;
    }

    private void Q2_computeInference() throws Exception {
        int j;
        int i;
        if (!this.prior_ok) {
            this.Q2_computePrior();
        }
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double lproba_max = StrictMath.log(0.0);
        double proba_sum = 0.0;
        double[][][] lproba_total = new double[2][gridw][gridh];
        double[][][] proba_total = new double[2][gridw][gridh];
        double lp_mot_prior = 0.0;
        double lp_mot_choix = 0.0;
        this.getDebugPolicy().traceDebugInInf(this, new Object[]{101, lp_mot_prior, lp_mot_choix, lproba_max});
        int s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getDebugPolicy().traceDebugPreInf(this, new Object[]{i, j, s});
                    this.getVariable("mot^t").setList(new int[]{i, j, s});
                    lp_mot_prior = this.logPrior_Q2[s][i][j];
                    lp_mot_choix = this.Q2_getLogProd(i, j, s);
                    lproba_total[s][i][j] = lp_mot_prior + lp_mot_choix;
                    lproba_max = StrictMath.max(lproba_max, lproba_total[s][i][j]);
                    this.getDebugPolicy().traceDebugInInf(this, new Object[]{101, lp_mot_prior, lp_mot_choix, lproba_max});
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    proba_total[s][i][j] = StrictMath.exp(lproba_total[s][i][j] - lproba_max);
                    proba_sum += proba_total[s][i][j];
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        s = 0;
        while (s < 2) {
            i = 0;
            while (i < gridw) {
                j = 0;
                while (j < gridh) {
                    this.getVariable("mot^t").setList(new int[]{i, j, s});
                    if (s == 0) {
                        this.getGridProbaDists().get(3).getLeftPart().setNewValue(this.getVariables(), proba_total[s][i][j] / proba_sum);
                    } else {
                        this.getGridProbaDists().get(3).getRightPart().setNewValue(this.getVariables(), proba_total[s][i][j] / proba_sum);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(3).getLeftPart().updateValues();
        this.getGridProbaDists().get(3).getRightPart().updateValues();
        this.updateLogQ2();
        BetaDistributionFunction1D.printStats();
    }

    private final double Q2_getLogProd(int x_m, int y_m, int side_m) throws Exception {
        double proba = 0.0;
        double logprod = 0.0;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        double proba_occ = 0.0;
        this.getDebugPolicy().traceDebugInInf(this, new Object[]{111});
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        this.getVariable("occ^{t-1}_{(x_a,y_a)}").setList(new int[]{1});
                        this.getVariable("(x_a,y_a)").setList(new int[]{i, j, s});
                        proba_occ = s == 0 ? this.getGridProbaDists().get(2).getLeftPart().getValue(this.getVariables()) : this.getGridProbaDists().get(2).getRightPart().getValue(this.getVariables());
                        this.getVariable("i^t_{x_0,y_0}").setRealVal(proba_occ);
                        this.getVariable("(x_0,y_0)").setList(new int[]{i, j, s});
                        proba = s == 0 ? this.getGridProbaDists().get(1).getLeftPart().getValue(this.getVariables()) : this.getGridProbaDists().get(1).getRightPart().getValue(this.getVariables());
                        logprod += StrictMath.log(proba);
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getDebugPolicy().traceDebugInInf(this, new Object[]{131});
        return logprod;
    }

    private final void Q1_computeInference() throws Exception {
        double epsilon10 = 0.1;
        double epsilon01 = 0.05;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        int[][] var_domain = this.getVariable("occ^t_{(x_0,y_0)}").getListDomain();
        double p1 = 0.0;
        double p2 = 0.0;
        double proba_total = 0.0;
        double[] proba_vois = null;
        double[] proba_capt = null;
        double[] proba_prod = null;
        int s = 0;
        while (s < 2) {
            int i = 0;
            while (i < gridw) {
                int j = 0;
                while (j < gridh) {
                    int k;
                    if (Cell.gridCells[s][i][j].isInsideTheGrid) {
                        proba_total = 0.0;
                        proba_vois = new double[var_domain[0].length];
                        proba_capt = new double[var_domain[0].length];
                        proba_prod = new double[var_domain[0].length];
                        this.getDebugPolicy().traceDebugPreInf(this, new Object[]{i, j, s});
                        k = 0;
                        while (k < var_domain[0].length) {
                            this.getVariable("occ^t_{(x_0,y_0)}").setListVar(0, var_domain[0][k]);
                            this.getVariable("(x_0,y_0)").setList(new int[]{i, j, s});
                            this.getVariable("(x_a,y_a)").setList(new int[]{i, j, s});
                            proba_vois[k] = this.Q1_getSum(i, j, s);
                            proba_capt[k] = this.Q1_getCapteur();
                            ++k;
                        }
                        p1 = (1.0 - epsilon01) * proba_vois[0] + epsilon10 * proba_vois[1];
                        p2 = epsilon01 * proba_vois[0] + (1.0 - epsilon10) * proba_vois[1];
                        proba_prod[0] = proba_capt[0] * p1;
                        proba_prod[1] = proba_capt[1] * p2;
                        proba_total = proba_prod[0] + proba_prod[1];
                        this.getDebugPolicy().traceDebugInInf(this, new Object[]{0, epsilon10, p1, p2, proba_total, proba_vois, proba_prod, proba_capt});
                    } else {
                        proba_prod[0] = 1.0;
                        proba_prod[1] = 0.0;
                        proba_total = 1.0;
                    }
                    k = 0;
                    while (k < var_domain[0].length) {
                        int var_val = var_domain[0][k];
                        this.getVariable("occ^{t-1}_{(x_a,y_a)}").setList(new int[]{var_val});
                        this.getVariable("(x_a,y_a)").setList(new int[]{i, j, s});
                        this.getDebugPolicy().traceDebugInInf(this, new Object[]{10, proba_prod[k], proba_total});
                        if (s == 0) {
                            this.getGridProbaDists().get(2).getLeftPart().setNewValue(this.getVariables(), proba_prod[k] / proba_total);
                        } else {
                            this.getGridProbaDists().get(2).getRightPart().setNewValue(this.getVariables(), proba_prod[k] / proba_total);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.getGridProbaDists().get(2).getLeftPart().updateValues();
        this.getGridProbaDists().get(2).getRightPart().updateValues();
        this.getDebugPolicy().traceDebugPostInf(this, null);
    }

    private final double Q1_getSum(int x, int y, int side) throws Exception {
        Cell[] ant_cells = Antecedent.getCells(x, y, side);
        int[] val_ants = new int[ant_cells.length];
        int max_powa = (int)StrictMath.rint(StrictMath.pow(2.0, ant_cells.length));
        int[] two_p = new int[ant_cells.length];
        int k = 0;
        while (k < two_p.length) {
            two_p[k] = (int)StrictMath.rint(StrictMath.pow(2.0, k));
            ++k;
        }
        double proba_sum = 0.0;
        if (val_ants.length != 0) {
            int[][] domain = new int[val_ants.length][2];
            int i = 0;
            while (i < domain.length) {
                int[] nArray = new int[2];
                nArray[1] = 1;
                domain[i] = nArray;
                ++i;
            }
            this.setVariable(new RandomVariable("val-ants_{(x_0,y_0)}", domain));
            int[] cpts = new int[ant_cells.length];
            int[] values = new int[ant_cells.length];
            double proba1 = 0.0;
            double proba2 = 0.0;
            int k2 = 0;
            while (k2 < max_powa) {
                int i2 = 0;
                while (i2 < ant_cells.length) {
                    val_ants[i2] = values[i2];
                    int n = i2;
                    cpts[n] = cpts[n] + 1;
                    if (cpts[i2] % two_p[i2] == 0) {
                        values[i2] = (values[i2] + 1) % 2;
                    }
                    ++i2;
                }
                proba1 = 0.0;
                this.getVariable("val-ants_{(x_0,y_0)}").setList(val_ants);
                proba2 = this.Q1_getSum_getOldQ1(ant_cells, val_ants);
                this.getDebugPolicy().traceDebugInInf(this, new Object[]{21, val_ants, proba1, proba2, proba_sum += (proba1 += this.getOthersProbaDists().get(1).getValue(this.getVariables())) * proba2});
                ++k2;
            }
        } else {
            proba_sum = side == 1 ? this.getGridProbaDists().get(2).getRightPart().getValue(this.getVariables()) : this.getGridProbaDists().get(2).getRightPart().getValue(this.getVariables());
            this.getDebugPolicy().traceDebugInInf(this, new Object[]{30, x, y, side, proba_sum});
        }
        this.getDebugPolicy().traceDebugInInf(this, new Object[]{41, x, y, side, proba_sum, ant_cells});
        return proba_sum;
    }

    private final double Q1_getSum_getOldQ1(Cell[] antCells, int[] antVals) throws Exception {
        double retour = 1.0;
        double proba = 0.0;
        int[] ant_cell_pos = null;
        GridProbabilisticDistribution gpd = null;
        this.getDebugPolicy().traceDebugInInf(this, new Object[]{50});
        int i = 0;
        while (i < antCells.length) {
            ant_cell_pos = new int[]{antCells[i].x, antCells[i].y};
            this.getVariable("(x_a,y_a)").setList(ant_cell_pos);
            this.getVariable("occ^{t-1}_{(x_a,y_a)}").setList(new int[]{antVals[i]});
            gpd = antCells[i].isRight ? this.getGridProbaDists().get(2).getRightPart() : this.getGridProbaDists().get(2).getLeftPart();
            proba = gpd.getValue(this.getVariables());
            this.getDebugPolicy().traceDebugInInf(this, new Object[]{60, i, antCells.length, proba});
            retour *= proba;
            ++i;
        }
        return retour;
    }

    private final double Q1_getCapteur() throws Exception {
        return this.getOthersProbaDists().get(0).getValue(this.getVariables());
    }

    protected void initRandomVariables() {
        int gridw = Cell.rightGridRefConverter.getPixelWidth();
        int gridh = Cell.rightGridRefConverter.getPixelHeight();
        int[] l_zero_p = Cell.getZeroGridPos(false);
        int[] r_zero_p = Cell.getZeroGridPos(true);
        Object domain = RandomVariable.getDomainForGridPos(gridw, gridh);
        this.setVariable(new LeftRight_Variable(l_zero_p, r_zero_p, "Sacc^t", (int[][])domain));
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        byte[] bdomain = byArray;
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Obs^t", bdomain));
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Cell", bdomain));
        bdomain = new byte[Antecedent.getMaxAntecedentsNb() + 1];
        int i = 0;
        while (i < bdomain.length) {
            bdomain[i] = i;
            i = (byte)(i + 1);
        }
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Ant", bdomain));
        this.setVariable(new LeftRight_Variable(gridw, gridh, "CAnt", bdomain));
        bdomain = new byte[21];
        i = 0;
        while (i < bdomain.length) {
            bdomain[i] = i;
            i = (byte)(i + 1);
        }
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Dens", bdomain));
        this.setVariable(new LeftRight_Variable(gridw, gridh, "Fct1", bdomain));
        bdomain = new byte[128];
        i = 0;
        while (i < bdomain.length) {
            bdomain[i] = (byte)i;
            ++i;
        }
        this.setVariable(new LeftRight_Variable(gridw, gridh, "LogQ2", bdomain));
        bdomain = new byte[101];
        i = 0;
        while (i < bdomain.length) {
            bdomain[i] = (byte)(i - 50);
            ++i;
        }
        this.setVariable(new LeftRight_Variable(gridw, gridh, "DeltaLogQ2", bdomain));
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        domain = nArrayArray;
        this.setVariable(new RandomVariable("occ^t_{(x_0,y_0)}", (int[][])domain));
        this.setVariable(new RandomVariable("occ^{t-1}_{(x_a,y_a)}", (int[][])domain));
        domain = RandomVariable.getDomainForGridPos(gridw, gridh);
        this.setVariable(new RandomVariable("mot^t", (int[][])domain));
        this.setVariable(new RandomVariable("(x_0,y_0)", (int[][])domain));
        this.setVariable(new RandomVariable("(x_a,y_a)", (int[][])domain));
        double[] rdomain = new double[]{0.0, 1.0};
        this.setVariable(new RandomVariable(0.0, "i^t_{x_0,y_0}", rdomain));
    }

    protected void getCellInfos(Position requestPos, String elementName) {
        Cell r_c = Cell.getCell(requestPos);
        if (r_c == null) {
            String msg = "No cell !";
            for (View crtV : this.getAssociatedViews()) {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.TOOLTIP_INFOS, this, msg, null));
            }
        } else {
            String msg = "Cell (" + r_c.x + "," + r_c.y + ":" + r_c.side + ") || Ant:";
            Cell[] r_a = Antecedent.getCells(r_c);
            msg = r_a != null && r_a.length != 0 ? String.valueOf(msg) + r_a.length + " " : String.valueOf(msg) + "0 ";
            try {
                double val = 0.0;
                this.getVariable("(x_a,y_a)").setList(new int[]{r_c.x, r_c.y, r_c.side});
                if (r_c.isRight) {
                    this.getVariable("occ^{t-1}_{(x_a,y_a)}").setList(new int[1]);
                    val = this.getGridProbaDists().get(2).getRightPart().getValue(this.getVariables());
                    msg = String.valueOf(msg) + " || Q_1: [occ^t=0]:" + val + " ";
                    this.getVariable("occ^{t-1}_{(x_a,y_a)}").setList(new int[]{1});
                    val = this.getGridProbaDists().get(2).getRightPart().getValue(this.getVariables());
                    msg = String.valueOf(msg) + " [occ^t=1]: " + val;
                    this.getVariable("mot^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                    val = this.getGridProbaDists().get(3).getRightPart().getValue(this.getVariables());
                    msg = String.valueOf(msg) + " || Q_2: " + val;
                } else {
                    this.getVariable("occ^{t-1}_{(x_a,y_a)}").setList(new int[1]);
                    val = this.getGridProbaDists().get(2).getLeftPart().getValue(this.getVariables());
                    msg = String.valueOf(msg) + " || Q_1: [occ^t=0]: " + val + " ";
                    this.getVariable("occ^{t-1}_{(x_a,y_a)}").setList(new int[]{1});
                    val = this.getGridProbaDists().get(2).getLeftPart().getValue(this.getVariables());
                    msg = String.valueOf(msg) + " [occ^t=1]: " + val;
                    this.getVariable("mot^t").setList(new int[]{r_c.x, r_c.y, r_c.side});
                    val = this.getGridProbaDists().get(3).getLeftPart().getValue(this.getVariables());
                    msg = String.valueOf(msg) + " || Q_2: " + val;
                }
            }
            catch (Exception e) {
                Utilities.exceptionCaughtMessage(e, this, "getCellInfos");
            }
            for (View crtV : this.getAssociatedViews()) {
                crtV.performedM_VC_Event(new MVC_Event(MVC_Event_Type.TOOLTIP_INFOS, this, msg, null));
            }
        }
    }

    protected final void initProbaDistributions() {
        GridReferenceConverter lc = Cell.leftGridRefConverter;
        GridReferenceConverter rc = Cell.rightGridRefConverter;
        double val_norm = 0.01;
        Hashtable<String, String> params = null;
        LeftRight_GridProbabilisticDistribution[] gpds = new LeftRight_GridProbabilisticDistribution[]{new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc), new LeftRight_GridProbabilisticDistribution("GPD_Function", lc, rc), new LeftRight_GridProbabilisticDistribution("GPD_Table3D", lc, rc), new LeftRight_GridProbabilisticDistribution("GPD_Table2D", lc, rc)};
        params = new Hashtable<String, String>();
        params.put("searchNames", "Mot^t");
        params.put("paramNames", "@mot^t:0#@mot^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        gpds[0].init(params);
        params = new Hashtable();
        params.put("knownNames", "Mot^t");
        params.put("searchNames", "i^t_{x,y}");
        params.put("functionType", "BetaDistributionFunction1D");
        params.put("functionParameters", "");
        params.put("functionVariableNames", "@(x_0,y_0)#@mot^t#@i^t_{x_0,y_0}");
        gpds[1].init(params);
        params = new Hashtable();
        params.put("inferenceSideNb", "1");
        params.put("paramNames", "@occ^{t-1}_{(x_a,y_a)}:0#@(x_a,y_a):0#@(x_a,y_a):1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        gpds[2].init(params);
        params = new Hashtable();
        params.put("inferenceSideNb", "2");
        params.put("paramNames", "@mot^t:0#@mot^t:1");
        params.put("initType", "priorInit");
        params.put("priorType", "uniform");
        params.put("priorUniformVal", "" + val_norm);
        params.put("probaGlobal", "true");
        gpds[3].init(params);
        FunctionProbabilisticDistribution fpd1 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Occ^t_{(x_0,y_0)}");
        params.put("searchNames", "Obs^t_{(x_0,y_0)}");
        params.put("functionType", "SymObsMatrix2x2Function1D");
        params.put("functionParameters", "0.1");
        params.put("functionVariableNames", "(x_0,y_0)#L-Obs^t#R-Obs^t#occ^t_{(x_0,y_0)}");
        fpd1.init(params);
        FunctionProbabilisticDistribution fpd2 = new FunctionProbabilisticDistribution();
        params = new Hashtable();
        params.put("knownNames", "Sacc^t#Occ_{Vois(x_0,y_0)}^t");
        params.put("searchNames", "Occ_{(x_0,y_0)}^t");
        params.put("functionType", "AffectAntProbaFunction1D");
        params.put("functionParameters", "");
        params.put("functionVariableNames", "occ^t_{(x_0,y_0)}#(x_0,y_0)#val-ants_{(x_0,y_0)}");
        fpd2.init(params);
        this.getGridProbaDists().add(gpds[0]);
        this.getGridProbaDists().add(gpds[1]);
        this.getGridProbaDists().add(gpds[2]);
        this.getGridProbaDists().add(gpds[3]);
        this.getOthersProbaDists().add(fpd1);
        this.getOthersProbaDists().add(fpd2);
        this.prior_ok = false;
    }

    private static final byte[] convert1(int val, int pow) {
        byte[] valeurs = new byte[pow];
        int cpt = valeurs.length - 1;
        int i = val;
        while (i > 0) {
            valeurs[cpt--] = (byte)(i % 2);
            i >>= 1;
        }
        return valeurs;
    }

    private static final String bytesToString(byte[] valeurs) {
        String s = "";
        int j = 0;
        while (j < valeurs.length) {
            s = String.valueOf(s) + valeurs[j];
            ++j;
        }
        return s;
    }

    private static final byte[] convert2(int val, int pow) {
        String rep = Integer.toBinaryString(val);
        int taille = rep.length();
        int index = pow - taille;
        byte[] retour = new byte[pow];
        int i = 0;
        while (i < taille) {
            retour[index + i] = Byte.parseByte(String.valueOf(rep.charAt(i)));
            ++i;
        }
        return retour;
    }

    private static final void genereCombi(int powa) {
        int max_powa = (int)StrictMath.rint(StrictMath.pow(2.0, powa));
        int[] two_p = new int[powa];
        int i = 0;
        while (i < two_p.length) {
            two_p[i] = (int)StrictMath.rint(StrictMath.pow(2.0, i));
            ++i;
        }
        int[] cpts = new int[powa];
        byte[] values = new byte[powa];
        byte[] crt_comb = null;
        int i2 = 0;
        while (i2 < max_powa) {
            crt_comb = new byte[powa];
            int j = 0;
            while (j < crt_comb.length) {
                crt_comb[j] = values[j];
                int n = j;
                cpts[n] = cpts[n] + 1;
                if (cpts[j] % two_p[j] == 0) {
                    values[j] = (byte)((values[j] + 1) % 2);
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        V16_BossEngine.genereCombi(20);
    }

    protected Position decideSaccade() {
        throw new Error("Unresolved compilation problem: \n\tThe method decideSaccade() of type V16_BossEngine must override a superclass method\n");
    }

    protected Position decideSaccade(int n) {
        throw new Error("Unresolved compilation problem: \n\tThe type V16_BossEngine must implement the inherited abstract method BossEngine.decideSaccade(int)\n");
    }

    protected int[] solveTask() {
        throw new Error("Unresolved compilation problem: \n\tThe type V16_BossEngine must implement the inherited abstract method BossEngine.solveTask()\n");
    }
}

