/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.BossEngine;
import engine.Cell;
import engine.DebugPolicy;
import utils.Position;
import utils.Utilities;

public class StandartDebugPolicy
extends DebugPolicy {
    private String prodSt = "";
    private String antSt = "";
    private String captSt = "";

    public final void traceDebugInInf(BossEngine crtEng, Object[] params) throws Exception {
        String msg = "";
        int type = (Integer)params[0];
        switch (type) {
            case 0: {
                double epsilon = (Double)params[1];
                double p1 = (Double)params[2];
                double p2 = (Double)params[3];
                double[] proba_vois = (double[])params[5];
                double[] proba_prod = (double[])params[6];
                double[] proba_capt = (double[])params[7];
                msg = " [000] " + String.format("prod1 = %2.5f x (%2.5f x %2.5f + %2.5f x %2.5f) = %2.5f x %2.5f = %2.9f", proba_capt[0], 1.0 - epsilon, proba_vois[0], epsilon, proba_vois[1], proba_capt[0], p1, proba_prod[0]) + "\n";
                msg = String.valueOf(msg) + " [000] " + String.format("prod2 = %2.5f x (%2.5f x %2.5f + %2.5f x %2.5f) = %2.5f x %2.5f = %2.9f", proba_capt[1], epsilon, proba_vois[0], 1.0 - epsilon, proba_vois[1], proba_capt[1], p2, proba_prod[1]);
                System.out.println(msg);
                break;
            }
            case 10: {
                double prob1 = (Double)params[1];
                double prob2 = (Double)params[2];
                msg = String.valueOf(msg) + " [010] " + String.format("proba = %2.5f / %2.5f = ", prob1, prob2) + prob1 / prob2;
                System.out.println(msg);
                break;
            }
            case 20: {
                int[] val_ants = (int[])params[1];
                double proba1 = (Double)params[2];
                double proba2 = (Double)params[3];
                double proba3 = (Double)params[4];
                msg = String.valueOf(msg) + " [020] val_ants:" + Utilities.arrayToString(val_ants);
                msg = String.valueOf(msg) + String.format(" proba1 = %2.5f (%2d/20), proba2 = (", proba1, (int)StrictMath.rint(proba1 * 20.0), proba2);
                msg = String.valueOf(msg) + this.prodSt + ")" + String.format(" = %2.5f, proba_sum = %2.5f", proba2, proba3);
                System.out.println(msg);
                break;
            }
            case 21: {
                int[] val_ants = (int[])params[1];
                double proba1 = (Double)params[2];
                double proba2 = (Double)params[3];
                double proba3 = (Double)params[4];
                msg = String.valueOf(msg) + " [021] val_ants:" + Utilities.arrayToString(val_ants);
                msg = String.valueOf(msg) + "-" + this.antSt;
                msg = String.valueOf(msg) + String.format(" proba1 = %2.5f, proba2 = (", proba1, proba2);
                msg = String.valueOf(msg) + this.prodSt + ")" + String.format(" = %2.5f, proba_sum = %2.5f", proba2, proba3);
                System.out.println(msg);
                break;
            }
            case 30: {
                int x = (Integer)params[1];
                int y = (Integer)params[2];
                int side = (Integer)params[3];
                double proba_sum = (Double)params[4];
                msg = String.valueOf(msg) + " [030] gridpos: (" + x + "," + y + ":" + side + ")";
                msg = String.valueOf(msg) + " pas d'ant\ufffdc\ufffddents proba_sum:" + proba_sum;
                System.out.println(msg);
                break;
            }
            case 40: {
                int x = (Integer)params[1];
                int y = (Integer)params[2];
                int side = (Integer)params[3];
                double proba_sum = (Double)params[4];
                msg = String.valueOf(msg) + " [040] occ^t_{(" + x + "," + y + ":" + side + ")} = " + crtEng.getVariable("occ^t_{(x_0,y_0)}").getListVar(0) + " proba_sum:" + proba_sum;
                System.out.println(msg);
                break;
            }
            case 41: {
                double proba_sum = (Double)params[4];
                this.captSt = "" + proba_sum;
                break;
            }
            case 50: {
                this.prodSt = "";
                break;
            }
            case 60: {
                int crt_i = (Integer)params[1];
                int ant_length = (Integer)params[2];
                double proba = (Double)params[3];
                this.prodSt = String.valueOf(this.prodSt) + String.format("%2.5f", proba);
                if (crt_i == ant_length - 1) break;
                this.prodSt = String.valueOf(this.prodSt) + " x ";
                break;
            }
            case 70: {
                msg = String.valueOf(msg) + " [070] " + this.prodSt;
                System.out.println(msg);
                break;
            }
            case 80: {
                int x_0 = (Integer)params[1];
                int y_0 = (Integer)params[2];
                int side_0 = (Integer)params[3];
                int[] val_ants = (int[])params[4];
                int[] ants_numerosity = (int[])params[5];
                int var_val = (Integer)params[6];
                int val_occ = (Integer)params[7];
                int nb_occ = (Integer)params[8];
                msg = String.valueOf(msg) + " [080] gridpos: (" + x_0 + "," + y_0 + ":" + side_0 + ") ant_val(num):" + Utilities.arrayToString(val_ants, ants_numerosity) + " P(" + var_val + ")=" + val_occ + "/" + nb_occ + "]";
                System.out.println(msg);
                break;
            }
            case 81: {
                int[] val_ants = (int[])params[4];
                int[] ants_numerosity = (int[])params[5];
                int var_val = (Integer)params[6];
                int val_occ = (Integer)params[7];
                int nb_occ = (Integer)params[8];
                this.antSt = String.valueOf(Utilities.arrayToString(val_ants, ants_numerosity)) + " P(" + var_val + ")=" + val_occ + "/" + nb_occ;
                break;
            }
            case 90: {
                int x_0 = (Integer)params[1];
                int y_0 = (Integer)params[2];
                int side_0 = (Integer)params[3];
                int var1_val = (Integer)params[4];
                int var2_val = (Integer)params[5];
                double proba = (Double)params[6];
                msg = String.valueOf(msg) + " [090] gridpos: (" + x_0 + "," + y_0 + ":" + side_0 + "), obst^t = " + var1_val + ", occ^t = " + var2_val + " proba:" + proba;
                System.out.println(msg);
                break;
            }
            case 91: {
                int x_0 = (Integer)params[1];
                int y_0 = (Integer)params[2];
                int side_0 = (Integer)params[3];
                int var1_val = (Integer)params[4];
                int var2_val = (Integer)params[5];
                double proba = (Double)params[6];
                msg = String.valueOf(msg) + " [091] proba_sum x proba = " + this.captSt + " x " + proba + " (pour";
                msg = String.valueOf(msg) + " obst^t = " + var1_val + ", occ^t = " + var2_val + " sur [" + x_0 + "," + y_0 + ":" + side_0 + "])";
                System.out.println(msg);
                break;
            }
            case 101: {
                double proba_prior = (Double)params[1];
                double proba_choix = (Double)params[2];
                msg = String.valueOf(msg) + " [101] proba_prior x proba_choix = " + proba_prior + " x " + proba_choix;
                System.out.println(msg);
                break;
            }
            case 111: {
                this.prodSt = "";
                crtEng.getVariable("L-Fct1").setToDefaultValues();
                crtEng.getVariable("R-Fct1").setToDefaultValues();
                break;
            }
            case 121: {
                int x = (Integer)params[1];
                int y = (Integer)params[2];
                int side = (Integer)params[3];
                double proba_occ = (Double)params[4];
                double proba = (Double)params[5];
                double prod = (Double)params[6];
                if (side == 0) {
                    crtEng.getVariable("L-Fct1").setTableVar(x, y, proba, 0.0, 1.0);
                } else {
                    crtEng.getVariable("R-Fct1").setTableVar(x, y, proba, 0.0, 1.0);
                }
                this.prodSt = String.valueOf(this.prodSt) + String.format("%2.5f", proba) + " x ";
                Cell cell_t = Cell.getCell(crtEng.getObservations().get((int)0).position);
                if (x != cell_t.x || y != cell_t.y || side != cell_t.side) break;
                System.out.println(" [121] observation pos (" + x + "," + y + ":" + side + ")" + " proba_occ:" + proba_occ + " proba:" + proba + " prod:" + prod);
                break;
            }
            case 131: {
                msg = String.valueOf(msg) + " [131] " + this.prodSt;
                System.out.println(msg);
                break;
            }
            case 141: {
                double x = (Double)params[1];
                double y = (Double)params[2];
                double sx = (Double)params[3];
                double sy = (Double)params[4];
                int occ = (Integer)params[5];
                Cell cell_p = Cell.getCell(new Position(x, y, false));
                Cell cell_t = Cell.getCell(crtEng.getObservations().get((int)0).position);
                if (cell_p.x != cell_t.x || cell_p.y != cell_t.y) break;
                Cell cell_s = Cell.getCell(new Position(sx, sy, false));
                System.out.println(" [141] distancefct pos (" + cell_p.x + "," + cell_p.y + ") sacc:" + cell_s.x + "," + cell_s.y + ") occ^t=" + occ);
                String msg2 = " [141] ";
                msg2 = occ == 1 ? String.valueOf(msg2) + String.format("1/(1 +(pow(%2.5f -%2.5f, 2) +pow(%2.5f -%2.5f, 2))) = %2.5f", sx, x, sy, y, 1.0 / (1.0 + (StrictMath.pow(sx - x, 2.0) + StrictMath.pow(sy - y, 2.0)))) : String.valueOf(msg2) + String.format("1-(1/(1 +(pow(%2.5f -%2.5f, 2) +pow(%2.5f -%2.5f, 2d)))) = %2.5f", sx, x, sy, y, 1.0 - 1.0 / (1.0 + (StrictMath.pow(sx - x, 2.0) + StrictMath.pow(sy - y, 2.0))));
                System.out.println(msg2);
                break;
            }
            case 142: {
                double x = (Double)params[1];
                double y = (Double)params[2];
                double x_m = (Double)params[3];
                double y_m = (Double)params[4];
                double i = (Double)params[5];
                double alpha = (Double)params[6];
                double proba = (Double)params[7];
                Cell cell_i = Cell.getCell(new Position(x, y, false));
                Cell cell_t = Cell.getCell(crtEng.getObservations().get((int)0).position);
                if (cell_i.x != cell_t.x || cell_i.y != cell_t.y) break;
                String msg2 = " [142] ";
                msg2 = String.valueOf(msg2) + String.format("alpha=%2.5f, proba=%2.5f", alpha, proba);
                System.out.println(msg2);
            }
        }
    }

    public final void traceDebugPostInf(BossEngine crtEng, Object[] params) throws Exception {
    }

    public final void traceDebugPreInf(BossEngine crtEng, Object[] params) throws Exception {
        String msg = crtEng.getClass().getName();
        msg = String.valueOf(msg) + " grid pos : (" + params[0] + "," + params[1] + ":" + params[2] + ")";
        System.out.println("\n" + msg);
    }
}

