/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.GridProbabilisticDistribution;
import engine.RandomVariable;
import java.util.Hashtable;
import java.util.Random;
import utils.GridReferenceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeftRight_GridProbabilisticDistribution {
    private GridProbabilisticDistribution myLeftPart;
    private GridProbabilisticDistribution myRightPart;
    private String myName;

    public final String getName() {
        return this.myName;
    }

    protected final void setName(String name) {
        this.myName = name;
    }

    public final GridProbabilisticDistribution getRightPart() {
        return this.myRightPart;
    }

    private final void setRightPart(GridProbabilisticDistribution rightPart) {
        this.myRightPart = rightPart;
    }

    public final GridProbabilisticDistribution getLeftPart() {
        return this.myLeftPart;
    }

    private final void setLeftPart(GridProbabilisticDistribution leftPart) {
        this.myLeftPart = leftPart;
    }

    public LeftRight_GridProbabilisticDistribution(String type, GridReferenceConverter leftRConv, GridReferenceConverter rightRConv) {
        this.setLeftPart(GridProbabilisticDistribution.instanciate(type, leftRConv));
        this.setRightPart(GridProbabilisticDistribution.instanciate(type, rightRConv));
    }

    public final void init(Hashtable<String, String> params) {
        Hashtable l_params = (Hashtable)params.clone();
        Hashtable r_params = (Hashtable)params.clone();
        String[] key_names = new String[]{"knownNames", "searchNames", "paramNames", "functionVariableNames", "inferenceSideNb", "probaGlobal"};
        int i = 0;
        while (i < key_names.length) {
            String l_value_pars = "";
            String r_value_pars = "";
            if (params.get(key_names[i]) != null) {
                String[] key_pars = params.get(key_names[i]).split("#");
                int j = 0;
                while (j < key_pars.length) {
                    if (key_pars[j].indexOf("@") == -1 && key_pars[j].indexOf("!") == -1) {
                        l_value_pars = String.valueOf(l_value_pars) + "L-" + key_pars[j];
                        r_value_pars = String.valueOf(r_value_pars) + "R-" + key_pars[j];
                    } else {
                        String key_part;
                        if (key_pars[j].indexOf("@") != -1) {
                            key_part = key_pars[j].replaceAll("@", "");
                            l_value_pars = String.valueOf(l_value_pars) + key_part;
                            r_value_pars = String.valueOf(r_value_pars) + key_part;
                        }
                        if (key_pars[j].indexOf("!") != -1) {
                            key_part = key_pars[j].replaceAll("!", "");
                            l_value_pars = String.valueOf(l_value_pars) + "L-" + key_part + "#R-" + key_part;
                            r_value_pars = String.valueOf(r_value_pars) + "L-" + key_part + "#R-" + key_part;
                        }
                    }
                    if (j != key_pars.length - 1) {
                        l_value_pars = String.valueOf(l_value_pars) + "#";
                        r_value_pars = String.valueOf(r_value_pars) + "#";
                    }
                    ++j;
                }
                l_params.put(key_names[i], l_value_pars);
                r_params.put(key_names[i], r_value_pars);
            }
            ++i;
        }
        String name = "";
        if (params.get("inferenceSideNb") == null) {
            String n;
            name = String.valueOf(name) + "P(";
            String[] stringArray = params.get("searchNames").split("#");
            int n2 = 0;
            int n3 = stringArray.length;
            while (n2 < n3) {
                n = stringArray[n2];
                name = String.valueOf(name) + n;
                ++n2;
            }
            if (params.get("knownNames") != null) {
                name = String.valueOf(name) + "|";
                stringArray = params.get("knownNames").split("#");
                n2 = 0;
                n3 = stringArray.length;
                while (n2 < n3) {
                    n = stringArray[n2];
                    name = String.valueOf(name) + n;
                    ++n2;
                }
            }
            name = String.valueOf(name) + ")";
        } else {
            name = String.valueOf(name) + "Q_" + params.get("inferenceSideNb");
        }
        this.setName(name);
        boolean probaGlobal = params.get("probaGlobal") == "true";
        this.myLeftPart.setProbaGlobal(probaGlobal);
        this.myRightPart.setProbaGlobal(probaGlobal);
        if (params.get("R-X1X2ZeroPos") != null || params.get("L-X1X2ZeroPos") != null) {
            l_params.put("X1X2ZeroPos", params.get("L-X1X2ZeroPos"));
            r_params.put("X1X2ZeroPos", params.get("R-X1X2ZeroPos"));
        }
        this.getLeftPart().init(l_params);
        this.getRightPart().init(r_params);
    }

    public String toString() {
        return this.getLeftPart() + "\n" + this.getRightPart();
    }

    public final void newComputationReset(Hashtable<String, RandomVariable> vars) {
        this.getLeftPart().newComputationReset(vars);
        this.getRightPart().newComputationReset(vars);
    }

    public double[] getMinMax() {
        double[] lMinMax = this.getLeftPart().getMinMax();
        double[] rMinMax = this.getRightPart().getMinMax();
        double min = lMinMax[0];
        double max = lMinMax[1];
        if (rMinMax[0] < min) {
            min = rMinMax[0];
        }
        if (rMinMax[1] > max) {
            max = rMinMax[1];
        }
        if ((max - min) / max >= 0.75) {
            min = 0.0;
        }
        if (min == max) {
            min *= 0.9;
            max *= 1.1;
        }
        if (max == 0.0) {
            max = 1.0;
        }
        return new double[]{min, max};
    }

    public int[] draw() {
        int j;
        int i;
        int s;
        double p = new Random().nextDouble();
        float[] res_l = this.getLeftPart().drawHalf();
        float[] res_r = this.getRightPart().drawHalf();
        if (p * (double)(res_r[2] + res_l[2]) > (double)res_r[2]) {
            s = 0;
            i = StrictMath.round(res_l[0]);
            j = StrictMath.round(res_l[1]);
        } else {
            s = 1;
            i = StrictMath.round(res_r[0]);
            j = StrictMath.round(res_r[1]);
        }
        return new int[]{i, j, s};
    }
}

