/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.ProbabilisticDistribution;
import engine.RandomVariable;
import java.util.Hashtable;
import java.util.Random;
import utils.GridReferenceConverter;
import utils.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GridProbabilisticDistribution
extends ProbabilisticDistribution {
    private GridReferenceConverter myGridRefConverter;
    private String myPreferedVariableName;
    private String myOnGridVariableName;
    private boolean isGridValuesSet = false;
    private double[][] myGridValues;
    private boolean probaGlobal;

    public boolean isProbaGlobal() {
        return this.probaGlobal;
    }

    protected final GridReferenceConverter getGridRefConverter() {
        return this.myGridRefConverter;
    }

    private final void setGridRefConverter(GridReferenceConverter gridRefConverter) {
        this.myGridRefConverter = gridRefConverter;
    }

    public final String getOnGridVariableName() {
        return this.myOnGridVariableName;
    }

    private final void setOnGridVariableName(String onGridVariableName) {
        this.myOnGridVariableName = onGridVariableName;
    }

    public final String getPreferedVariableName() {
        return this.myPreferedVariableName;
    }

    public final void setPreferedVariableName(String preferedVariableName) {
        this.myPreferedVariableName = preferedVariableName;
    }

    protected final boolean isGridValuesSet() {
        return this.isGridValuesSet;
    }

    protected final void setGridValuesSet(boolean isGridValuesSet) {
        this.isGridValuesSet = isGridValuesSet;
    }

    protected final double[][] getGridValues() {
        return this.myGridValues;
    }

    protected final void setGridValues(double[][] gridValues) {
        this.myGridValues = gridValues;
    }

    private final void setValue(int x1, int x2, double val) {
        this.myGridValues[x1][x2] = val;
    }

    protected GridProbabilisticDistribution() {
    }

    public GridProbabilisticDistribution(GridReferenceConverter refConv) {
        this.setGridRefConverter(refConv);
    }

    @Override
    protected final void subInit(Hashtable<String, String> params) {
        int d1_nb = this.getGridRefConverter().getPixelWidth();
        int d2_nb = this.getGridRefConverter().getPixelHeight();
        this.setGridValues(new double[d1_nb][d2_nb]);
        if (params.get("initType") != null && params.get("initType").equals("priorInit")) {
            this.initPriorTable(params);
        } else {
            String string = String.valueOf(this.getClass().getName()) + "::subInit -warning: " + this.getName() + " initialized with 0.0";
        }
        if (this.getInferenceName() == null) {
            this.setPreferedVariableName(this.getSearchVarName(0));
        }
        this.subSubInit(params);
    }

    private final void initPriorTable(Hashtable<String, String> params) {
        if (params.get("priorType").equals("uniform")) {
            double value = Double.parseDouble(params.get("priorUniformVal"));
            int i1 = 0;
            while (i1 < this.getGridValues().length) {
                int i2 = 0;
                while (i2 < this.getGridValues()[i1].length) {
                    this.setValue(i1, i2, value);
                    ++i2;
                }
                ++i1;
            }
        }
    }

    public final double[][] getProbaGrid(Hashtable<String, RandomVariable> vars, String probaVarName) throws Exception {
        this.setGridValuesSet(false);
        this.setProbaGrid(vars, probaVarName);
        if (!this.isGridValuesSet()) {
            String msg = "GridProbabilisticDistribution (" + this.getClass().getName() + ";" + this.getName() + ") ::getProbaGrid -error: proba grid not set for " + probaVarName;
            throw new Exception(msg);
        }
        this.setOnGridVariableName(probaVarName);
        return this.getGridValues();
    }

    public static final GridProbabilisticDistribution instanciate(String type, GridReferenceConverter refConv) {
        String msg1 = "GridProbabilisticDistribution";
        String msg2 = "instanciate type:" + type + " refConv:" + refConv;
        GridProbabilisticDistribution retour = null;
        try {
            retour = (GridProbabilisticDistribution)Class.forName("engine." + type).newInstance();
        }
        catch (IllegalAccessException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        catch (ClassNotFoundException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        catch (InstantiationException e) {
            Utilities.exceptionCaughtMessageInStaticContext(e, msg1, msg2);
        }
        super.setGridRefConverter(refConv);
        return retour;
    }

    public final double[][] getProbaGrid(Hashtable<String, RandomVariable> vars) throws Exception {
        return this.getProbaGrid(vars, this.getPreferedVariableName());
    }

    @Override
    protected String toShortString() {
        return String.valueOf(super.toShortString()) + "\n\t<PreferredName=" + this.getPreferedVariableName() + ">";
    }

    protected abstract void setProbaGrid(Hashtable<String, RandomVariable> var1, String var2);

    protected abstract void subSubInit(Hashtable<String, String> var1);

    public void setProbaGlobal(boolean probaGlobal) {
        this.probaGlobal = probaGlobal;
    }

    public double[] getMinMax() {
        double min = 1.0;
        double max = 0.0;
        double p = 0.0;
        int i = 0;
        while (i < this.getGridValues().length) {
            int j = 0;
            while (j < this.getGridValues()[i].length) {
                p = this.getGridValues()[i][j];
                if (p < min) {
                    min = p;
                } else if (p > max) {
                    max = p;
                }
                ++j;
            }
            ++i;
        }
        return new double[]{min, max};
    }

    public final float getSum() {
        float sum = 0.0f;
        int i = 0;
        while (i < this.getGridValues().length) {
            int j = 0;
            while (j < this.getGridValues()[i].length) {
                sum = (float)((double)sum + this.getGridValues()[i][j]);
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public int[] draw() {
        double p = new Random().nextDouble();
        int j = 0;
        p *= (double)this.getSum();
        int i = 0;
        while (i < this.getGridValues().length) {
            j = 0;
            while (j < this.getGridValues()[i].length) {
                double d;
                p -= this.getGridValues()[i][j];
                if (d <= 0.0) break;
                ++j;
            }
            ++i;
        }
        return new int[]{i, j};
    }

    public float[] drawHalf() {
        double p = new Random().nextDouble();
        int j = 0;
        float sum = this.getSum();
        p *= (double)sum;
        int i = 0;
        while (i < this.getGridValues().length) {
            j = 0;
            while (j < this.getGridValues()[i].length) {
                double d;
                p -= this.getGridValues()[i][j];
                if (d <= 0.0) break;
                ++j;
            }
            if (p <= 0.0) break;
            ++i;
        }
        return new float[]{i, j, sum};
    }
}

