/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.GridProbabilisticDistribution;
import engine.RandomVariable;
import java.util.Hashtable;
import utils.GridReferenceConverter;
import utils.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPD_Table3D
extends GridProbabilisticDistribution {
    private double[][][] myNewValues;
    private double[][][] myValues;

    private final double[][][] getNewValues() {
        return this.myNewValues;
    }

    private final void setNewValues(double[][][] myNewValues) {
        this.myNewValues = myNewValues;
    }

    private final void setNewValue(int x1, int x2, int x3, double newVal) {
        this.myNewValues[x1][x2][x3] = newVal;
    }

    private final double[][][] getValues() {
        return this.myValues;
    }

    private final void setValues(double[][][] values) {
        this.myValues = values;
    }

    private final void setValue(int x1, int x2, int x3, double val) {
        this.myValues[x1][x2][x3] = val;
    }

    protected GPD_Table3D() {
    }

    public GPD_Table3D(GridReferenceConverter refConv) {
        super(refConv);
    }

    @Override
    protected final void subSubInit(Hashtable<String, String> params) {
        int d1_nb = 2;
        int d2_nb = this.getGridRefConverter().getPixelWidth();
        int d3_nb = this.getGridRefConverter().getPixelHeight();
        this.setValues(new double[d1_nb][d2_nb][d3_nb]);
        this.setNewValues(new double[d1_nb][d2_nb][d3_nb]);
        if (params.get("initType").equals("priorInit")) {
            this.initPriorTable(params);
        }
    }

    private final void initPriorTable(Hashtable<String, String> params) {
        String msg = String.valueOf(this.getClass().getName()) + "::initPriorTable -infos: " + this.getName();
        if (params.get("priorType").equals("uniform")) {
            int i3;
            double value = Double.parseDouble(params.get("priorUniformVal"));
            int i1 = 0;
            int i2 = 0;
            while (i2 < this.getValues()[i1].length) {
                i3 = 0;
                while (i3 < this.getValues()[i1][i2].length) {
                    this.setValue(i1, i2, i3, 1.0 - value);
                    ++i3;
                }
                ++i2;
            }
            i1 = 1;
            i2 = 0;
            while (i2 < this.getValues()[i1].length) {
                i3 = 0;
                while (i3 < this.getValues()[i1][i2].length) {
                    this.setValue(i1, i2, i3, value);
                    ++i3;
                }
                ++i2;
            }
        }
    }

    @Override
    protected void setProbaGrid(Hashtable<String, RandomVariable> vars, String probaVarName) {
        this.setGridValues(this.getValues()[1]);
        this.setGridValuesSet(true);
    }

    @Override
    public double getValue(Hashtable<String, RandomVariable> vars) throws Exception {
        int entry0 = this.getPar1(vars);
        int entry1 = this.getPar2(vars);
        int entry2 = this.getPar3(vars);
        return this.getValues()[entry0][entry1][entry2];
    }

    @Override
    public final void setNewValue(Hashtable<String, RandomVariable> vars, double newProba) {
        int entry0 = this.getPar1(vars);
        int entry1 = this.getPar2(vars);
        int entry2 = this.getPar3(vars);
        this.setNewValue(entry0, entry1, entry2, newProba);
    }

    @Override
    public final void updateValues() {
        this.setValues(Utilities.tabClone(this.getNewValues()));
    }

    @Override
    protected final void newComputationReset(Hashtable<String, RandomVariable> vars) {
    }

    @Override
    public final String toShortString() {
        String s = String.valueOf(super.toShortString()) + "<values>\n";
        int i = 0;
        while (i < this.getValues().length) {
            s = String.valueOf(s) + Utilities.arrayToString(this.getValues()[i], 100.0) + "\n";
            ++i;
        }
        s = String.valueOf(s) + "</values>";
        return s;
    }
}

