/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.GridProbabilisticDistribution;
import engine.RandomVariable;
import java.util.Hashtable;
import utils.GridReferenceConverter;
import utils.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPD_Table2D
extends GridProbabilisticDistribution {
    private double[][] myNewGrigValues;

    private final double[][] getNewGrigValues() {
        return this.myNewGrigValues;
    }

    private final void setNewGrigValues(double[][] newGrigValue) {
        this.myNewGrigValues = newGrigValue;
    }

    private final void setNewGrigValue(int x1, int x2, double newVal) {
        this.myNewGrigValues[x1][x2] = newVal;
    }

    protected GPD_Table2D() {
    }

    public GPD_Table2D(GridReferenceConverter refConv) {
        super(refConv);
    }

    @Override
    protected final void setProbaGrid(Hashtable<String, RandomVariable> vars, String probaVarName) {
        this.setGridValuesSet(true);
    }

    @Override
    public final double getValue(Hashtable<String, RandomVariable> vars) throws Exception {
        int entry0 = this.getPar1(vars);
        int entry1 = this.getPar2(vars);
        return this.getGridValues()[entry0][entry1];
    }

    @Override
    public final void setNewValue(Hashtable<String, RandomVariable> vars, double newProba) {
        int entry0 = this.getPar1(vars);
        int entry1 = this.getPar2(vars);
        this.setNewGrigValue(entry0, entry1, newProba);
    }

    @Override
    public final void updateValues() {
        this.setGridValues(this.getNewGrigValues());
    }

    @Override
    protected final void subSubInit(Hashtable<String, String> params) {
        int d1_nb = this.getGridRefConverter().getPixelWidth();
        int d2_nb = this.getGridRefConverter().getPixelHeight();
        this.setNewGrigValues(new double[d1_nb][d2_nb]);
    }

    @Override
    protected final void newComputationReset(Hashtable<String, RandomVariable> vars) {
    }

    @Override
    public final String toShortString() {
        String s = String.valueOf(super.toShortString()) + "<values>\n";
        s = String.valueOf(s) + Utilities.arrayToString(this.getGridValues(), 1.0) + "\n";
        s = String.valueOf(s) + "</values>";
        return s;
    }
}

