/*
 * Decompiled with CFR 0.152.
 */
package engine;

import gui.BossApplication;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import utils.GridReferenceConverter;
import utils.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell {
    public int x;
    public int y;
    public byte side;
    public boolean isRight;
    public boolean isInsideTheGrid;
    public double absoluteCenterX2;
    public double absoluteCenterY2;
    public Position centerPos;
    public Cell[] closeVicinity;
    private static int DEFAULT_DISCRETIZE_PT_NB = 100;
    public static GridReferenceConverter leftGridRefConverter = new GridReferenceConverter(false);
    public static GridReferenceConverter rightGridRefConverter = new GridReferenceConverter(true);
    public static Cell[][][] gridCells;

    private Cell(int x, int y, boolean isRight) {
        this.x = x;
        this.y = y;
        this.isRight = isRight;
        GridReferenceConverter grc = null;
        if (this.isRight) {
            this.side = 1;
            grc = rightGridRefConverter;
        } else {
            this.side = 0;
            grc = leftGridRefConverter;
        }
        this.absoluteCenterX2 = grc.xBasic(this.x);
        this.absoluteCenterY2 = grc.yBasic(this.y);
        this.centerPos = new Position(this.absoluteCenterX2, this.absoluteCenterY2, false);
    }

    public static final Object[][] init(Hashtable<String, String> params) {
        int j;
        double cellw = Double.parseDouble(params.get("cellWidth"));
        double cellh = Double.parseDouble(params.get("cellHeight"));
        double[] l_xrange = new double[]{-4.8 + cellw / 2.0, cellw / 2.0, 1.0};
        double[] r_xrange = new double[]{-cellw / 2.0, 4.8 - cellw / 2.0, 1.0};
        double[] yrange = new double[]{-2.9, 2.9, 1.0};
        int l_gridw = (int)StrictMath.rint((l_xrange[1] - l_xrange[0]) / cellw);
        int r_gridw = (int)StrictMath.rint((r_xrange[1] - r_xrange[0]) / cellw);
        int gridh = (int)StrictMath.rint((yrange[1] - yrange[0]) / cellh);
        leftGridRefConverter.init(l_xrange[0], yrange[0], l_xrange[1], yrange[1], l_gridw, gridh);
        rightGridRefConverter.init(r_xrange[0], yrange[0], r_xrange[1], yrange[1], r_gridw, gridh);
        gridCells = new Cell[2][l_gridw][gridh];
        int i = 0;
        while (i < l_gridw) {
            j = 0;
            while (j < gridh) {
                Cell.gridCells[0][i][j] = new Cell(i, j, false);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < l_gridw) {
            j = 0;
            while (j < gridh) {
                Cell.gridCells[1][i][j] = new Cell(i, j, true);
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < 2) {
            int i2 = 0;
            while (i2 < l_gridw) {
                int j2 = 0;
                while (j2 < gridh) {
                    gridCells[k][i2][j2].setCellCloseVicinity();
                    ++j2;
                }
                ++i2;
            }
            ++k;
        }
        return new Object[][]{{l_gridw, r_gridw, gridh}, {l_xrange[0], l_xrange[1], r_xrange[0], r_xrange[1]}, {yrange[0], yrange[1]}, {cellw, cellh}, new Object[1], new Object[1]};
    }

    private final void setCellCloseVicinity() {
        boolean debug = false;
        Vector<Cell> vec_vicinity = new Vector<Cell>();
        Cell vic_cell = Cell.getCell(this.centerPos);
        if (vic_cell != null) {
            if (!this.isRight && vic_cell.isRight) {
                this.addVicinity(vec_vicinity, vic_cell, debug);
            }
            if (this.isRight && !vic_cell.isRight) {
                this.addVicinity(vec_vicinity, vic_cell, debug);
            }
        }
        if (debug) {
            Cell.addMark(this.centerPos, "center_pos");
        }
        double rand_x2 = -1.0;
        double rand_y2 = -1.0;
        Position crt_pos = null;
        double cellw = leftGridRefConverter.getCellWidth();
        double cellh = leftGridRefConverter.getCellHeight();
        Random R = new Random(15091978L);
        int i = 0;
        while (i < DEFAULT_DISCRETIZE_PT_NB) {
            rand_x2 = this.absoluteCenterX2 + (R.nextDouble() - 0.5) * cellw;
            rand_y2 = this.absoluteCenterY2 + (R.nextDouble() - 0.5) * cellh;
            crt_pos = new Position(rand_x2, rand_y2, false);
            if (debug) {
                Cell.addMark(crt_pos, "rand_" + i);
            }
            if ((vic_cell = Cell.getCell(crt_pos)) != null && !vec_vicinity.contains(vic_cell)) {
                this.addVicinity(vec_vicinity, vic_cell, debug);
            }
            ++i;
        }
        this.closeVicinity = new Cell[vec_vicinity.size()];
        i = 0;
        while (i < this.closeVicinity.length) {
            this.closeVicinity[i] = vec_vicinity.get(i);
            ++i;
        }
        this.isInsideTheGrid = false;
        Cell[] cellArray = this.closeVicinity;
        int n = 0;
        int n2 = cellArray.length;
        while (n < n2) {
            Cell vic_cell2 = cellArray[n];
            if (vic_cell2 == this) {
                this.isInsideTheGrid = true;
                break;
            }
            ++n;
        }
    }

    public static final Cell getCell(Position pos) {
        int cell_y;
        int cell_x;
        int side = -1;
        GridReferenceConverter[] grc = new GridReferenceConverter[]{leftGridRefConverter, rightGridRefConverter};
        side = pos.getX1() >= 0.0 ? 1 : 0;
        if (!grc[side].isBasicPosInsideTheGrid(pos.getX2(), pos.getY2())) {
            side = 1 - side;
        }
        if (grc[side].isPixelPosInsideTheGrid(cell_x = grc[side].xPixel(pos.getX2()), cell_y = grc[side].yPixel(pos.getY2()))) {
            return gridCells[side][cell_x][cell_y];
        }
        return null;
    }

    public final String toString() {
        String s = "<Cell side=";
        s = this.isRight ? String.valueOf(s) + "right " : String.valueOf(s) + " left ";
        s = String.valueOf(s) + "(" + this.side + ") coords= " + this.x + "," + this.y + " centerPos=" + this.centerPos + ">";
        return s;
    }

    private final void addVicinity(Vector<Cell> vec_vic, Cell aCell, boolean debug) {
        if (debug) {
            System.out.println("adding the cell" + aCell);
        }
        vec_vic.add(aCell);
    }

    private static final void addMark(Position pos, String label) {
        Position n_pos = new Position(pos);
        BossApplication.bossEngine.addMark(n_pos, label);
    }

    public static final int[] getZeroGridPos(boolean isRight) {
        GridReferenceConverter grc = null;
        grc = isRight ? rightGridRefConverter : leftGridRefConverter;
        return new int[]{grc.xPixel(0.0), grc.yPixel(0.0)};
    }
}

