/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Cell;
import gui.BossApplication;
import java.util.Random;
import java.util.Vector;
import utils.Position;

public class Antecedent {
    public Position finalPos;
    public Position antecedentPos;
    public Cell finalCell;
    public Cell antCell;
    private static Position translation;
    private static int DEFAULT_DISCRETIZE_PT_NB;
    private static Antecedent[][][][] gridAnts;
    private static Cell[][][][] gridAntsCells;
    public static int[][][][] gridAntsNumerosity;

    static {
        DEFAULT_DISCRETIZE_PT_NB = 20;
    }

    private Antecedent(Position finPos) {
        this.finalPos = finPos;
        this.finalCell = Cell.getCell(this.finalPos);
        this.antecedentPos = new Position(this.finalPos);
        this.antecedentPos.applyRef1Translation(translation, true);
        this.antCell = Cell.getCell(this.antecedentPos);
    }

    public static final void setAllAntecedentsFromATranslation(Position trans) {
        int j;
        translation = trans;
        int gridw = Cell.leftGridRefConverter.getPixelWidth();
        int gridh = Cell.leftGridRefConverter.getPixelHeight();
        gridAnts = new Antecedent[2][gridw][gridh][];
        gridAntsCells = new Cell[2][gridw][gridh][];
        gridAntsNumerosity = new int[2][gridw][gridh][];
        int i = 0;
        while (i < gridw) {
            j = 0;
            while (j < gridh) {
                Antecedent.setACellAnts(i, j, true);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < gridw) {
            j = 0;
            while (j < gridh) {
                Antecedent.setACellAnts(i, j, false);
                ++j;
            }
            ++i;
        }
    }

    private static final void setACellAnts(int x, int y, boolean isRight) {
        int side = -1;
        side = isRight ? 1 : 0;
        Cell final_cell = Cell.gridCells[side][x][y];
        double rand_x2 = -1.0;
        double rand_y2 = -1.0;
        Antecedent crt_ant = null;
        Random R = new Random(15091978L);
        Vector<Cell> vec_cells = new Vector<Cell>();
        Vector<Integer> vec_num = new Vector<Integer>();
        Vector<Antecedent> vec_ants = new Vector<Antecedent>();
        double cellw = Cell.leftGridRefConverter.getCellWidth();
        double cellh = Cell.leftGridRefConverter.getCellHeight();
        int i = 0;
        while (i < DEFAULT_DISCRETIZE_PT_NB) {
            rand_x2 = final_cell.centerPos.getX2() + (R.nextDouble() - 0.5 + 0.3 * R.nextGaussian()) * cellw;
            rand_y2 = final_cell.centerPos.getY2() + (R.nextDouble() - 0.5 + 0.3 * R.nextGaussian()) * cellh;
            crt_ant = new Antecedent(new Position(rand_x2, rand_y2, false));
            vec_ants.add(crt_ant);
            if (crt_ant.antCell != null) {
                if (!vec_cells.contains(crt_ant.antCell)) {
                    vec_num.add(1);
                    vec_cells.add(crt_ant.antCell);
                } else {
                    int index = vec_cells.indexOf(crt_ant.antCell);
                    vec_num.set(index, (Integer)vec_num.get(index) + 1);
                }
            }
            ++i;
        }
        Antecedent.gridAnts[side][x][y] = new Antecedent[vec_ants.size()];
        i = 0;
        while (i < vec_ants.size()) {
            Antecedent.gridAnts[side][x][y][i] = (Antecedent)vec_ants.get(i);
            ++i;
        }
        Antecedent.gridAntsCells[side][x][y] = new Cell[vec_cells.size()];
        i = 0;
        while (i < vec_cells.size()) {
            Antecedent.gridAntsCells[side][x][y][i] = (Cell)vec_cells.get(i);
            ++i;
        }
        Antecedent.gridAntsNumerosity[side][x][y] = new int[vec_num.size()];
        i = 0;
        while (i < vec_num.size()) {
            Antecedent.gridAntsNumerosity[side][x][y][i] = (Integer)vec_num.get(i);
            ++i;
        }
    }

    private static final void addMark(Position pos, String label) {
        Position n_pos = new Position(pos);
        BossApplication.bossEngine.addMark(n_pos, label);
    }

    public static final Cell[] getCells(Cell origine) {
        if (gridAntsCells != null) {
            return gridAntsCells[origine.side][origine.x][origine.y];
        }
        return null;
    }

    public static final int[] getNumerosity(Cell origine) {
        return gridAntsNumerosity[origine.side][origine.x][origine.y];
    }

    public static final Cell[] getCells(int x, int y, int side) {
        return Antecedent.getCells(Cell.gridCells[side][x][y]);
    }

    public static final Cell[] getCells(int x, int y, boolean isRight) {
        if (isRight) {
            return Antecedent.getCells(Cell.gridCells[1][x][y]);
        }
        return Antecedent.getCells(Cell.gridCells[0][x][y]);
    }

    public static final int getMaxAntecedentsNb() {
        return DEFAULT_DISCRETIZE_PT_NB;
    }
}

